/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cc;

import java.util.Arrays;

public class XDJA_SM2_PARAM {
    private static final String TAG = "CoverCard";
    public static final int SM2_KEY_LEN = 32;
    public static final int SIZE = 192;
    public byte[] p = new byte[32];
    public byte[] a = new byte[32];
    public byte[] b = new byte[32];
    public byte[] n = new byte[32];
    public byte[] x = new byte[32];
    public byte[] y = new byte[32];

    public XDJA_SM2_PARAM() {
    }

    public XDJA_SM2_PARAM(String data) {
        this.parse(data);
    }

    public int parse(String data) {
        int end;
        int i2;
        if (data.length() < 384) {
            return -1;
        }
        int start = 0;
        for (i2 = 0; i2 < 32; ++i2) {
            end = start + 2;
            this.p[i2] = (byte)(Integer.parseInt(data.substring(start, end), 16) & 0xFF);
            start = end;
        }
        for (i2 = 0; i2 < 32; ++i2) {
            end = start + 2;
            this.a[i2] = (byte)(Integer.parseInt(data.substring(start, end), 16) & 0xFF);
            start = end;
        }
        for (i2 = 0; i2 < 32; ++i2) {
            end = start + 2;
            this.b[i2] = (byte)(Integer.parseInt(data.substring(start, end), 16) & 0xFF);
            start = end;
        }
        for (i2 = 0; i2 < 32; ++i2) {
            end = start + 2;
            this.n[i2] = (byte)(Integer.parseInt(data.substring(start, end), 16) & 0xFF);
            start = end;
        }
        for (i2 = 0; i2 < 32; ++i2) {
            end = start + 2;
            this.x[i2] = (byte)(Integer.parseInt(data.substring(start, end), 16) & 0xFF);
            start = end;
        }
        for (i2 = 0; i2 < 32; ++i2) {
            end = start + 2;
            this.y[i2] = (byte)(Integer.parseInt(data.substring(start, end), 16) & 0xFF);
            start = end;
        }
        return 0;
    }

    public XDJA_SM2_PARAM(byte[] p, byte[] a2, byte[] b2, byte[] n, byte[] x, byte[] y) {
        System.arraycopy(p, 0, this.p, 0, 32);
        System.arraycopy(a2, 0, this.a, 0, 32);
        System.arraycopy(b2, 0, this.b, 0, 32);
        System.arraycopy(n, 0, this.n, 0, 32);
        System.arraycopy(x, 0, this.x, 0, 32);
        System.arraycopy(y, 0, this.y, 0, 32);
    }

    public String toApduData() {
        int i2;
        StringBuilder builder = new StringBuilder("");
        for (i2 = 0; i2 < 32; ++i2) {
            builder.append(String.format("%02x", this.p[i2]));
        }
        for (i2 = 0; i2 < 32; ++i2) {
            builder.append(String.format("%02x", this.a[i2]));
        }
        for (i2 = 0; i2 < 32; ++i2) {
            builder.append(String.format("%02x", this.b[i2]));
        }
        for (i2 = 0; i2 < 32; ++i2) {
            builder.append(String.format("%02x", this.n[i2]));
        }
        for (i2 = 0; i2 < 32; ++i2) {
            builder.append(String.format("%02x", this.x[i2]));
        }
        for (i2 = 0; i2 < 32; ++i2) {
            builder.append(String.format("%02x", this.y[i2]));
        }
        return builder.toString();
    }

    public int size() {
        return 192;
    }

    public boolean equals(XDJA_SM2_PARAM sm2param) {
        if (sm2param == null) {
            return false;
        }
        return Arrays.equals(this.y, sm2param.y) && Arrays.equals(this.x, sm2param.x) && Arrays.equals(this.n, sm2param.n) && Arrays.equals(this.b, sm2param.b) && Arrays.equals(this.a, sm2param.a) && Arrays.equals(this.p, sm2param.p);
    }
}

