/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import java.io.IOException;
import org.simalliance.openmobileapi.Channel;
import org.simalliance.openmobileapi.Provider;
import org.simalliance.openmobileapi.internal.ErrorStrings;
import org.simalliance.openmobileapi.util.CommandApdu;
import org.simalliance.openmobileapi.util.ResponseApdu;

public class AuthenticationProvider
extends Provider {
    public AuthenticationProvider(Channel channel) throws IllegalStateException {
        super(channel);
    }

    public boolean verifyPin(PinID pinID, byte[] pin) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException, IOException {
        if (pinID == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("pinID"));
        }
        if (pin == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("pin"));
        }
        if (pin.length == 0 || pin.length > 65535) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("pin"));
        }
        byte p2 = (byte)pinID.getID();
        if (pinID.isLocal()) {
            p2 = (byte)(p2 | 0x80);
        }
        if (pin.length > 255) {
            throw new IllegalArgumentException("PIN too long");
        }
        CommandApdu apdu = new CommandApdu(0, 32, 0, p2, pin);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                return true;
            }
            case 25344: {
                return false;
            }
            case 27011: {
                return false;
            }
            case 27012: {
                return false;
            }
            case 26368: {
                return false;
            }
            case 27265: {
                throw new UnsupportedOperationException();
            }
            case 27270: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27272: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27392: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
        }
        if (25536 <= swValue && swValue <= 25551) {
            return false;
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public void changePin(PinID pinID, byte[] oldPin, byte[] newPin) throws SecurityException, IllegalArgumentException, IllegalStateException, UnsupportedOperationException, IOException {
        if (pinID == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("pinID"));
        }
        if (oldPin == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("oldPin"));
        }
        if (newPin == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("newPin"));
        }
        if (oldPin.length == 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("oldPin"));
        }
        if (newPin.length == 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("newPin"));
        }
        byte p2 = (byte)pinID.getID();
        if (pinID.isLocal()) {
            p2 = (byte)(p2 | 0x80);
        }
        byte[] data = new byte[oldPin.length + newPin.length];
        System.arraycopy((byte[])oldPin, (int)0, (byte[])data, (int)0, (int)oldPin.length);
        System.arraycopy((byte[])newPin, (int)0, (byte[])data, (int)oldPin.length, (int)newPin.length);
        if (data.length > 255) {
            throw new IllegalArgumentException("PIN too long");
        }
        CommandApdu apdu = new CommandApdu(0, 36, 0, p2, data);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                break;
            }
            case 25344: {
                throw new SecurityException("Wrong PIN.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27011: {
                throw new SecurityException("Referenced PIN is blocked.");
            }
            case 27012: {
                throw new SecurityException("Referenced PIN is blocked.");
            }
            case 27265: {
                throw new UnsupportedOperationException();
            }
            case 27270: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27392: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
            default: {
                if (25536 <= swValue && swValue <= 25551) {
                    throw new SecurityException("Wrong PIN.");
                }
                throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
            }
        }
    }

    public void resetPin(PinID pinID, byte[] resetPin, byte[] newPin) throws SecurityException, IllegalArgumentException, IllegalStateException, UnsupportedOperationException, IOException {
        byte[] data;
        if (pinID == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("pinID"));
        }
        if (resetPin == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("resetPin"));
        }
        if (resetPin.length == 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("resetPin"));
        }
        if (newPin != null && newPin.length == 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("newPin"));
        }
        byte p1 = newPin != null ? (byte)0 : 1;
        byte p2 = (byte)pinID.getID();
        if (pinID.isLocal()) {
            p2 = (byte)(p2 | 0x80);
        }
        if ((data = newPin != null ? new byte[resetPin.length + newPin.length] : new byte[resetPin.length]).length > 255) {
            throw new IllegalArgumentException("PIN too long");
        }
        System.arraycopy((byte[])resetPin, (int)0, (byte[])data, (int)0, (int)resetPin.length);
        if (newPin != null) {
            System.arraycopy((byte[])newPin, (int)0, (byte[])data, (int)resetPin.length, (int)newPin.length);
        }
        CommandApdu apdu = new CommandApdu(0, 44, p1, p2, data);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                break;
            }
            case 25344: {
                throw new SecurityException("Wrong PIN.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27011: {
                throw new SecurityException("Referenced PIN is blocked.");
            }
            case 27012: {
                throw new SecurityException("Referenced PIN is blocked.");
            }
            case 27265: {
                throw new UnsupportedOperationException();
            }
            case 27270: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27392: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
            default: {
                if (25536 <= swValue && swValue <= 25551) {
                    throw new SecurityException("Wrong PIN.");
                }
                throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
            }
        }
    }

    public int getRetryCounter(PinID pinID) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException, IOException {
        if (pinID == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("pinID"));
        }
        byte p2 = (byte)pinID.getID();
        if (pinID.isLocal()) {
            p2 = (byte)(p2 | 0x80);
        }
        CommandApdu apdu = new CommandApdu(0, 32, 0, p2);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                throw new UnsupportedOperationException();
            }
            case 25344: {
                throw new SecurityException("Wrong PIN.");
            }
            case 27011: {
                throw new SecurityException("Referenced PIN is blocked.");
            }
            case 27012: {
                throw new SecurityException("Referenced PIN is blocked.");
            }
            case 27265: {
                throw new UnsupportedOperationException();
            }
            case 27270: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27392: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
        }
        if (25536 <= swValue && swValue <= 25551) {
            return swValue & 0xF;
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public void activatePin(PinID pinID, byte[] pin) throws SecurityException, IllegalStateException, IllegalArgumentException, UnsupportedOperationException, IOException {
        CommandApdu apdu;
        if (pinID == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("pinID"));
        }
        if (pin != null && (pin.length == 0 || pin.length > 65535)) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("pin"));
        }
        byte p2 = (byte)pinID.getID();
        if (pinID.isLocal()) {
            p2 = (byte)(p2 | 0x80);
        }
        if (pin != null) {
            if (pin.length > 255) {
                throw new IllegalArgumentException("PIN too long");
            }
            apdu = new CommandApdu(0, 40, 0, p2, pin);
        } else {
            apdu = new CommandApdu(0, 40, 1, p2);
        }
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                break;
            }
            case 25344: {
                throw new SecurityException("Wrong PIN.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27011: {
                throw new SecurityException("PIN is blocked.");
            }
            case 27265: {
                throw new UnsupportedOperationException("This operation is not supported by the selected Applet.");
            }
            case 27270: {
                if (pin != null) {
                    throw new IllegalArgumentException("Referenced PIN could not be found.");
                }
                throw new IllegalArgumentException("Either pinID is wrong, or this pin does not support activation with pin = null.");
            }
            case 27272: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27392: {
                if (pin != null) {
                    throw new IllegalArgumentException("Referenced PIN could not be found.");
                }
                throw new IllegalArgumentException("Either pinID is wrong, or this pin does not support activation with pin = null.");
            }
            case 27904: {
                throw new UnsupportedOperationException("This operation is not supported by the selected Applet.");
            }
            default: {
                if (25536 <= swValue && swValue <= 25551) {
                    throw new SecurityException("Wrong PIN.");
                }
                throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
            }
        }
    }

    public void deactivatePin(PinID pinID, byte[] pin) throws SecurityException, IllegalStateException, IllegalArgumentException, UnsupportedOperationException, IOException {
        CommandApdu apdu;
        if (pinID == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("pinID"));
        }
        if (pin != null && (pin.length == 0 || pin.length > 65535)) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("pin"));
        }
        byte p2 = (byte)pinID.getID();
        if (pinID.isLocal()) {
            p2 = (byte)(p2 | 0x80);
        }
        if (pin != null) {
            if (pin.length > 255) {
                throw new IllegalArgumentException("PIN too long");
            }
            apdu = new CommandApdu(0, 38, 0, p2, pin);
        } else {
            apdu = new CommandApdu(0, 38, 1, p2);
        }
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                break;
            }
            case 25344: {
                throw new SecurityException("Wrong PIN.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27011: {
                throw new SecurityException("Referenced PIN is blocked.");
            }
            case 27012: {
                throw new SecurityException("Referenced PIN is blocked.");
            }
            case 27265: {
                throw new UnsupportedOperationException();
            }
            case 27270: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27392: {
                throw new IllegalArgumentException("Referenced PIN could not be found.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
            default: {
                if (25536 <= swValue && swValue <= 25551) {
                    throw new SecurityException("Wrong PIN.");
                }
                throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
            }
        }
    }

    public class PinID {
        public static final int MIN_ID_VALUE = 0;
        public static final int MAX_ID_VALUE = 31;
        private int mId;
        private boolean mLocal;

        public PinID(int id, boolean local) throws IllegalArgumentException {
            if (id < 0 || id > 31) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("id"));
            }
            this.mId = id;
            this.mLocal = local;
        }

        public final int getID() {
            return this.mId;
        }

        public final boolean isLocal() {
            return this.mLocal;
        }
    }
}

