/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import android.util.Log;
import java.io.IOException;
import org.simalliance.openmobileapi.Reader;
import org.simalliance.openmobileapi.SERecognizer;
import org.simalliance.openmobileapi.SEService;
import org.simalliance.openmobileapi.Session;
import org.simalliance.openmobileapi.internal.ErrorStrings;

public class SEDiscovery {
    private static final String LOG_TAG = "SEDiscovery";
    private SEService mService;
    private SERecognizer mRecognizer;
    private Reader[] mReaders;
    private int mCounter;

    public SEDiscovery(SEService service, SERecognizer recognizer) throws IllegalArgumentException {
        if (service == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("service"));
        }
        if (recognizer == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("recognizer"));
        }
        this.mService = service;
        this.mRecognizer = recognizer;
        this.mCounter = -1;
    }

    public Reader getFirstMatch() {
        this.mReaders = this.mService.getReaders();
        if (this.mReaders == null || this.mReaders.length < 1) {
            this.mCounter = -1;
            return null;
        }
        this.mCounter = 0;
        try {
            return this.getNextMatch();
        }
        catch (IllegalStateException e2) {
            return null;
        }
    }

    public Reader getNextMatch() throws IllegalStateException {
        if (this.mCounter == -1) {
            throw new IllegalStateException("getFirstMatch needs to be called before getNextMatch()");
        }
        while (this.mCounter < this.mReaders.length) {
            Reader nextReader = this.mReaders[this.mCounter];
            if (nextReader.isSecureElementPresent()) {
                try {
                    Session session = nextReader.openSession();
                    if (this.mRecognizer.isMatching(session)) {
                        session.close();
                        ++this.mCounter;
                        return nextReader;
                    }
                    session.close();
                }
                catch (IOException e2) {
                    Log.e((String)LOG_TAG, (String)"Session could not be opened, assume it is not matching", (Throwable)e2);
                }
                catch (IllegalArgumentException e3) {
                    Log.e((String)LOG_TAG, (String)"If session is null, assume it is not matching", (Throwable)e3);
                }
            }
            ++this.mCounter;
        }
        this.mCounter = -1;
        return null;
    }
}

