/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.internal;

import org.simalliance.openmobileapi.internal.ByteArrayConverter;
import org.simalliance.openmobileapi.internal.TlvParser;

public class DerTlvParser
extends TlvParser {
    @Override
    public byte[] getTagBytes(byte[] array, int position) throws IllegalArgumentException {
        byte[] tagBytes;
        if ((array[position] & 0x1F) != 31) {
            tagBytes = new byte[1];
        } else {
            int tmpPosition = position;
            if ((array[++tmpPosition] & 0x7F) == 0) {
                throw new IllegalArgumentException("Invalid tag.");
            }
            int length = 2;
            while ((array[tmpPosition] & 0x80) == 128) {
                ++length;
                ++tmpPosition;
            }
            tagBytes = new byte[length];
        }
        System.arraycopy((byte[])array, (int)position, (byte[])tagBytes, (int)0, (int)tagBytes.length);
        return tagBytes;
    }

    @Override
    public byte[] getLengthBytes(byte[] array, int position) throws IllegalArgumentException {
        byte[] lengthBytes;
        if ((array[position] & 0x80) != 128) {
            lengthBytes = new byte[1];
        } else {
            if ((array[position] & 0xFF) == 255) {
                throw new IllegalArgumentException("Invalid length field.");
            }
            lengthBytes = new byte[1 + (array[position] & 0x7F)];
        }
        System.arraycopy((byte[])array, (int)position, (byte[])lengthBytes, (int)0, (int)lengthBytes.length);
        return lengthBytes;
    }

    @Override
    public int getLengthValue(byte[] lengthBytes) {
        byte[] lengthValue;
        int valueStartPosition;
        if (lengthBytes.length == 1) {
            valueStartPosition = 0;
            lengthValue = new byte[1];
        } else {
            valueStartPosition = 1;
            lengthValue = new byte[lengthBytes.length - 1];
        }
        System.arraycopy((byte[])lengthBytes, (int)valueStartPosition, (byte[])lengthValue, (int)0, (int)lengthValue.length);
        return ByteArrayConverter.byteArrayToInt(lengthValue);
    }
}

