/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.internal;

import java.util.ArrayList;

public final class OidParser {
    private OidParser() {
    }

    public static byte[] encodeOid(String oid) throws IllegalArgumentException {
        int secondValue;
        int firstValue;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        String[] oidNumbers = oid.split("\\.");
        if (oidNumbers.length < 3) {
            throw new IllegalArgumentException();
        }
        try {
            firstValue = Integer.parseInt(oidNumbers[0]);
            secondValue = Integer.parseInt(oidNumbers[1]);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException();
        }
        byteList.add(OidParser.encondeFirstDigits(firstValue, secondValue));
        for (int j2 = 2; j2 < oidNumbers.length; ++j2) {
            byte[] codification;
            int number;
            try {
                number = Integer.parseInt(oidNumbers[j2]);
            }
            catch (Exception e3) {
                throw new IllegalArgumentException();
            }
            for (byte b2 : codification = OidParser.encodeInteger(number)) {
                byteList.add(b2);
            }
        }
        byte[] result = new byte[byteList.size()];
        for (int i2 = 0; i2 < byteList.size(); ++i2) {
            result[i2] = (Byte)byteList.get(i2);
        }
        return result;
    }

    public static byte encondeFirstDigits(int first, int second) throws IllegalArgumentException {
        if (first < 0 || second < 0) {
            throw new IllegalArgumentException();
        }
        return (byte)(40 * first + second);
    }

    public static byte[] encodeInteger(int number) throws IllegalArgumentException {
        if (number < 0) {
            throw new IllegalArgumentException();
        }
        if (number == 0) {
            return new byte[]{0};
        }
        boolean isFirstIteration = true;
        byte[] result = new byte[]{};
        while (number != 0) {
            byte[] aux = new byte[result.length];
            System.arraycopy((byte[])result, (int)0, (byte[])aux, (int)0, (int)result.length);
            result = new byte[result.length + 1];
            System.arraycopy((byte[])aux, (int)0, (byte[])result, (int)1, (int)aux.length);
            byte value = (byte)(number & 0x7F);
            if (isFirstIteration) {
                isFirstIteration = false;
            } else {
                value = (byte)(value | 0x80);
            }
            result[0] = value;
            number >>= 7;
        }
        return result;
    }
}

