/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.internal;

import org.simalliance.openmobileapi.internal.DerTlvCoder;
import org.simalliance.openmobileapi.internal.TlvParser;

public class TlvEntryWrapper {
    private byte[] mTag;
    private byte[] mValue;
    private int mTotalLength;

    public TlvEntryWrapper(byte[] data, int startPosition, TlvParser parser) throws IllegalArgumentException {
        int position = startPosition;
        this.mTag = parser.getTagBytes(data, startPosition);
        byte[] lengthBytes = parser.getLengthBytes(data, position += this.mTag.length);
        this.mValue = new byte[parser.getLengthValue(lengthBytes)];
        System.arraycopy((byte[])data, (int)(position += lengthBytes.length), (byte[])this.mValue, (int)0, (int)this.mValue.length);
        this.mTotalLength = this.mTag.length + lengthBytes.length + this.mValue.length;
    }

    public byte[] getTag() {
        return this.mTag;
    }

    public int getTotalLength() {
        return this.mTotalLength;
    }

    public byte[] getValue() {
        return this.mValue;
    }

    public byte[] encode() {
        byte[] encodedObject = new byte[this.mTotalLength];
        System.arraycopy((byte[])this.mTag, (int)0, (byte[])encodedObject, (int)0, (int)this.mTag.length);
        byte[] lengthBytes = DerTlvCoder.encodeLength(this.mValue.length);
        System.arraycopy((byte[])lengthBytes, (int)this.mTag.length, (byte[])encodedObject, (int)this.mTag.length, (int)lengthBytes.length);
        System.arraycopy((byte[])this.mValue, (int)0, (byte[])encodedObject, (int)(this.mTag.length + lengthBytes.length), (int)this.mValue.length);
        return encodedObject;
    }
}

