/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simalliance.openmobileapi.internal.ErrorStrings;
import org.simalliance.openmobileapi.internal.TlvEntryWrapper;

public abstract class TlvParser {
    abstract byte[] getTagBytes(byte[] var1, int var2) throws IllegalArgumentException;

    abstract byte[] getLengthBytes(byte[] var1, int var2) throws IllegalArgumentException;

    abstract int getLengthValue(byte[] var1);

    public List<TlvEntryWrapper> parseArray(byte[] array) {
        TlvEntryWrapper nextEntry;
        byte[] data = this.getValidTlvData(array);
        ArrayList<TlvEntryWrapper> list = new ArrayList<TlvEntryWrapper>();
        for (int position = 0; position < data.length; position += nextEntry.getTotalLength()) {
            nextEntry = new TlvEntryWrapper(data, position, this);
            list.add(nextEntry);
        }
        return list;
    }

    public int searchTag(byte[] data, byte[] tag, int startPosition) throws IllegalArgumentException {
        TlvEntryWrapper derEntry;
        if (startPosition < 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("startPosition"));
        }
        for (int position = startPosition; position < data.length; position += derEntry.getTotalLength()) {
            derEntry = new TlvEntryWrapper(data, position, this);
            if (!Arrays.equals(tag, derEntry.getTag())) continue;
            return position;
        }
        throw new IllegalArgumentException("Tag not found.");
    }

    public byte[] getValidTlvData(byte[] rawData) {
        if (this.isValidTlvStructure(rawData)) {
            return rawData;
        }
        int position = 0;
        try {
            while (true) {
                int tmpPosition = position;
                byte[] tag = this.getTagBytes(rawData, tmpPosition);
                byte[] length = this.getLengthBytes(rawData, tmpPosition += tag.length);
                tmpPosition += length.length;
                if ((tmpPosition += this.getLengthValue(length)) <= rawData.length) {
                    position = tmpPosition;
                    continue;
                }
                break;
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        byte[] validData = new byte[position];
        System.arraycopy((byte[])rawData, (int)0, (byte[])validData, (int)0, (int)position);
        return validData;
    }

    public boolean isValidTlvStructure(byte[] data) {
        int position;
        byte[] length;
        for (position = 0; position < data.length; position += this.getLengthValue(length)) {
            try {
                byte[] tag = this.getTagBytes(data, position);
                length = this.getLengthBytes(data, position += tag.length);
                position += length.length;
                continue;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return position == data.length;
    }
}

