/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.blesafekey;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.util.Log;
import com.xdja.blesafekey.BleCallback;
import com.xdja.blesafekey.BleDataStruct;
import com.xdja.blesafekey.BleErrID;
import com.xdja.blesafekey.BleUtils;
import com.xdja.blesafekey.XDJABleInfo;
import java.util.UUID;

public class BleInterfaceApi {
    private static final String uuidCoscmdService = "0000fff0-0000-1000-8000-00805f9b34fb";
    private static final String uuidCoscmdCharacteristic = "0000fff6-0000-1000-8000-00805f9b34fb";
    private static final String uuidCharacteristicConfig = "00002902-0000-1000-8000-00805f9b34fb";
    private static Context applicationContext;
    private BluetoothManager bleManger;
    private BluetoothAdapter bleAdapter;
    private static BluetoothGatt bleGatt;
    private static BluetoothGattCharacteristic bleCharacteristic;
    private static int currentState;
    private static boolean RECVEFLAGE;
    private static BleCallback bleCallback;
    private static String strConnBleAddr;
    private static String strConnBleName;
    BleDataStruct bleRecDataBuf;
    byte[] sendDataBuf = new byte[512];
    byte[] bleRecvBuf = new byte[512];
    byte[] clearDevTag = new byte[]{-1, -1, -1, -1};
    byte[] pBuf = new byte[20];
    int dataLen = 0;
    boolean recEnd = true;
    boolean sendEnd = true;
    boolean sendRespMode = false;
    int recDataSize = 0;
    int recPkgCount = 0;
    int recPkgNo = 0;
    int sendPkdSize = 0;
    int sendDataSize = 0;
    int sendPkgCount = 0;
    int sendPkgNo = 0;
    int sendPos = 0;
    private BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            Log.d((String)BleErrID.LOG_TAG, (String)("onConnectionStateChange, newstate=" + newState + ",gatt=" + gatt));
            super.onConnectionStateChange(gatt, status, newState);
            if (newState == 2) {
                currentState = 4;
                boolean ret = gatt.discoverServices();
                Log.d((String)BleErrID.LOG_TAG, (String)("gatt.discoverServices ret=" + ret));
                bleCallback.OnBleStateChange(currentState);
            } else if (newState == 0) {
                currentState = 5;
                gatt.close();
                bleGatt = null;
                Log.d((String)BleErrID.LOG_TAG, (String)"gatt close");
                bleCallback.OnBleStateChange(currentState);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            Log.d((String)BleErrID.LOG_TAG, (String)"onServicesDiscovered");
            if (status == 0) {
                BluetoothGattService service = gatt.getService(UUID.fromString(BleInterfaceApi.uuidCoscmdService));
                if (service == null) {
                    Log.d((String)BleErrID.LOG_TAG, (String)"retry to get coscmd service");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    service = gatt.getService(UUID.fromString(BleInterfaceApi.uuidCoscmdService));
                    if (service == null) {
                        Log.d((String)BleErrID.LOG_TAG, (String)"get coscmd services failed");
                        return;
                    }
                }
                BluetoothGattCharacteristic characteristic = service.getCharacteristic(UUID.fromString(BleInterfaceApi.uuidCoscmdCharacteristic));
                if (service == null) {
                    Log.d((String)BleErrID.LOG_TAG, (String)"get coscmd characteristic failed");
                    return;
                }
                BleInterfaceApi.this.setBleCharacteristic(characteristic);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                currentState = 258;
                bleCallback.OnBleStateChange(currentState);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.d((String)BleErrID.LOG_TAG, (String)("Ble onCharacteristicWrite..." + String.valueOf(status)));
            if (status == 0 && BleInterfaceApi.this.sendRespMode) {
                BleInterfaceApi.this.SendData();
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic Characteristic) {
            Log.d((String)BleErrID.LOG_TAG, (String)"onCharacteristicChanged");
            byte[] bBuf = bleCharacteristic.getValue();
            if (bBuf != null) {
                BleInterfaceApi.this.RecvDataPkg(bBuf);
                Log.d((String)BleErrID.LOG_TAG, (String)("Recv Pack:\n" + BleUtils.ByteToHexString(bBuf, bBuf.length)));
            }
        }
    };

    public BleInterfaceApi(Context context) {
        if (context != null) {
            applicationContext = context.getApplicationContext();
        }
        this.recEnd = true;
        this.sendEnd = true;
        this.sendDataSize = 0;
        this.recDataSize = 0;
        this.sendRespMode = true;
        if (this.bleRecDataBuf == null) {
            this.bleRecDataBuf = new BleDataStruct();
        }
    }

    public XDJABleInfo GetConnectedDev() {
        if (currentState != 258) {
            return null;
        }
        XDJABleInfo bleInfo = new XDJABleInfo();
        bleInfo.strAddr = strConnBleAddr;
        bleInfo.strName = strConnBleName;
        return bleInfo;
    }

    public int getCurrentState() {
        return currentState;
    }

    public int setBleCharacteristic(BluetoothGattCharacteristic bleCharacteristic) {
        int properties = 0;
        properties = bleCharacteristic.getProperties();
        BleInterfaceApi.bleCharacteristic = bleCharacteristic;
        if (0 != (properties & 0x10)) {
            bleGatt.setCharacteristicNotification(bleCharacteristic, true);
            BluetoothGattDescriptor descriptor = bleCharacteristic.getDescriptor(UUID.fromString(uuidCharacteristicConfig));
            descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            bleGatt.writeDescriptor(descriptor);
            Log.d((String)BleErrID.LOG_TAG, (String)"set bleCharacteristic notify...");
            return 0;
        }
        return -1;
    }

    public int ConnectBleService(String bleAddress, String bleName) {
        BluetoothDevice mDevice;
        Log.d((String)BleErrID.LOG_TAG, (String)"ConnectBleService");
        if (this.bleManger == null) {
            this.bleManger = (BluetoothManager)applicationContext.getSystemService("bluetooth");
            if (this.bleManger == null) {
                Log.d((String)BleErrID.LOG_TAG, (String)"getSystemService of Context.BLUETOOTH_SERVICE failed");
                return -97;
            }
        }
        if (this.bleAdapter == null) {
            this.bleAdapter = this.bleManger.getAdapter();
            if (this.bleAdapter == null || !this.bleAdapter.isEnabled()) {
                Log.d((String)BleErrID.LOG_TAG, (String)"bleManger.getAdapter failed");
                return -97;
            }
        }
        if (bleAddress == null || bleAddress.equals("")) {
            Log.d((String)BleErrID.LOG_TAG, (String)"bleAddress is null");
            return -9;
        }
        if (currentState != 5) {
            Log.d((String)BleErrID.LOG_TAG, (String)"currentState is connecting or connected");
            return 0;
        }
        if (bleGatt != null) {
            bleGatt.close();
            bleGatt = null;
        }
        if ((mDevice = this.bleAdapter.getRemoteDevice(bleAddress)) == null) {
            Log.d((String)BleErrID.LOG_TAG, (String)("bleAdapter.getRemoteDevice of " + bleAddress + " failed"));
            return -97;
        }
        bleGatt = mDevice.connectGatt(applicationContext, false, this.mGattCallback);
        currentState = 3;
        Log.d((String)BleErrID.LOG_TAG, (String)"connect gatt...");
        strConnBleAddr = bleAddress;
        strConnBleName = bleName;
        return 0;
    }

    public void SetCallBack(BleCallback callback) {
        bleCallback = callback;
    }

    public void DisConnectService() {
        if (this.bleAdapter == null) {
            return;
        }
        if (bleGatt != null) {
            bleGatt.disconnect();
        }
    }

    public int SetSendData(byte[] dataBuf, int datalen) {
        if (bleCharacteristic == null) {
            return -1;
        }
        if (this.sendEnd && datalen < 512) {
            System.arraycopy(dataBuf, 0, this.sendDataBuf, 0, datalen);
            this.sendEnd = false;
            this.sendDataSize = datalen;
            this.sendPkdSize = 0;
            this.sendPkgNo = 0;
            if (this.sendDataSize <= 16) {
                this.sendPkgCount = 1;
            } else {
                this.sendPkgCount = this.sendDataSize / 16;
                if (this.sendDataSize % 16 != 0) {
                    ++this.sendPkgCount;
                }
            }
            bleCharacteristic.setValue(this.clearDevTag);
            boolean bRet = bleGatt.writeCharacteristic(bleCharacteristic);
            if (!bRet) {
                Log.d((String)BleErrID.LOG_TAG, (String)"writeCharacteristic of clearDevTag failed!");
                return -2;
            }
            return 0;
        }
        return -9;
    }

    public int SendData() {
        int dlen = 0;
        if (this.sendDataSize <= 0 || this.sendPkgCount <= 0) {
            return -9;
        }
        while (this.sendDataSize > 0) {
            dlen = this.sendDataSize > 16 ? 16 : this.sendDataSize;
            this.pBuf[0] = (byte)dlen;
            this.pBuf[1] = (byte)this.sendPkgCount;
            ++this.sendPkgNo;
            this.pBuf[2] = (byte)this.sendPkgNo;
            this.pBuf[3] = 1;
            System.arraycopy(this.sendDataBuf, this.sendPos, this.pBuf, 4, dlen);
            if (bleGatt != null && bleCharacteristic != null) {
                bleCharacteristic.setValue(this.pBuf);
                boolean bRet = bleGatt.writeCharacteristic(bleCharacteristic);
                if (!bRet) {
                    Log.d((String)BleErrID.LOG_TAG, (String)"writeCharacteristic of pBuf failed!");
                    return -2;
                }
            } else {
                return -1;
            }
            this.sendPos += dlen;
            this.sendDataSize -= dlen;
            if (this.sendPkgNo >= this.sendPkgCount || this.sendDataSize <= 0) {
                this.sendDataSize = 0;
                this.sendPkgCount = 0;
                this.sendPkgNo = 0;
                this.sendPos = 0;
                this.sendEnd = true;
                break;
            }
            if (!this.sendRespMode) continue;
            break;
        }
        return 0;
    }

    public int RecvDataPkg(byte[] pkgData) {
        if (pkgData == null) {
            return -9;
        }
        if (pkgData.length <= 4) {
            Log.d((String)BleErrID.LOG_TAG, (String)"rec data less...");
            return -9;
        }
        if (pkgData[3] != 1) {
            Log.d((String)BleErrID.LOG_TAG, (String)"BLE_GATT_PROTOCAL_VER_FALIED");
            return -2;
        }
        if (pkgData[0] == 2 && pkgData[1] == 1 && pkgData[2] == 1 && pkgData[4] == -118) {
            Log.d((String)BleErrID.LOG_TAG, (String)"recv 8A");
            return 0;
        }
        if (this.recPkgCount <= 0) {
            this.bleRecDataBuf.inUse = true;
            this.recPkgCount = pkgData[1];
        }
        if (pkgData[2] >= this.recPkgNo) {
            this.bleRecDataBuf.appendData(pkgData, 4, pkgData[0]);
            this.recPkgNo = pkgData[2];
        }
        if (this.recPkgNo == this.recPkgCount) {
            this.bleRecDataBuf.getDataBuf(this.bleRecvBuf, 0, this.bleRecDataBuf.dataLen);
            this.dataLen = this.bleRecDataBuf.dataLen;
            this.recPkgCount = 0;
            this.recPkgNo = 0;
            this.bleRecDataBuf.clearDataBuf();
            this.recEnd = true;
            RECVEFLAGE = true;
        }
        return 0;
    }

    public int execSafeCommand(byte[] reqData, int reqDataLen, byte[] respData, int[] respDataLen, int waitType) {
        if (this.getCurrentState() != 4 && this.getCurrentState() != 258) {
            return -1;
        }
        int ret = this.SetSendData(reqData, reqDataLen);
        if (ret != 0) {
            this.sendEnd = true;
            return ret;
        }
        Log.d((String)BleErrID.LOG_TAG, (String)("SendData:\n" + BleUtils.ByteToHexString(reqData, reqDataLen)));
        int maxLoop = waitType == 0 ? 500 : 1500;
        int loops = 0;
        while (!RECVEFLAGE) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (loops++ <= maxLoop) continue;
            this.sendEnd = true;
            Log.d((String)BleErrID.LOG_TAG, (String)"recv data timeout");
            return -2;
        }
        System.arraycopy(this.bleRecvBuf, 0, respData, 0, this.dataLen);
        respDataLen[0] = this.dataLen;
        RECVEFLAGE = false;
        Log.d((String)BleErrID.LOG_TAG, (String)("RecvData:\n" + BleUtils.ByteToHexString(respData, respDataLen[0])));
        return 0;
    }

    static {
        currentState = 5;
        RECVEFLAGE = false;
        bleCallback = null;
    }
}

