/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.blesafekey;

public class BleUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static char[] encodeHex(byte[] data) {
        return BleUtils.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return BleUtils.encodeHex(data, data.length, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, int len, char[] toDigits) {
        int l = len;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexStr(byte[] data) {
        return BleUtils.encodeHexStr(data, data.length, true);
    }

    public static String encodeHexStr(byte[] data, int len, boolean toLowerCase) {
        return BleUtils.encodeHexStr(data, len, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexStr(byte[] data, int len, char[] toDigits) {
        return new String(BleUtils.encodeHex(data, len, toDigits));
    }

    public static byte[] decodeHex(byte[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = BleUtils.toDigit((char)data[j], j) << 4;
            f |= BleUtils.toDigit((char)data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            digit = 255 - digit;
        }
        return digit;
    }

    public static String ByteToHexString(byte[] data, int len) {
        StringBuilder retStr = new StringBuilder();
        char stag = '0';
        int i = 0;
        int digit = 0;
        if (data.length <= 0) {
            return null;
        }
        for (i = 0; i < len && (digit = (data[i] & 0xFF) >> 4) <= 15 && digit >= 0; ++i) {
            stag = DIGITS_UPPER[digit];
            retStr.append(stag);
            digit = data[i] & 0xFF & 0xF;
            if (digit > 15) break;
            stag = DIGITS_UPPER[digit];
            retStr.append(stag);
        }
        return retStr.toString();
    }

    public static boolean CheckHexStr(byte[] hexStr) {
        int i = 0;
        if (hexStr == null) {
            return false;
        }
        for (i = 0; i < hexStr.length; ++i) {
            char ch = (char)hexStr[i];
            if (ch >= 'A' && ch < 'Z' && ch > 'F') {
                return false;
            }
            if (ch < 'a' || ch >= 'z' || ch <= 'f') continue;
            return false;
        }
        return true;
    }

    public static boolean ArrayCompare(byte[] srcArray, byte[] destArray, int len) {
        if (srcArray == null || destArray == null) {
            return false;
        }
        if (len > srcArray.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (srcArray[i] == destArray[i]) continue;
            return false;
        }
        return true;
    }
}

