/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.blesafekey;

import com.xdja.blesafekey.Word;
import java.math.BigInteger;

public class SM3Digest {
    static Word[] InitIV = new Word[]{new Word(1937774191L), new Word(1226093241L), new Word(388252375L), new Word(3666478592L), new Word(2842636476L), new Word(372324522L), new Word(3817729613L), new Word(2969243214L)};
    private Word[] RV = null;

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    Word T(int j) {
        if (j >= 0 && j <= 15) {
            return new Word(2043430169L);
        }
        if (j >= 16 && j <= 63) {
            return new Word(2055708042L);
        }
        return new Word(0L);
    }

    Word FG(Word x, Word y, Word z) {
        return x.xor(y).xor(z);
    }

    Word F1(Word x, Word y, Word z) {
        return x.and(y).or(x.and(z)).or(y.and(z));
    }

    Word G1(Word x, Word y, Word z) {
        return x.and(y).or(x.not().and(z));
    }

    Word FF(int j, Word x, Word y, Word z) {
        if (j >= 0 && j <= 15) {
            return this.FG(x, y, z);
        }
        if (j >= 16 && j <= 63) {
            return this.F1(x, y, z);
        }
        return new Word(0L);
    }

    Word GG(int j, Word x, Word y, Word z) {
        if (j >= 0 && j <= 15) {
            return this.FG(x, y, z);
        }
        if (j >= 16 && j <= 63) {
            return this.G1(x, y, z);
        }
        return new Word(0L);
    }

    Word P0(Word x) {
        return x.xor(x.cycleLeftShift(9)).xor(x.cycleLeftShift(17));
    }

    Word P1(Word x) {
        return x.xor(x.cycleLeftShift(15)).xor(x.cycleLeftShift(23));
    }

    public void update(byte[] in) {
        byte[] filledData = this.fillData(in);
        this.RV = InitIV;
        for (int i = 0; i < filledData.length / 64; ++i) {
            Word[] W = this.computExtMsg(filledData, i * 64);
            Word[] WY = this.computExtMsg(W);
            this.RV = this.hashData(this.RV, W, WY);
        }
    }

    public byte[] doFinal() {
        if (this.RV != null) {
            byte[] bytes = new byte[this.RV.length * 4];
            for (int i = 0; i < this.RV.length; ++i) {
                byte[] src = this.RV[i].getBytes();
                System.arraycopy(src, 0, bytes, i * 4, 4);
            }
            return bytes;
        }
        return null;
    }

    protected byte[] fillData(byte[] in) {
        int i;
        int i2;
        if (in == null || 0 == in.length) {
            throw new RuntimeException("update size must bigger than zero");
        }
        int k = 0;
        int data_bit_len = in.length * 8;
        int mod_len = data_bit_len % 512;
        int fill_len = 0;
        if (mod_len <= 447 && mod_len >= 0) {
            k = 447 - mod_len;
        } else if (mod_len > 447) {
            k = 512 - mod_len + 447;
        }
        fill_len = in.length + (k + 1) / 8 + 8;
        byte[] xBuf = new byte[fill_len];
        for (i2 = 0; i2 < in.length; ++i2) {
            xBuf[i2] = in[i2];
        }
        xBuf[in.length] = -128;
        for (i2 = in.length + 1; i2 < fill_len - 8; ++i2) {
            xBuf[i2] = 0;
        }
        byte[] bytesLen = new byte[8];
        byte[] tmp = BigInteger.valueOf(in.length * 8).toByteArray();
        for (i = 0; i < bytesLen.length; ++i) {
            bytesLen[i] = 0;
        }
        System.arraycopy(tmp, 0, bytesLen, bytesLen.length - tmp.length, tmp.length);
        for (i = fill_len - 8; i < fill_len; ++i) {
            xBuf[i] = bytesLen[i + 8 - fill_len];
        }
        return xBuf;
    }

    protected Word[] computExtMsg(byte[] filledData, int position) {
        int j;
        byte[] msg = new byte[64];
        System.arraycopy(filledData, position, msg, 0, 64);
        Word[] W = new Word[68];
        Word[] Wtemp = Word.split(msg);
        for (j = 0; j < Wtemp.length; ++j) {
            W[j] = Wtemp[j];
        }
        for (j = 16; j < W.length; ++j) {
            W[j] = this.P1(W[j - 16].xor(W[j - 9]).xor(W[j - 3].cycleLeftShift(15))).xor(W[j - 13].cycleLeftShift(7)).xor(W[j - 6]);
        }
        return W;
    }

    protected Word[] computExtMsg(Word[] W) {
        Word[] WY = new Word[64];
        for (int j = 0; j < WY.length; ++j) {
            WY[j] = W[j].xor(W[j + 4]);
        }
        return WY;
    }

    protected Word[] hashData(Word[] V, Word[] W, Word[] WY) {
        Word SS1 = new Word(0L);
        Word SS2 = new Word(0L);
        Word TT1 = new Word(0L);
        Word TT2 = new Word(0L);
        int x = 16;
        Word wA = V[0].clone();
        Word wB = V[1].clone();
        Word wC = V[2].clone();
        Word wD = V[3].clone();
        Word wE = V[4].clone();
        Word wF = V[5].clone();
        Word wG = V[6].clone();
        Word wH = V[7].clone();
        int j = 0;
        while (j <= 63) {
            SS1 = wA.cycleLeftShift(12).plus(wE).plus(this.T(j).cycleLeftShift(j)).cycleLeftShift(7);
            SS2 = SS1.xor(wA.cycleLeftShift(12));
            TT1 = this.FF(j, wA, wB, wC).plus(wD).plus(SS2).plus(WY[j]);
            TT2 = this.GG(j, wE, wF, wG).plus(wH).plus(SS1).plus(W[j]);
            wD = wC;
            wC = wB.cycleLeftShift(9);
            wB = wA;
            wA = TT1;
            wH = wG;
            wG = wF.cycleLeftShift(19);
            wF = wE;
            wE = this.P0(TT2);
            ++j;
            ++x;
        }
        Word[] V1 = new Word[]{wA.xor(V[0]), wB.xor(V[1]), wC.xor(V[2]), wD.xor(V[3]), wE.xor(V[4]), wF.xor(V[5]), wG.xor(V[6]), wH.xor(V[7])};
        return V1;
    }

    public int doFinal(byte[] out, int outOff) {
        if (this.RV != null) {
            for (int i = 0; i < this.RV.length; ++i) {
                byte[] src = this.RV[i].getBytes();
                System.arraycopy(src, 0, out, i * 4 + outOff, 4);
            }
            this.reset();
            return this.RV.length * 4;
        }
        this.reset();
        return 0;
    }

    public void reset() {
        this.RV = InitIV;
    }

    public void update(byte in) {
        byte[] tmp = new byte[1];
        System.arraycopy(in, 0, tmp, 0, 1);
        this.update(tmp);
    }

    public void update(byte[] in, int inOff, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(in, inOff, tmp, 0, len);
        this.update(tmp);
    }
}

