/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.blesafekey;

import java.math.BigInteger;

public class Word {
    byte[] bytesValue = new byte[4];
    Long longValue = null;

    public Word(long l) {
        for (int i = 0; i < 4; ++i) {
            this.bytesValue[i] = (byte)(l >>> 24 - i * 8);
        }
        this.longValue = l & 0xFFFFFFFFL;
    }

    public Word(byte[] bytes) {
        this(bytes, 0);
    }

    private Word(byte[] bytes, int index) {
        this.bytesValue[0] = bytes[index];
        this.bytesValue[1] = bytes[index + 1];
        this.bytesValue[2] = bytes[index + 2];
        this.bytesValue[3] = bytes[index + 3];
        this.longValue = this.getLong();
    }

    public long getLong() {
        if (this.longValue == null) {
            long firstByte = 0L;
            long secondByte = 0L;
            long thirdByte = 0L;
            long fourthByte = 0L;
            firstByte = 0xFF & this.bytesValue[0];
            secondByte = 0xFF & this.bytesValue[1];
            thirdByte = 0xFF & this.bytesValue[2];
            fourthByte = 0xFF & this.bytesValue[3];
            long realValue = (firstByte << 24 | secondByte << 16 | thirdByte << 8 | fourthByte) & 0xFFFFFFFFL;
            return realValue;
        }
        return this.longValue;
    }

    public byte[] getBytes() {
        return this.bytesValue;
    }

    public Word xor(Word b) {
        long t = this.getLong() ^ b.getLong();
        return new Word(t);
    }

    public Word and(Word b) {
        long t = this.getLong() & b.getLong();
        return new Word(t);
    }

    public Word plus(Word b) {
        long t = this.getLong() + b.getLong();
        return new Word(t);
    }

    public Word or(Word b) {
        long t = this.getLong() | b.getLong();
        return new Word(t);
    }

    public Word not() {
        long t = this.getLong() ^ 0xFFFFFFFFL;
        return new Word(t);
    }

    public Word cycleLeftShift(int k) {
        if (k == 32) {
            return this;
        }
        int realShift = k > 32 ? k - 32 : k;
        long t1 = this.getLong() << realShift & 0xFFFFFFFFL;
        long t2 = this.getLong() >> 32 - realShift;
        long t = t1 | t2;
        return new Word(t);
    }

    public static Word[] split(byte[] bytes) {
        Word[] words = new Word[bytes.length / 4];
        for (int i = 0; i < words.length; ++i) {
            words[i] = new Word(bytes, i * 4);
        }
        return words;
    }

    public String toString() {
        return BigInteger.valueOf(this.getLong()).toString(16);
    }

    public Word clone() {
        return new Word(this.getLong());
    }
}

