/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.blesafekey;

import android.content.Context;
import android.util.Log;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.blesafekey.BleCallback;
import com.xdja.blesafekey.BleErrID;
import com.xdja.blesafekey.XDJABleInfo;
import com.xdja.blesafekey.XDJABleVer;
import com.xdja.blesafekey.XDJAKeyCmd;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class XDJABleAPI {
    private static final XDJAKeyCmd mXdjaKeyCmd = new XDJAKeyCmd();
    private static final XDJABleAPI instance = new XDJABleAPI();
    private static Lock lock = new ReentrantLock();
    public static final String XDJABLE_NAME_OLD = "SimpleBLEPeripheral";
    public static final String XDJABLE_NAME = "iBKey";
    public static final int CT_XDJABLE = 1792;
    public static final int PIN_MAX_LEN = 16;
    public static final int PIN_MIN_LEN = 3;
    public static final int ECB_MODE = 0;
    public static final int CBC_MODE = 16;
    public static final int ECB_DECRYPT = 0;
    public static final int ECB_ENCRYPT = 1;
    public static final int CBC_DECRYPT = 16;
    public static final int CBC_ENCRYPT = 17;
    public static final int FILE_BINARY = 1;
    public static final int FILE_PUBLIC = 2;
    public static final int FILE_PRIVATE = 3;
    public static final int SIGN_HASH = 0;
    public static final int SIGN_NOHASH = 1;

    public static XDJABleAPI getInstance() {
        return instance;
    }

    public String GetLibVerison() {
        return "1.0.0.2";
    }

    public int ConnectService(Context context, String connBleDevAddr, String connBleDevName) {
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        if (!connBleDevName.equals(XDJABLE_NAME_OLD) && !connBleDevName.equals(XDJABLE_NAME)) {
            return -9;
        }
        return mXdjaKeyCmd.ConnectService(context, connBleDevAddr, connBleDevName);
    }

    public int ConnectService(Context context, XDJABleInfo bleInfo, BleCallback callback) {
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        if (!bleInfo.strName.equals(XDJABLE_NAME_OLD) && !bleInfo.strName.equals(XDJABLE_NAME)) {
            return -9;
        }
        int ret = mXdjaKeyCmd.ConnectService(context, bleInfo.strAddr, bleInfo.strName);
        mXdjaKeyCmd.SetCallBack(callback);
        return ret;
    }

    public void SetCallBack(BleCallback callback) {
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        mXdjaKeyCmd.SetCallBack(callback);
    }

    public void DisConnectService() {
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            mXdjaKeyCmd.DisConnectService();
        }
        finally {
            lock.unlock();
        }
    }

    public int ChangeToUsbmode() {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.ChangeToUsbmode();
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int ChangeToSpimode() {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.ChangeToSpimode();
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public XDJABleInfo GetConnectedDev() {
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        return mXdjaKeyCmd.GetConnectedDev();
    }

    public int GetBleState() {
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        return mXdjaKeyCmd.GetBleServiceState();
    }

    public int GetBattery() {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GetBattery();
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Transmit(byte[] pCmd, int cmdLen, byte[] outBuf, int[] outlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.Transmit(pCmd, cmdLen, outBuf, outlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int GetDevInfo(XDJA_DEVINFO devInfo) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GetDevInfo(devInfo);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int GetBleInfo(XDJABleVer bleInfo) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GetBleInfo(bleInfo);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int GetActivateState() {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GetActivateState();
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ChangePIN(int pinRole, byte[] oldpin, int oldlen, byte[] newpin, int newlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.ChangePIN(pinRole, oldpin, oldlen, newpin, newlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int GetPinTryCount(int pinRole) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GetPinTryCount(pinRole);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int VerifyPIN(int pinRole, byte[] pin, int pinlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.VerifyPIN(pinRole, pin, pinlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReloadPIN(int pinRole, byte[] key, int keylen, byte[] newpin, int newlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.ReloadPIN(pinRole, key, keylen, newpin, newlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int CreateFile(XDJA_FILE pFile) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.CreateFile(pFile);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int SelectFile(byte[] fid) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SelectFile(fid);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadFile(byte[] fid, int readPos, int readLen, byte[] pDataout) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.ReadFile(fid, readPos, readLen, pDataout);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteFile(byte[] fid, int writePos, int writeLen, byte[] pDatain) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.WriteFile(fid, writePos, writeLen, pDatain);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadRsaPubKey(byte[] fid, XDJA_RSA_PUBKEY pPub) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.ReadRsaPubKey(fid, pPub);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadSm2PubKey(byte[] fid, XDJA_SM2_PUBKEY pPub) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.ReadSm2PubKey(fid, pPub);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadCert(byte[] fid, byte[] certBuf, int[] certLen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.ReadCert(fid, certBuf, certLen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GenRandom(int len, byte[] pRandom) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GenRandom(len, pRandom);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM1(byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte kID, byte[] pIV) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM1(pDataIn, dataLen, flag, pDataOut, kID, pIV);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM1KEY(byte[] tmpkey, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte[] pIV) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM1KEY(tmpkey, pDataIn, dataLen, flag, pDataOut, pIV);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM4KEYEx(byte[] tmpkey, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte[] pIV) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM4KEYEx(tmpkey, pDataIn, dataLen, flag, pDataOut, pIV);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SHA1Ex(byte[] pDataIn, int dataLen, byte[] pDataOut) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SHA1Ex(pDataIn, dataLen, pDataOut);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM3(byte[] pDatain, int dataLen, byte[] pDataOut) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM3(pDatain, dataLen, pDataOut);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM3Ex(byte[] pDatain, int dataLen, byte[] pDataOut) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM3Ex(pDatain, dataLen, pDataOut);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GenRSAKeyPair(int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pPub, XDJA_RSA_PRIKEY pPri) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GenRSAKeyPair(bits, pubfid, prifid, pPub, pPri);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RSAPubKeyCalc(byte[] fid, XDJA_RSA_PUBKEY pPub, byte[] pDataIn, int dlen, byte[] pDataOut, int[] outLen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.RSAPubKeyCalc(fid, pPub, pDataIn, dlen, pDataOut, outLen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RSAPriKeyCalc(byte[] fid, byte[] pDataIn, int dlen, byte[] pDataOut, int[] outLen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.RSAPriKeyCalc(fid, pDataIn, dlen, pDataOut, outLen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetSM2Id(byte[] sm2id, int[] outlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GetSM2Id(sm2id, outlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SetSM2Id(byte[] sm2id, int dlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SetSM2Id(sm2id, dlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int GetSM2Param(XDJA_SM2_PARAM sm2param) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GetSM2Param(sm2param);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int SetSM2Param(XDJA_SM2_PARAM sm2param) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SetSM2Param(sm2param);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GenSM2KeyPair(byte[] pubkeyid, byte[] prikeyid, XDJA_SM2_PUBKEY sm2pubkey, XDJA_SM2_PRIKEY sm2prikey) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.GenSM2KeyPair(pubkeyid, prikeyid, sm2pubkey, sm2prikey);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2Encrypt(byte[] pubkeyid, XDJA_SM2_PUBKEY sm2pubkey, byte[] pDatain, int dlen, byte[] pDataout, int[] outLen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM2Encrypt(pubkeyid, sm2pubkey, pDatain, dlen, pDataout, outLen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2Decrypt(byte[] prikeyid, byte[] pDatain, int dlen, byte[] pDataout, int[] outlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM2Decrypt(prikeyid, pDatain, dlen, pDataout, outlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2Sign(byte[] pubkeyid, byte[] prikeyid, int datatype, byte[] pDatain, int dlen, byte[] signData, int[] outlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM2Sign(pubkeyid, prikeyid, datatype, pDatain, dlen, signData, outlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2SignVerify(byte[] pubkeyid, int datatype, XDJA_SM2_PUBKEY sm2pubkey, byte[] pDatain, int dlen, byte[] signData) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM2SignVerify(pubkeyid, datatype, sm2pubkey, pDatain, dlen, signData);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2KeyGenInit(byte[] pubkeyid, byte[] pdataout, int[] outlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM2KeyGenInit(pubkeyid, pdataout, outlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2KeyGenCompute(byte[] pubkeyid, byte[] prikeyid, byte[] pDatain, int dlen, byte[] pDataout, int[] outlen, byte dictflag, byte keyflag) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM2KeyGenCompute(pubkeyid, prikeyid, pDatain, dlen, pDataout, outlen, dictflag, keyflag);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2KeyGenVerify(byte[] pDatain, int dlen) {
        int ret = 0;
        lock.lock();
        Log.i((String)BleErrID.LOG_TAG, (String)("call " + Thread.currentThread().getStackTrace()[2].getMethodName()));
        try {
            ret = mXdjaKeyCmd.SM2KeyGenVerify(pDatain, dlen);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }
}

