/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.blesafekey;

import android.content.Context;
import android.util.Log;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.blesafekey.BleCallback;
import com.xdja.blesafekey.BleErrID;
import com.xdja.blesafekey.BleInterfaceApi;
import com.xdja.blesafekey.BleUtils;
import com.xdja.blesafekey.SM3Digest;
import com.xdja.blesafekey.XDJABleInfo;
import com.xdja.blesafekey.XDJABleVer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class XDJAKeyCmd {
    private static BleInterfaceApi mBleInterfaceApi = null;
    private static final int MAX_BLOCK = 176;
    private static final byte[] p0 = new byte[]{-1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] a0 = new byte[]{-1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -4};
    private static final byte[] b0 = new byte[]{40, -23, -6, -98, -99, -97, 94, 52, 77, 90, -98, 75, -49, 101, 9, -89, -13, -105, -119, -11, 21, -85, -113, -110, -35, -68, -67, 65, 77, -108, 14, -109};
    private static final byte[] x0 = new byte[]{50, -60, -82, 44, 31, 25, -127, 25, 95, -103, 4, 70, 106, 57, -55, -108, -113, -29, 11, -65, -14, 102, 11, -31, 113, 90, 69, -119, 51, 76, 116, -57};
    private static final byte[] y0 = new byte[]{-68, 55, 54, -94, -12, -10, 119, -100, 89, -67, -50, -29, 107, 105, 33, 83, -48, -87, -121, 124, -58, 42, 71, 64, 2, -33, 50, -27, 33, 57, -16, -96};
    private static final byte[] n0 = new byte[]{-1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 114, 3, -33, 107, 33, -58, 5, 43, 83, -69, -12, 9, 57, -43, 65, 35};

    private static int CheckResCode(byte[] resBuf, int bufLen) {
        if (bufLen > resBuf.length) {
            return -3;
        }
        if (bufLen < 2) {
            return -3;
        }
        boolean ret = false;
        byte code1 = resBuf[bufLen - 2];
        byte code2 = resBuf[bufLen - 1];
        if (code1 == 110) {
            return -62;
        }
        if (code1 == -112 && code2 == 0) {
            return 0;
        }
        if (code1 == 99 && (code2 & 0xFFFFFFF0) == -64) {
            if (code2 == -64) {
                return -10;
            }
            return code2 & 0xF;
        }
        if (code1 == 105 && code2 == -120) {
            return -10;
        }
        if (code1 == 101 && code2 == -127) {
            return -11;
        }
        if (code1 == 110 && code2 == 4) {
            return -11;
        }
        if (code1 == 103 && code2 == 0) {
            return -12;
        }
        if (code1 == 105 && code2 == 0) {
            return -13;
        }
        if (code1 == 105 && code2 == -127) {
            return -14;
        }
        if (code1 == 105 && code2 == -126) {
            return -15;
        }
        if (code1 == 105 && code2 == -125) {
            return -16;
        }
        if (code1 == 105 && code2 == -123) {
            return -40;
        }
        if (code1 == 106 && code2 == -128) {
            return -18;
        }
        if (code1 == 106 && code2 == -127) {
            return -19;
        }
        if (code1 == 106 && code2 == -126) {
            return -20;
        }
        if (code1 == 106 && code2 == -124) {
            return -21;
        }
        if (code1 == 106 && code2 == -123) {
            return -22;
        }
        if (code1 == 106 && code2 == -122) {
            return -23;
        }
        if (code1 == 106 && code2 == -121) {
            return -24;
        }
        if (code1 == 106 && code2 == -120) {
            return -25;
        }
        if (code1 == 106 && code2 == -119) {
            return -26;
        }
        if (code1 == 108) {
            return -27;
        }
        if (code1 == 109 && code2 == 0) {
            return -28;
        }
        if (code1 == 110 && code2 == 3) {
            return -99;
        }
        if (code1 == 111 && code2 == 0) {
            return -29;
        }
        if (code1 == -109 && code2 == 2) {
            return -30;
        }
        if (code1 == -108 && code2 == 2) {
            return -31;
        }
        if (code1 == -108 && code2 == 3) {
            return -32;
        }
        if (code1 == -108 && code2 == 4) {
            return -33;
        }
        if (code1 == 107 && code2 == 0) {
            return -60;
        }
        if (code1 == 107 && code2 == 1) {
            return -61;
        }
        return -4;
    }

    private int ExecApdu(byte[] pCmd, int cmdLen, byte[] outBuf, int[] outlen) {
        return this.ExecApdu(pCmd, cmdLen, outBuf, outlen, 0);
    }

    private int ExecApdu(byte[] pCmd, int cmdLen, byte[] outBuf, int[] outlen, int waitType) {
        if (mBleInterfaceApi == null) {
            return -1;
        }
        int ret = mBleInterfaceApi.execSafeCommand(pCmd, cmdLen, outBuf, outlen, waitType);
        if (ret != 0) {
            return ret;
        }
        ret = XDJAKeyCmd.CheckResCode(outBuf, outlen[0]);
        if (ret == -2) {
            Log.i((String)BleErrID.LOG_TAG, (String)"sleep 1 second and retry");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ret = mBleInterfaceApi.execSafeCommand(pCmd, cmdLen, outBuf, outlen, waitType);
            if (ret != 0) {
                return ret;
            }
            ret = XDJAKeyCmd.CheckResCode(outBuf, outlen[0]);
        }
        outlen[0] = outlen[0] - 2;
        return ret;
    }

    public int ConnectService(Context context, String bleDevAddr, String bleDevName) {
        if (mBleInterfaceApi == null) {
            mBleInterfaceApi = new BleInterfaceApi(context);
        }
        return mBleInterfaceApi.ConnectBleService(bleDevAddr, bleDevName);
    }

    public void SetCallBack(BleCallback callback) {
        if (mBleInterfaceApi == null) {
            return;
        }
        mBleInterfaceApi.SetCallBack(callback);
    }

    public void DisConnectService() {
        if (mBleInterfaceApi == null) {
            return;
        }
        mBleInterfaceApi.DisConnectService();
    }

    public int ChangeToUsbmode() {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        cmdBuf[0] = -66;
        cmdBuf[1] = 1;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 4;
        int ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        return ret;
    }

    public int ChangeToSpimode() {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        cmdBuf[0] = -66;
        cmdBuf[1] = 2;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 4;
        int ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        return ret;
    }

    public XDJABleInfo GetConnectedDev() {
        if (mBleInterfaceApi == null) {
            return null;
        }
        return mBleInterfaceApi.GetConnectedDev();
    }

    public int GetBleServiceState() {
        if (mBleInterfaceApi == null) {
            return -1;
        }
        return mBleInterfaceApi.getCurrentState();
    }

    public int GetBattery() {
        byte[] cmdBuf = new byte[10];
        byte[] respBuf = new byte[10];
        int[] resLen = new int[2];
        cmdBuf[0] = -66;
        cmdBuf[1] = 4;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 4;
        int ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0) {
            return ret;
        }
        return respBuf[1];
    }

    public int Transmit(byte[] pCmd, int cmdLen, byte[] outBuf, int[] outlen) {
        if (cmdLen < 5) {
            return -9;
        }
        if (mBleInterfaceApi == null) {
            return -1;
        }
        int ret = mBleInterfaceApi.execSafeCommand(pCmd, cmdLen, outBuf, outlen, 0);
        return ret;
    }

    public int GetDevInfo(XDJA_DEVINFO devInfo) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        cmdBuf[0] = 0;
        cmdBuf[1] = -125;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 16;
        int ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0 || resLen[0] != 16) {
            return ret;
        }
        byte[] tmpcid = BleUtils.encodeHexStr(respBuf, resLen[0], false).getBytes();
        System.arraycopy(tmpcid, 0, devInfo.cardid, 0, 32);
        cmdBuf[0] = 0;
        cmdBuf[1] = -78;
        cmdBuf[2] = 1;
        cmdBuf[3] = 0;
        cmdBuf[4] = 64;
        ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0 || resLen[0] != 64) {
            return ret;
        }
        System.arraycopy(respBuf, 0, devInfo.cosver, 0, 64);
        devInfo.cardtype = 1792;
        devInfo.reserve = 0;
        return ret;
    }

    public int GetBleInfo(XDJABleVer bleInfo) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        cmdBuf[0] = 0;
        cmdBuf[1] = -125;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 16;
        int ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0 || resLen[0] != 16) {
            return ret;
        }
        byte[] tmpcid = BleUtils.encodeHexStr(respBuf, resLen[0], false).getBytes();
        System.arraycopy(tmpcid, 0, bleInfo.cardid, 0, 32);
        cmdBuf[0] = 0;
        cmdBuf[1] = -78;
        cmdBuf[2] = 1;
        cmdBuf[3] = 0;
        cmdBuf[4] = -128;
        ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0 || resLen[0] != 128) {
            return ret;
        }
        System.arraycopy(respBuf, 0, bleInfo.cosver, 0, 128);
        cmdBuf[0] = -66;
        cmdBuf[1] = 3;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 42;
        ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0 || resLen[0] != 42) {
            return ret;
        }
        System.arraycopy(respBuf, 0, bleInfo.blever, 0, 42);
        return ret;
    }

    public int GetActivateState() {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        cmdBuf[0] = 0;
        cmdBuf[1] = -78;
        cmdBuf[2] = 4;
        cmdBuf[3] = 0;
        cmdBuf[4] = 0;
        int ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        return ret;
    }

    public int ChangePIN(int pinRole, byte[] oldpin, int oldlen, byte[] newpin, int newlen) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        if (pinRole < 1 || pinRole > 22) {
            return -6;
        }
        if (oldlen < 3 || oldlen > 16 || newlen < 3 || newlen > 16) {
            return -9;
        }
        cmdBuf[0] = 0;
        cmdBuf[1] = -78;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = -121;
        int ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0) {
            return ret;
        }
        byte[] pub_n = new byte[128];
        System.arraycopy(respBuf, 2, pub_n, 0, 128);
        cmdBuf[0] = 0;
        cmdBuf[1] = -124;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 16;
        ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0) {
            return ret;
        }
        byte[] rdBuf = new byte[16];
        System.arraycopy(respBuf, 0, rdBuf, 0, 16);
        byte[] dataPlain = new byte[128];
        byte[] dataCipher = new byte[128];
        Arrays.fill(dataPlain, (byte)-1);
        dataPlain[0] = 0;
        dataPlain[1] = 2;
        dataPlain[63] = 0;
        Random random = new Random();
        byte[] token = new byte[16];
        random.nextBytes(token);
        System.arraycopy(rdBuf, 0, dataPlain, 64, 16);
        System.arraycopy(token, 0, dataPlain, 80, 16);
        Arrays.fill(dataPlain, 96, 112, (byte)6);
        System.arraycopy(oldpin, 0, dataPlain, 96, oldlen);
        Arrays.fill(dataPlain, 112, 128, (byte)6);
        System.arraycopy(newpin, 0, dataPlain, 112, newlen);
        try {
            BigInteger bigInteger = new BigInteger(BleUtils.ByteToHexString(pub_n, 128), 16);
            BigInteger bigInteger1 = new BigInteger("010001", 16);
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger1);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            dataCipher = cipher.doFinal(dataPlain);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        cmdBuf[0] = -128;
        cmdBuf[1] = 40;
        cmdBuf[2] = 0;
        cmdBuf[3] = (byte)pinRole;
        cmdBuf[4] = -128;
        System.arraycopy(dataCipher, 0, cmdBuf, 5, 128);
        ret = this.ExecApdu(cmdBuf, 133, respBuf, resLen);
        return ret;
    }

    public int GetPinTryCount(int pinRole) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        if (pinRole < 1 || pinRole > 22) {
            return -6;
        }
        cmdBuf[0] = 0;
        cmdBuf[1] = 32;
        cmdBuf[2] = 0;
        cmdBuf[3] = (byte)pinRole;
        cmdBuf[4] = 0;
        int ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        return ret;
    }

    public int VerifyPIN(int pinRole, byte[] pin, int pinlen) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        if (pinRole < 1 || pinRole > 22) {
            return -6;
        }
        cmdBuf[0] = 0;
        cmdBuf[1] = -78;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = -121;
        int ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0) {
            return ret;
        }
        byte[] pub_n = new byte[128];
        System.arraycopy(respBuf, 2, pub_n, 0, 128);
        cmdBuf[0] = 0;
        cmdBuf[1] = -124;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 16;
        ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0) {
            return ret;
        }
        byte[] rdBuf = new byte[16];
        System.arraycopy(respBuf, 0, rdBuf, 0, 16);
        byte[] dataPlain = new byte[128];
        byte[] dataCipher = new byte[128];
        Arrays.fill(dataPlain, (byte)-1);
        dataPlain[0] = 0;
        dataPlain[1] = 2;
        dataPlain[79] = 0;
        Random random = new Random();
        byte[] token = new byte[16];
        random.nextBytes(token);
        System.arraycopy(rdBuf, 0, dataPlain, 80, 16);
        System.arraycopy(token, 0, dataPlain, 96, 16);
        Arrays.fill(dataPlain, 112, 128, (byte)6);
        System.arraycopy(pin, 0, dataPlain, 112, pinlen);
        try {
            BigInteger bigInteger = new BigInteger(BleUtils.ByteToHexString(pub_n, 128), 16);
            BigInteger bigInteger1 = new BigInteger("010001", 16);
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger1);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            dataCipher = cipher.doFinal(dataPlain);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        cmdBuf[0] = 0;
        cmdBuf[1] = 34;
        cmdBuf[2] = 0;
        cmdBuf[3] = (byte)pinRole;
        cmdBuf[4] = -128;
        System.arraycopy(dataCipher, 0, cmdBuf, 5, 128);
        ret = this.ExecApdu(cmdBuf, 133, respBuf, resLen);
        return ret;
    }

    public int ReloadPIN(int pinRole, byte[] keystr, int keylen, byte[] newpin, int newlen) {
        int ret = 0;
        byte[] cmd = new byte[64];
        byte[] buf = new byte[64];
        byte[] mac = new byte[64];
        byte[] key = new byte[24];
        byte[] iv = new byte[8];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        if (keylen > 16 || keylen < 3) {
            return -9;
        }
        if (newlen > 16 || newlen < 3) {
            return -9;
        }
        if (pinRole < 1 || pinRole > 22) {
            return -9;
        }
        Arrays.fill(key, (byte)6);
        System.arraycopy(keystr, 0, key, 0, keylen);
        System.arraycopy(keystr, 0, key, 16, 8);
        Arrays.fill(buf, 0, 16, (byte)6);
        System.arraycopy(newpin, 0, buf, 0, newlen);
        buf[16] = -128;
        try {
            SecretKeySpec deskey = new SecretKeySpec(key, "DESede");
            Cipher c1 = Cipher.getInstance("DESede/ECB/Nopadding");
            c1.init(1, deskey);
            ret = c1.doFinal(buf, 0, 32, cmd, 5);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -9;
        }
        ret = this.GenRandom(4, iv);
        if (ret != 0) {
            return ret;
        }
        cmd[0] = -124;
        cmd[1] = 94;
        cmd[2] = 0;
        cmd[3] = (byte)pinRole;
        cmd[4] = 36;
        System.arraycopy(cmd, 0, buf, 0, 37);
        buf[37] = -128;
        try {
            SecretKeySpec deskey2 = new SecretKeySpec(key, "DESede");
            Cipher c2 = Cipher.getInstance("DESede/CBC/Nopadding");
            IvParameterSpec ips = new IvParameterSpec(iv);
            c2.init(1, (Key)deskey2, ips);
            ret = c2.doFinal(buf, 0, 48, mac, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -9;
        }
        System.arraycopy(mac, 32, cmd, 37, 4);
        ret = this.ExecApdu(cmd, 41, respBuf, resLen);
        return ret;
    }

    private static int CheckAcl(byte acl) {
        if (acl != 240 && acl != 15 && (acl = (byte)(acl & 0xF)) > 5) {
            return 0;
        }
        return 1;
    }

    public int CreateFile(XDJA_FILE pFile) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        if (pFile.id[0] == 63 && pFile.id[1] == 0) {
            return -9;
        }
        if (pFile.type == 4 || pFile.id[0] == 0 && pFile.id[1] == 1) {
            return -9;
        }
        cmdBuf[0] = -128;
        cmdBuf[1] = -32;
        cmdBuf[2] = pFile.id[0];
        cmdBuf[3] = pFile.id[1];
        cmdBuf[4] = 7;
        if (1 == pFile.type) {
            if (XDJAKeyCmd.CheckAcl(pFile.read_Acl) == 0 || XDJAKeyCmd.CheckAcl(pFile.write_Acl) == 0) {
                return -9;
            }
            cmdBuf[5] = 40;
            cmdBuf[6] = (byte)(pFile.room / 256);
            cmdBuf[7] = (byte)(pFile.room % 256);
            cmdBuf[8] = pFile.read_Acl;
            cmdBuf[9] = pFile.write_Acl;
            cmdBuf[10] = -1;
            cmdBuf[11] = -1;
        } else if (2 == pFile.type) {
            if (XDJAKeyCmd.CheckAcl(pFile.use_Acl) == 0 || XDJAKeyCmd.CheckAcl(pFile.write_Acl) == 0 || XDJAKeyCmd.CheckAcl(pFile.read_Acl) == 0) {
                return -9;
            }
            cmdBuf[5] = 62;
            cmdBuf[6] = (byte)(pFile.room / 256);
            cmdBuf[7] = (byte)(pFile.room % 256);
            cmdBuf[8] = pFile.use_Acl;
            cmdBuf[9] = pFile.write_Acl;
            cmdBuf[10] = pFile.read_Acl;
            cmdBuf[11] = -1;
        } else if (3 == pFile.type) {
            if (XDJAKeyCmd.CheckAcl(pFile.use_Acl) == 0 || XDJAKeyCmd.CheckAcl(pFile.write_Acl) == 0) {
                return -9;
            }
            cmdBuf[5] = 61;
            cmdBuf[6] = (byte)(pFile.room / 256);
            cmdBuf[7] = (byte)(pFile.room % 256);
            cmdBuf[8] = pFile.use_Acl;
            cmdBuf[9] = pFile.write_Acl;
            cmdBuf[10] = 15;
            cmdBuf[11] = -1;
        } else {
            return -9;
        }
        int ret = this.ExecApdu(cmdBuf, 12, respBuf, resLen);
        return ret;
    }

    public int SelectFile(byte[] fid) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        cmdBuf[0] = 0;
        cmdBuf[1] = -92;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 2;
        cmdBuf[5] = fid[0];
        cmdBuf[6] = fid[1];
        int ret = this.ExecApdu(cmdBuf, 7, respBuf, resLen);
        return ret;
    }

    public int ReadFile(byte[] fid, int readPos, int readLen, byte[] pDataout) {
        int readed = 0;
        int pos = 0;
        int data_len = 174;
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = this.SelectFile(fid);
        if (ret != 0) {
            return ret;
        }
        pos = readPos;
        while (readLen > 0) {
            int len = readLen > data_len ? data_len : readLen;
            cmdBuf[0] = 0;
            cmdBuf[1] = -80;
            cmdBuf[2] = (byte)(pos / 256);
            cmdBuf[3] = (byte)(pos % 256);
            cmdBuf[4] = (byte)len;
            ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
            if (ret != 0) {
                return ret;
            }
            System.arraycopy(respBuf, 0, pDataout, readed, resLen[0]);
            readLen -= len;
            pos += len;
            readed += len;
        }
        return ret;
    }

    public int WriteFile(byte[] fid, int writePos, int writeLen, byte[] pDatain) {
        int ret = 0;
        int wrote = 0;
        int pos = 0;
        int data_len = 171;
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        ret = this.SelectFile(fid);
        if (ret != 0) {
            return ret;
        }
        pos = wrote;
        while (writeLen > 0) {
            int len = writeLen > data_len ? data_len : writeLen;
            cmdBuf[0] = 0;
            cmdBuf[1] = -42;
            cmdBuf[2] = (byte)(pos / 256);
            cmdBuf[3] = (byte)(pos % 256);
            cmdBuf[4] = (byte)len;
            System.arraycopy(pDatain, wrote, cmdBuf, 5, len);
            ret = this.ExecApdu(cmdBuf, len + 5, respBuf, resLen);
            if (ret != 0) {
                return ret;
            }
            writeLen -= len;
            pos += len;
            wrote += len;
        }
        return ret;
    }

    public int ReadRsaPubKey(byte[] fid, XDJA_RSA_PUBKEY pPub) {
        return 0;
    }

    public int ReadSm2PubKey(byte[] fid, XDJA_SM2_PUBKEY pPub) {
        return 0;
    }

    public int ReadCert(byte[] fid, byte[] certBuf, int[] certLen) {
        byte[] respBuf = new byte[512];
        int ret = 0;
        ret = this.ReadFile(fid, 0, 4, respBuf);
        if (ret != 0) {
            return ret;
        }
        certLen[0] = (respBuf[2] & 0xFF) << 8 | respBuf[3] & 0xFF;
        if (certLen[0] < 100 || certLen[0] > 1536) {
            return -49;
        }
        if (certBuf != null) {
            ret = this.ReadFile(fid, 4, certLen[0], certBuf);
        }
        return ret;
    }

    public int GenRandom(int len, byte[] pRandom) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        int pos = 0;
        int BLOCK = 158;
        if (len <= 0) {
            return -9;
        }
        cmdBuf[0] = 0;
        cmdBuf[1] = -124;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        while (len > 0) {
            int packLen = len > BLOCK ? BLOCK : len;
            cmdBuf[4] = (byte)packLen;
            ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
            if (ret != 0) {
                return ret;
            }
            System.arraycopy(respBuf, 0, pRandom, pos, packLen);
            len -= packLen;
            pos += packLen;
        }
        return ret;
    }

    public int SM1(byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte kID, byte[] pIV) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int packLen = 128;
        int startPos = 0;
        int cipherLen = 0;
        int cmdLen = 0;
        int ret = 0;
        if (dataLen % 16 != 0) {
            return -9;
        }
        if ((flag & 0xF0) == 0) {
            packLen += 16;
            cmdBuf[2] = 0;
        } else {
            cmdBuf[2] = 2;
            if (pIV == null) {
                return -9;
            }
        }
        cmdBuf[0] = 0;
        cmdBuf[1] = -120;
        cmdBuf[3] = kID;
        while (dataLen > 0) {
            if (flag == 0 || flag == 1) {
                cipherLen = dataLen > packLen ? packLen : dataLen;
                cmdBuf[4] = (byte)cipherLen;
                System.arraycopy(pDataIn, startPos, cmdBuf, 5, cipherLen);
                cmdLen = 5 + cipherLen;
            } else {
                cipherLen = dataLen > packLen ? packLen : dataLen;
                cmdBuf[4] = (byte)(cipherLen + 16);
                System.arraycopy(pIV, 0, cmdBuf, 5, 16);
                System.arraycopy(pDataIn, startPos, cmdBuf, 21, cipherLen);
                cmdLen = 21 + cipherLen;
            }
            resLen[0] = cipherLen;
            ret = this.ExecApdu(cmdBuf, cmdLen, respBuf, resLen);
            if (ret != 0) {
                return ret;
            }
            if (resLen[0] > pDataOut.length) {
                return -3;
            }
            System.arraycopy(respBuf, 0, pDataOut, startPos, resLen[0]);
            if (flag == 16) {
                System.arraycopy(pDataIn, startPos + cipherLen - 16, pIV, 0, 16);
            } else if (flag == 17) {
                System.arraycopy(pDataOut, startPos + cipherLen - 16, pIV, 0, 16);
            }
            startPos += cipherLen;
            dataLen -= cipherLen;
        }
        return ret;
    }

    public int SM1KEY(byte[] tmpkey, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte[] pIV) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int packLen = 128;
        int startPos = 0;
        int cipherLen = 0;
        int cmdLen = 0;
        int ret = 0;
        if (dataLen % 16 != 0) {
            return -9;
        }
        if ((flag & 0xF0) == 0) {
            packLen += 16;
        } else if (pIV == null) {
            return -9;
        }
        cmdBuf[0] = 0;
        cmdBuf[1] = -121;
        cmdBuf[3] = 0;
        cmdBuf[2] = flag == 0 ? 2 : (flag == 1 ? 0 : (flag == 16 ? 3 : 1));
        while (dataLen > 0) {
            if (flag == 0 || flag == 1) {
                cipherLen = dataLen > packLen ? packLen : dataLen;
                cmdBuf[4] = (byte)(cipherLen + 16);
                System.arraycopy(tmpkey, 0, cmdBuf, 5, 16);
                System.arraycopy(pDataIn, startPos, cmdBuf, 21, cipherLen);
                cmdLen = 21 + cipherLen;
            } else {
                cipherLen = dataLen > packLen ? packLen : dataLen;
                cmdBuf[4] = (byte)(cipherLen + 16 + 16);
                System.arraycopy(tmpkey, 0, cmdBuf, 5, 16);
                System.arraycopy(pIV, 0, cmdBuf, 21, 16);
                System.arraycopy(pDataIn, startPos, cmdBuf, 37, cipherLen);
                cmdLen = 37 + cipherLen;
            }
            resLen[0] = cipherLen;
            ret = this.ExecApdu(cmdBuf, cmdLen, respBuf, resLen);
            if (ret != 0) {
                return ret;
            }
            if (resLen[0] > pDataOut.length) {
                return -3;
            }
            System.arraycopy(respBuf, 0, pDataOut, startPos, resLen[0]);
            if (flag == 16) {
                System.arraycopy(pDataIn, startPos + cipherLen - 16, pIV, 0, 16);
            } else if (flag == 17) {
                System.arraycopy(pDataOut, startPos + cipherLen - 16, pIV, 0, 16);
            }
            startPos += cipherLen;
            dataLen -= cipherLen;
        }
        return ret;
    }

    public int SM4KEYEx(byte[] tmpkey, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte[] pIV) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int packLen = 128;
        int startPos = 0;
        int cipherLen = 0;
        int cmdLen = 0;
        int ret = 0;
        if (dataLen % 16 != 0) {
            return -9;
        }
        if ((flag & 0xF0) == 0) {
            packLen += 16;
        } else if (pIV == null) {
            return -9;
        }
        cmdBuf[0] = 0;
        cmdBuf[1] = -121;
        cmdBuf[3] = 3;
        cmdBuf[2] = flag == 0 ? 2 : (flag == 1 ? 0 : (flag == 16 ? 3 : 1));
        while (dataLen > 0) {
            if (flag == 0 || flag == 1) {
                cipherLen = dataLen > packLen ? packLen : dataLen;
                cmdBuf[4] = (byte)(cipherLen + 16);
                System.arraycopy(tmpkey, 0, cmdBuf, 5, 16);
                System.arraycopy(pDataIn, startPos, cmdBuf, 21, cipherLen);
                cmdLen = 21 + cipherLen;
            } else {
                cipherLen = dataLen > packLen ? packLen : dataLen;
                cmdBuf[4] = (byte)(cipherLen + 16 + 16);
                System.arraycopy(tmpkey, 0, cmdBuf, 5, 16);
                System.arraycopy(pIV, 0, cmdBuf, 21, 16);
                System.arraycopy(pDataIn, startPos, cmdBuf, 37, cipherLen);
                cmdLen = 37 + cipherLen;
            }
            resLen[0] = cipherLen;
            ret = this.ExecApdu(cmdBuf, cmdLen, respBuf, resLen);
            if (ret != 0) {
                return ret;
            }
            System.arraycopy(respBuf, 0, pDataOut, startPos, resLen[0]);
            if (flag == 16) {
                System.arraycopy(pDataIn, startPos + cipherLen - 16, pIV, 0, 16);
            } else if (flag == 17) {
                System.arraycopy(pDataOut, startPos + cipherLen - 16, pIV, 0, 16);
            }
            startPos += cipherLen;
            dataLen -= cipherLen;
        }
        return ret;
    }

    public int SHA1Ex(byte[] pDataIn, int dataLen, byte[] pDataOut) {
        int BLOCK = 171;
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        cmdBuf[0] = -128;
        cmdBuf[1] = -52;
        if (dataLen < BLOCK) {
            cmdBuf[2] = 0;
            cmdBuf[3] = (byte)dataLen;
            cmdBuf[4] = (byte)dataLen;
            System.arraycopy(pDataIn, 0, cmdBuf, 5, dataLen);
            ret = this.ExecApdu(cmdBuf, 5 + dataLen, pDataOut, resLen);
        } else {
            int times = dataLen / BLOCK;
            int left = dataLen % BLOCK;
            if (left == 0) {
                left = BLOCK;
                --times;
            }
            cmdBuf[2] = 1;
            cmdBuf[3] = 0;
            cmdBuf[4] = (byte)BLOCK;
            System.arraycopy(pDataIn, 0, cmdBuf, 5, BLOCK);
            ret = this.ExecApdu(cmdBuf, 5 + BLOCK, respBuf, resLen);
            if (ret == 0) {
                for (int i = 0; i < times; ++i) {
                    cmdBuf[2] = 2;
                    cmdBuf[3] = 0;
                    cmdBuf[4] = (byte)BLOCK;
                    System.arraycopy(pDataIn, i * BLOCK, cmdBuf, 5, BLOCK);
                    ret = this.ExecApdu(cmdBuf, 5 + BLOCK, respBuf, resLen);
                    if (ret == 0) continue;
                    return ret;
                }
                if (ret == 0) {
                    cmdBuf[2] = -1;
                    cmdBuf[3] = 0;
                    cmdBuf[4] = (byte)left;
                    System.arraycopy(pDataIn, times * BLOCK, cmdBuf, 5, left);
                    ret = this.ExecApdu(cmdBuf, 5 + left, pDataOut, resLen);
                }
            }
        }
        return ret;
    }

    public int SM3(byte[] pDatain, int dataLen, byte[] pDataOut) {
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(pDatain, 0, dataLen);
        byte[] hash = sm3Digest.doFinal();
        System.arraycopy(hash, 0, pDataOut, 0, 32);
        return 0;
    }

    public int SM3Ex(byte[] pDatain, int dataLen, byte[] pDataOut) {
        int BLOCK = 171;
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        cmdBuf[0] = -128;
        cmdBuf[1] = -69;
        if (dataLen < BLOCK) {
            cmdBuf[2] = 0;
            cmdBuf[3] = (byte)dataLen;
            cmdBuf[4] = (byte)dataLen;
            System.arraycopy(pDatain, 0, cmdBuf, 5, dataLen);
            ret = this.ExecApdu(cmdBuf, 5 + dataLen, pDataOut, resLen);
        } else {
            int times = dataLen / BLOCK;
            int left = dataLen % BLOCK;
            if (left == 0) {
                left = BLOCK;
                --times;
            }
            cmdBuf[2] = 1;
            cmdBuf[3] = 0;
            cmdBuf[4] = (byte)BLOCK;
            System.arraycopy(pDatain, 0, cmdBuf, 5, BLOCK);
            ret = this.ExecApdu(cmdBuf, 5 + BLOCK, respBuf, resLen);
            if (ret == 0) {
                for (int i = 0; i < times; ++i) {
                    cmdBuf[2] = 2;
                    cmdBuf[3] = 0;
                    cmdBuf[4] = (byte)BLOCK;
                    System.arraycopy(pDatain, i * BLOCK, cmdBuf, 5, BLOCK);
                    ret = this.ExecApdu(cmdBuf, 5 + BLOCK, respBuf, resLen);
                    if (ret == 0) continue;
                    return ret;
                }
                if (ret == 0) {
                    cmdBuf[2] = -1;
                    cmdBuf[3] = 0;
                    cmdBuf[4] = (byte)left;
                    System.arraycopy(pDatain, times * BLOCK, cmdBuf, 5, left);
                    ret = this.ExecApdu(cmdBuf, 5 + left, pDataOut, resLen);
                }
            }
        }
        return ret;
    }

    public int GenRSAKeyPair(int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pPub, XDJA_RSA_PRIKEY pPri) {
        if (bits != 1024 && bits != 2048) {
            return -9;
        }
        if (pubfid[1] == 0 && prifid[1] == 0) {
            return -98;
        }
        if (pubfid[1] == 0 && pPub == null) {
            return -9;
        }
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        cmdBuf[0] = -128;
        cmdBuf[1] = -50;
        cmdBuf[2] = pubfid[1];
        cmdBuf[3] = prifid[1];
        cmdBuf[4] = bits == 1024 ? (byte)0 : 1;
        ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen, 1);
        if (ret != 0) {
            return ret;
        }
        if (pubfid[1] == 0) {
            if (respBuf[0] != 110 || respBuf[130] != 101) {
                return -34;
            }
            pPub.bits = 1024;
            System.arraycopy(respBuf, 2, pPub.m, 0, 128);
            pPub.e = 65537;
        }
        return ret;
    }

    public int RSAPubKeyCalc(byte[] fid, XDJA_RSA_PUBKEY pPub, byte[] pDataIn, int dlen, byte[] pDataOut, int[] outLen) {
        byte[] respBuf = new byte[512];
        if (dlen != 128 && dlen != 256) {
            return -9;
        }
        int ret = 0;
        if (fid[1] == 0) {
            if (pPub == null) {
                return -9;
            }
            try {
                BigInteger bigInteger = new BigInteger(BleUtils.ByteToHexString(pPub.m, 128), 16);
                BigInteger bigInteger1 = new BigInteger("010001", 16);
                RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger1);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(1, publicKey);
                byte[] dataout = cipher.doFinal(pDataIn, 0, dlen);
                outLen[0] = dataout.length;
                System.arraycopy(dataout, 0, pDataOut, 0, dataout.length);
                ret = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -36;
            }
        } else {
            byte[] cmdBuf = new byte[512];
            cmdBuf[0] = -128;
            cmdBuf[1] = -58;
            cmdBuf[2] = fid[0];
            cmdBuf[3] = fid[1];
            cmdBuf[4] = (byte)dlen;
            System.arraycopy(pDataIn, 0, cmdBuf, 5, dlen);
            ret = this.ExecApdu(cmdBuf, dlen + 5, respBuf, outLen);
            if (ret == 0) {
                System.arraycopy(respBuf, 0, pDataOut, 0, outLen[0]);
            }
        }
        return ret;
    }

    public int RSAPriKeyCalc(byte[] fid, byte[] pDataIn, int dlen, byte[] pDataOut, int[] outLen) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int ret = 0;
        if (dlen != 128 && dlen != 256) {
            return -9;
        }
        cmdBuf[0] = -128;
        cmdBuf[1] = -56;
        cmdBuf[2] = fid[0];
        cmdBuf[3] = fid[1];
        cmdBuf[4] = (byte)dlen;
        System.arraycopy(pDataIn, 0, cmdBuf, 5, dlen);
        ret = this.ExecApdu(cmdBuf, dlen + 5, respBuf, outLen);
        if (ret == 0) {
            System.arraycopy(respBuf, 0, pDataOut, 0, outLen[0]);
        }
        return ret;
    }

    public int GetSM2Id(byte[] sm2id, int[] outlen) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        cmdBuf[0] = 0;
        cmdBuf[1] = -114;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 0;
        ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret == 0 && resLen[0] > 0) {
            outlen[0] = resLen[0];
            if (sm2id != null) {
                System.arraycopy(respBuf, 0, sm2id, 0, outlen[0]);
            }
        }
        return ret;
    }

    public int SetSM2Id(byte[] sm2id, int dlen) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        cmdBuf[0] = 0;
        cmdBuf[1] = -38;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = (byte)(dlen + 3);
        cmdBuf[5] = 73;
        cmdBuf[6] = 68;
        cmdBuf[7] = (byte)dlen;
        System.arraycopy(sm2id, 0, cmdBuf, 8, dlen);
        ret = this.ExecApdu(cmdBuf, 8 + dlen, respBuf, resLen);
        return ret;
    }

    public int GetSM2Param(XDJA_SM2_PARAM sm2param) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        cmdBuf[0] = 0;
        cmdBuf[1] = -98;
        cmdBuf[2] = 0;
        cmdBuf[3] = 0;
        cmdBuf[4] = 0;
        ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret == 0) {
            System.arraycopy(respBuf, 2, sm2param.p, 0, 32);
            System.arraycopy(respBuf, 36, sm2param.a, 0, 32);
            System.arraycopy(respBuf, 70, sm2param.b, 0, 32);
            System.arraycopy(respBuf, 104, sm2param.n, 0, 32);
            System.arraycopy(respBuf, 138, sm2param.x, 0, 32);
            System.arraycopy(respBuf, 172, sm2param.y, 0, 32);
        }
        return ret;
    }

    public int SetSM2Param(XDJA_SM2_PARAM sm2param) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        cmdBuf[0] = 0;
        cmdBuf[1] = -40;
        cmdBuf[2] = 1;
        cmdBuf[3] = 0;
        cmdBuf[4] = -52;
        cmdBuf[5] = 112;
        cmdBuf[6] = 32;
        System.arraycopy(sm2param.p, 0, cmdBuf, 7, 32);
        cmdBuf[39] = 97;
        cmdBuf[40] = 32;
        System.arraycopy(sm2param.a, 0, cmdBuf, 41, 32);
        cmdBuf[73] = 98;
        cmdBuf[74] = 32;
        System.arraycopy(sm2param.b, 0, cmdBuf, 75, 32);
        cmdBuf[107] = 110;
        cmdBuf[108] = 32;
        System.arraycopy(sm2param.n, 0, cmdBuf, 109, 32);
        cmdBuf[141] = 120;
        cmdBuf[142] = 32;
        System.arraycopy(sm2param.x, 0, cmdBuf, 143, 32);
        cmdBuf[175] = 121;
        cmdBuf[176] = 32;
        System.arraycopy(sm2param.y, 0, cmdBuf, 177, 32);
        ret = this.ExecApdu(cmdBuf, 209, respBuf, resLen);
        return 0;
    }

    public int GenSM2KeyPair(byte[] pubkeyid, byte[] prikeyid, XDJA_SM2_PUBKEY sm2pubkey, XDJA_SM2_PRIKEY sm2prikey) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        cmdBuf[0] = -128;
        cmdBuf[1] = -66;
        cmdBuf[2] = pubkeyid[1];
        cmdBuf[3] = prikeyid[1];
        cmdBuf[4] = 0;
        ret = this.ExecApdu(cmdBuf, 5, respBuf, resLen);
        if (ret != 0) {
            return ret;
        }
        if (pubkeyid[1] == 0) {
            System.arraycopy(respBuf, 2, sm2pubkey.x, 0, 32);
            System.arraycopy(respBuf, 36, sm2pubkey.y, 0, 32);
        }
        if (prikeyid[1] == 0) {
            System.arraycopy(respBuf, 70, sm2prikey.d, 0, 32);
        }
        return ret;
    }

    public int SM2Encrypt(byte[] pubkeyid, XDJA_SM2_PUBKEY sm2pubkey, byte[] pDatain, int dlen, byte[] pDataout, int[] outLen) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        if (pubkeyid[0] != 0) {
            return -9;
        }
        if (pubkeyid[1] == 0 && sm2pubkey == null) {
            return -9;
        }
        if (dlen <= 0 && dlen > 58) {
            return -9;
        }
        if (pubkeyid[1] == 0) {
            cmdBuf[0] = -128;
            cmdBuf[1] = -52;
            cmdBuf[2] = 0;
            cmdBuf[3] = 1;
            cmdBuf[4] = 68;
            cmdBuf[5] = 120;
            cmdBuf[6] = 32;
            System.arraycopy(sm2pubkey.x, 0, cmdBuf, 7, 32);
            cmdBuf[39] = 121;
            cmdBuf[40] = 32;
            System.arraycopy(sm2pubkey.y, 0, cmdBuf, 41, 32);
            ret = this.ExecApdu(cmdBuf, 73, respBuf, resLen);
            if (ret != 0) {
                return ret;
            }
        }
        cmdBuf[0] = -128;
        cmdBuf[1] = -74;
        cmdBuf[2] = 0;
        cmdBuf[3] = pubkeyid[1];
        cmdBuf[4] = (byte)dlen;
        System.arraycopy(pDatain, 0, cmdBuf, 5, dlen);
        ret = this.ExecApdu(cmdBuf, 5 + dlen, respBuf, outLen);
        if (ret == 0) {
            System.arraycopy(respBuf, 0, pDataout, 0, outLen[0]);
        }
        return ret;
    }

    public int SM2Decrypt(byte[] prikeyid, byte[] pDatain, int dlen, byte[] pDataout, int[] outlen) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int ret = 0;
        cmdBuf[0] = -128;
        cmdBuf[1] = -72;
        cmdBuf[2] = 0;
        cmdBuf[3] = prikeyid[1];
        cmdBuf[4] = (byte)dlen;
        System.arraycopy(pDatain, 0, cmdBuf, 5, dlen);
        ret = this.ExecApdu(cmdBuf, dlen + 5, respBuf, outlen);
        if (ret == 0) {
            System.arraycopy(respBuf, 0, pDataout, 0, outlen[0]);
        }
        return ret;
    }

    private void DoSm3CalZa(byte[] id, int idlen, XDJA_SM2_PARAM sm2para, XDJA_SM2_PUBKEY pubkey, byte[] m, int mlen, byte[] hash) {
        int idlenbit = idlen * 8;
        byte[] idbuf = new byte[2];
        byte[] databuf = new byte[mlen + 256];
        SM3Digest sm3Digest = new SM3Digest();
        idbuf[0] = (byte)(idlenbit >> 8);
        idbuf[1] = (byte)idlenbit;
        System.arraycopy(idbuf, 0, databuf, 0, 2);
        System.arraycopy(id, 0, databuf, 2, idlen);
        System.arraycopy(sm2para.a, 0, databuf, 2 + idlen, 32);
        System.arraycopy(sm2para.b, 0, databuf, 2 + idlen + 32, 32);
        System.arraycopy(sm2para.x, 0, databuf, 2 + idlen + 32 + 32, 32);
        System.arraycopy(sm2para.y, 0, databuf, 2 + idlen + 32 + 32 + 32, 32);
        System.arraycopy(pubkey.x, 0, databuf, 2 + idlen + 32 + 32 + 32 + 32, 32);
        System.arraycopy(pubkey.y, 0, databuf, 2 + idlen + 32 + 32 + 32 + 32 + 32, 32);
        sm3Digest.update(databuf, 0, 2 + idlen + 32 + 32 + 32 + 32 + 32 + 32);
        byte[] dataZ = sm3Digest.doFinal();
        sm3Digest = new SM3Digest();
        System.arraycopy(dataZ, 0, databuf, 0, 32);
        System.arraycopy(m, 0, databuf, 32, mlen);
        sm3Digest.update(databuf, 0, 32 + mlen);
        byte[] dataE = sm3Digest.doFinal();
        System.arraycopy(dataE, 0, hash, 0, 32);
    }

    public int SM2Sign(byte[] pubkeyid, byte[] prikeyid, int datatype, byte[] pDatain, int dlen, byte[] signData, int[] outlen) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        byte[] hash = new byte[32];
        byte[] id = new byte[128];
        int[] idLen = new int[2];
        XDJA_SM2_PARAM param = new XDJA_SM2_PARAM();
        XDJA_SM2_PUBKEY pubkey = new XDJA_SM2_PUBKEY();
        if (prikeyid[1] == 0) {
            return -9;
        }
        if (datatype != 1 && datatype != 0) {
            return -9;
        }
        if (datatype == 0 && dlen != 32) {
            return -9;
        }
        if (datatype == 1) {
            if (pubkeyid[1] == 0) {
                return -9;
            }
            ret = this.GetSM2Id(id, idLen);
            if (ret != 0) {
                return ret;
            }
            ret = this.GetSM2Param(param);
            if (ret != 0) {
                return ret;
            }
            ret = this.ReadFile(pubkeyid, 0, 68, respBuf);
            if (ret != 0) {
                return ret;
            }
            System.arraycopy(respBuf, 2, pubkey.x, 0, 32);
            System.arraycopy(respBuf, 36, pubkey.y, 0, 32);
            this.DoSm3CalZa(id, 16, param, pubkey, pDatain, dlen, hash);
        } else {
            System.arraycopy(pDatain, 0, hash, 0, 32);
        }
        cmdBuf[0] = -128;
        cmdBuf[1] = -30;
        cmdBuf[2] = 0;
        cmdBuf[3] = prikeyid[1];
        cmdBuf[4] = 34;
        cmdBuf[5] = 101;
        cmdBuf[6] = 32;
        System.arraycopy(hash, 0, cmdBuf, 7, 32);
        ret = this.ExecApdu(cmdBuf, 39, respBuf, resLen);
        if (ret == 0) {
            System.arraycopy(respBuf, 0, signData, 0, resLen[0]);
            outlen[0] = resLen[0];
        }
        return ret;
    }

    public int SM2SignVerify(byte[] pubkeyid, int datatype, XDJA_SM2_PUBKEY sm2pubkey, byte[] pDatain, int dlen, byte[] signData) {
        byte[] cmdBuf = new byte[512];
        byte[] respBuf = new byte[512];
        int[] resLen = new int[2];
        int ret = 0;
        byte[] hash = new byte[32];
        byte[] id = new byte[128];
        int[] idLen = new int[2];
        XDJA_SM2_PARAM param = new XDJA_SM2_PARAM();
        XDJA_SM2_PUBKEY pubkey = new XDJA_SM2_PUBKEY();
        if (pubkeyid[1] == 0 && sm2pubkey == null) {
            return -9;
        }
        if (datatype != 1 && datatype != 0) {
            return -9;
        }
        if (datatype == 0 && dlen != 32) {
            return -9;
        }
        if (datatype == 1) {
            if (pubkeyid[1] == 0) {
                return -9;
            }
            ret = this.GetSM2Id(id, idLen);
            if (ret != 0) {
                return ret;
            }
            ret = this.GetSM2Param(param);
            if (ret != 0) {
                return ret;
            }
            if (pubkeyid[1] != 0) {
                ret = this.ReadFile(pubkeyid, 0, 68, respBuf);
                if (ret != 0) {
                    return ret;
                }
                System.arraycopy(respBuf, 2, pubkey.x, 0, 32);
                System.arraycopy(respBuf, 36, pubkey.y, 0, 32);
            } else {
                pubkey = sm2pubkey;
            }
            this.DoSm3CalZa(id, idLen[0], param, pubkey, pDatain, dlen, hash);
        } else {
            System.arraycopy(pDatain, 0, hash, 0, 32);
        }
        if (pubkeyid[1] == 0) {
            cmdBuf[0] = -128;
            cmdBuf[1] = -52;
            cmdBuf[2] = 0;
            cmdBuf[3] = 1;
            cmdBuf[4] = 68;
            cmdBuf[5] = 120;
            cmdBuf[6] = 32;
            System.arraycopy(sm2pubkey.x, 0, cmdBuf, 7, 32);
            cmdBuf[39] = 121;
            cmdBuf[40] = 32;
            System.arraycopy(sm2pubkey.y, 0, cmdBuf, 41, 32);
            ret = this.ExecApdu(cmdBuf, 73, respBuf, resLen);
            if (ret != 0) {
                return ret;
            }
        }
        cmdBuf[0] = -128;
        cmdBuf[1] = -28;
        cmdBuf[2] = 0;
        cmdBuf[3] = pubkeyid[1];
        cmdBuf[4] = 102;
        cmdBuf[5] = 101;
        cmdBuf[6] = 32;
        System.arraycopy(hash, 0, cmdBuf, 7, 32);
        cmdBuf[39] = 114;
        cmdBuf[40] = 32;
        System.arraycopy(signData, 0, cmdBuf, 41, 32);
        cmdBuf[73] = 115;
        cmdBuf[74] = 32;
        System.arraycopy(signData, 32, cmdBuf, 75, 32);
        ret = this.ExecApdu(cmdBuf, 107, respBuf, resLen);
        return ret;
    }

    public int SM2KeyGenInit(byte[] pubkeyid, byte[] pdataout, int[] outlen) {
        return 0;
    }

    public int SM2KeyGenCompute(byte[] pubkeyid, byte[] prikeyid, byte[] pDatain, int dlen, byte[] pDataout, int[] outlen, byte dictflag, byte keyflag) {
        return 0;
    }

    public int SM2KeyGenVerify(byte[] pDatain, int dlen) {
        return 0;
    }
}

