/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.taisys.model.Card;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.process.coveredcard.CCJniApi;
import com.xdja.tmc.TMCAPI;

public class CCHandleInit {
    private static final String TAG = "CCHandleIntTag";
    private Context context;
    XDJA_DEVINFO mDevInfo = new XDJA_DEVINFO();
    private static CCHandleInit instance;
    InitThread initThread;

    private CCHandleInit(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CCHandleInit getInstance(Context context) {
        if (context == null) {
            throw new NullPointerException("Context is null!");
        }
        if (instance != null) return instance;
        Class<CCHandleInit> clazz = CCHandleInit.class;
        synchronized (CCHandleInit.class) {
            if (instance != null) return instance;
            instance = new CCHandleInit(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int openCard(CCJniApi jniApi) {
        if (this.initThread == null) {
            Class<CCHandleInit> clazz = CCHandleInit.class;
            // MONITORENTER : com.xdja.multichip.process.coveredcard.CCHandleInit.class
            if (this.initThread == null) {
                this.initThread = new InitThread(this.context);
            }
            // MONITOREXIT : clazz
        }
        this.initThread.initCard(jniApi);
        int ret = this.initThread.judgeCardIsConnect(jniApi, 4000L);
        if (ret == 0) return ret;
        return -1;
    }

    class InitThread {
        HandlerThread handlerThread;
        Handler handler;
        private Context context;
        private boolean openFlag = false;
        static final int MSG_INIT_CCCARD = 1;
        public static final int RET_OK = 0;
        public static final int RET_OVERTIME = -1;

        public InitThread(Context context) {
            this.context = context;
            this.handlerThread = new HandlerThread("InitCCCard");
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper()){

                public void handleMessage(Message msg) {
                    InitThread.this.selfHandleMessage(msg);
                }
            };
        }

        public void initCard(CCJniApi jniApi) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = jniApi;
            this.handler.sendMessage(msg);
        }

        private int judgeCardIsConnect(CCJniApi jniApi, long waitTime) {
            int ret = 0;
            int singleWaitTime = 350;
            long realWaitTime = 0L;
            this.openFlag = false;
            long startTime = System.currentTimeMillis();
            block4: while (true) {
                try {
                    long nowTime;
                    while ((realWaitTime = (nowTime = System.currentTimeMillis()) - startTime) < waitTime) {
                        SystemClock.sleep((long)singleWaitTime);
                        ret = jniApi.getTMCAPI().GetDevInfo(CCHandleInit.this.mDevInfo);
                        if (ret != 0) continue;
                        break block4;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            if (realWaitTime >= waitTime) {
                Log.w((String)CCHandleInit.TAG, (String)"isConnect--check timeout ");
                ret = -1;
            } else {
                try {
                    Log.w((String)CCHandleInit.TAG, (String)("OpenSEService otiType " + jniApi.getTMCAPI().GetOtiType()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }

        private void selfHandleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    try {
                        final TMCAPI tmcapi = ((CCJniApi)((Object)msg.obj)).getTMCAPI();
                        tmcapi.CloseSEService();
                        tmcapi.OpenSEService(this.context, new Card.SCSupported(){

                            public void isSupported(boolean b) {
                                String otiType = tmcapi.GetOtiType();
                                InitThread.this.openFlag = b;
                                Log.w((String)CCHandleInit.TAG, (String)("OpenSEService is supported " + b + " otiType: " + otiType));
                            }
                        });
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

