/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SupperJniApiBinder;
import com.xdja.multichip.process.coveredcard.CCHandleInit;
import com.xdja.multichip.process.coveredcard.CCJniApi;
import com.xdja.multichip.process.coveredcard.CCProcessService;
import java.util.ArrayList;
import java.util.Arrays;

public class CCJniApiBinder
extends SupperJniApiBinder {
    public static final String TAG = "CCJniApiBinderTag";
    private Context context;
    private CCJniApi ccJniApi = null;
    private static CCJniApiBinder instance;
    XDJA_DEVINFO lastDevInfo = new XDJA_DEVINFO();
    ArrayList<Messenger> messengerList = new ArrayList();
    Boolean flag = true;
    BroadcastReceiver receiver = new BroadcastReceiver(){
        private static final String ACTION_SIM_STATE_CHANGED = "android.intent.action.SIM_STATE_CHANGED";

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(ACTION_SIM_STATE_CHANGED)) {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                int state = tm.getSimState();
                switch (state) {
                    case 5: {
                        break;
                    }
                    case 6: {
                        Log.w((String)CCJniApiBinder.TAG, (String)"Sim state change to absent! 6666");
                    }
                    case 1: {
                        CCJniApiBinder.this.handleSimAbsent();
                        break;
                    }
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CCJniApiBinder getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (instance != null) return instance;
        Class<CCJniApiBinder> clazz = CCJniApiBinder.class;
        synchronized (CCJniApiBinder.class) {
            if (instance != null) return instance;
            instance = new CCJniApiBinder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private CCJniApiBinder(Context context) {
        super(context);
        this.context = context;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SIM_STATE_CHANGED");
        this.context.registerReceiver(this.receiver, filter);
    }

    @Override
    protected JNIAPI getApi() {
        return this.getCCJniApi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CCJniApi getCCJniApi() {
        if (this.ccJniApi != null) return this.ccJniApi;
        Class<CCJniApiBinder> clazz = CCJniApiBinder.class;
        synchronized (CCJniApiBinder.class) {
            if (this.ccJniApi != null) return this.ccJniApi;
            this.ccJniApi = new CCJniApi(this.context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ccJniApi;
        }
    }

    @Override
    public JniApiParam getJniApiParam() {
        int ret = CCHandleInit.getInstance(this.context).openCard(this.getCCJniApi());
        if (ret != 0) {
            return null;
        }
        return super.getJniApiParam();
    }

    @Override
    protected int selfOpenDev() throws RemoteException {
        int ret;
        this.devInfo = null;
        if (this.canUse() && (ret = CCHandleInit.getInstance(this.context).openCard(this.getCCJniApi())) == 0) {
            XDJA_DEVINFO ccDevInfo = CCHandleInit.getInstance((Context)this.context).mDevInfo;
            if (!Arrays.equals(this.lastDevInfo.cardid, ccDevInfo.cardid)) {
                this.lastDevInfo.cardid = Arrays.copyOf(ccDevInfo.cardid, ccDevInfo.cardid.length);
                this.lastDevInfo.cardtype = ccDevInfo.cardtype;
                this.lastDevInfo.cosver = Arrays.copyOf(ccDevInfo.cosver, ccDevInfo.cosver.length);
                this.lastDevInfo.reserve = ccDevInfo.reserve;
                this.devInfo = this.lastDevInfo;
                this.notifyListenerChange();
            }
        }
        return 0;
    }

    @Override
    protected boolean isDevOnline(int errcode) throws RemoteException {
        if (errcode == -100) {
            this.selfOpenDev();
            if (this.getApi().GetDevInfo(0L, new XDJA_DEVINFO()) == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected int getChipType() {
        return 8;
    }

    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey("method")) {
            String method = bundle.getString("method");
            if ("UnlockPinUseUsn".equals(method)) {
                return this.UnlockPinUseUsn(bundle);
            }
            if ("SM4".equals(method)) {
                return this.SM4(bundle);
            }
            if ("SetCardChangeListener".equals(method)) {
                return this.setCardChangeListener(bundle);
            }
        }
        return null;
    }

    private Bundle SM4(Bundle bundle) {
        Bundle result = new Bundle();
        byte[] dataIn = bundle.getByteArray("dataIn");
        int dataLen = bundle.getInt("dataLen");
        int flag = bundle.getInt("flag");
        byte kID = bundle.getByte("kID");
        byte[] IV = bundle.getByteArray("IV");
        byte[] dataOut = new byte[dataLen];
        int[] outLen = new int[2];
        int ret = this.getCCJniApi().SM4(dataIn, dataLen, flag, dataOut, outLen, kID, IV);
        try {
            if (this.isDevOnline(ret)) {
                ret = this.getCCJniApi().SM4(dataIn, dataLen, flag, dataOut, outLen, kID, IV);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            ret = -10001;
        }
        result.putInt("ret", ret);
        result.putByteArray("dataOut", dataOut);
        result.putByteArray("IV", IV);
        return result;
    }

    private Bundle setCardChangeListener(Bundle bundle) {
        Bundle result = new Bundle();
        IBinder binder = bundle.getBinder("Binder");
        if (binder != null) {
            Messenger messenger = new Messenger(binder);
            this.messengerList.add(messenger);
        }
        return result;
    }

    boolean canUse() {
        if (this.flag.booleanValue()) {
            this.flag = false;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SystemClock.sleep((long)2000L);
                    CCJniApiBinder.this.flag = true;
                }
            }).start();
            return true;
        }
        return false;
    }

    private void notifyListenerChange() {
        for (Messenger messenger : this.messengerList) {
            if (messenger.getBinder().isBinderAlive()) {
                Message msg = new Message();
                msg.what = 1;
                msg.obj = this.lastDevInfo;
                try {
                    messenger.send(msg);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.messengerList.remove(messenger);
        }
    }

    private void handleSimAbsent() {
        try {
            this.devInfo = null;
            this.getCCJniApi().getTMCAPI().CloseSEService();
            Log.w((String)TAG, (String)"Sim state change to absent!Process exit!");
            this.exitProcess();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exitProcess() {
        Intent intent = new Intent(this.context, CCProcessService.class);
        this.context.stopService(intent);
        Process.killProcess((int)Process.myPid());
        System.exit(0);
    }

    @TargetApi(value=22)
    class SimChangeDefaultOnlineListener
    extends SubscriptionManager.OnSubscriptionsChangedListener {
        public void onSubscriptionsChanged() {
            Log.w((String)CCJniApiBinder.TAG, (String)"Sim Change Default Online!Process exit!");
            super.onSubscriptionsChanged();
            CCJniApiBinder.this.exitProcess();
        }
    }
}

