package com.xdja.multichip.process.tfcard;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import java.util.ArrayList;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/17 <br/>
 */

public class TFProcessProvider extends ContentProvider {
    @Override
    public boolean onCreate() {
        Intent intent = new Intent();
        intent.setClass(getContext(), TFProcessService.class);
        getContext().startService(intent);
        return false;
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }


    @Nullable
    @Override
    public Bundle call(@NonNull String method, @Nullable String arg, @Nullable Bundle extras) {
        Log.v("testTag", TFProcessProvider.class.getName() + "   call " + method);
        Bundle bundle = new Bundle();
        if ("GetChipBinder".equals(method)) {
            synchronized (TFProcessProvider.class) {
                ArrayList<Bundle> list;
                list = TFHandle.getInstance().getCurrentTFCardInfo(getContext());
                bundle.putInt("ret", 0);
                bundle.putParcelableArrayList("result", list);
                return bundle;
            }
        } else if ("GetJniApiBinder".equals(method)) {
            synchronized (TFProcessProvider.class) {
                ArrayList<Bundle> list = TFJniApiHandle.getInstance().getCurrentTFCardInfo(getContext());
                bundle.putInt("ret", 0);
                bundle.putParcelableArrayList("result", list);
                return bundle;
            }
        }
        return super.call(method, arg, extras);
    }

}
