/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.tfcard;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.multichip.process.tfcard.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TFCardUtils {
    private static String tag = "TFCardUtils";

    public static List<String> getAllExternalSdCardPath() {
        ArrayList<String> externalSdCardPaths = new ArrayList<String>();
        externalSdCardPaths.add(TFCardUtils.getNormalSDCardPath());
        return externalSdCardPaths;
    }

    public static String getExternalSdCardPath() {
        String path = null;
        File sdCardFile = null;
        ArrayList<String> devMountList = TFCardUtils.getDevMountList();
        for (String devMount : devMountList) {
            File file = new File(devMount);
            if (!file.isDirectory() || !file.canWrite()) continue;
            path = file.getAbsolutePath();
            String timeStamp = new SimpleDateFormat("ddMMyyyy_HHmmss").format(new Date());
            File testWritable = new File(path, "test_" + timeStamp);
            if (testWritable.mkdirs()) {
                testWritable.delete();
                continue;
            }
            path = null;
        }
        if (path != null) {
            sdCardFile = new File(path);
            return sdCardFile.getAbsolutePath();
        }
        return null;
    }

    private static ArrayList<String> getDevMountList() {
        String[] toSearch = FileUtil.readFile("/system/etc/vold.fstab").split(" ");
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < toSearch.length; ++i) {
            if (!toSearch[i].contains("dev_mount") || !new File(toSearch[i + 2]).exists()) continue;
            out.add(toSearch[i + 2]);
        }
        return out;
    }

    public static String getNormalSDCardPath() {
        return Environment.getExternalStorageDirectory().getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSDCardPath() {
        String cmd = "cat /proc/mounts";
        Runtime run = Runtime.getRuntime();
        BufferedInputStream in = null;
        BufferedReader inBr = null;
        try {
            String lineStr;
            Process p = run.exec(cmd);
            in = new BufferedInputStream(p.getInputStream());
            inBr = new BufferedReader(new InputStreamReader(in));
            while ((lineStr = inBr.readLine()) != null) {
                String[] strArray;
                Log.i((String)tag, (String)lineStr);
                if (lineStr.contains("sdcard") && lineStr.contains(".android_secure") && (strArray = lineStr.split(" ")) != null && strArray.length >= 5) {
                    String result;
                    String string = result = strArray[1].replace("/.android_secure", "");
                    return string;
                }
                if (p.waitFor() == 0 || p.exitValue() != 1) continue;
                Log.e((String)tag, (String)"\u547d\u4ee4\u6267\u884c\u5931\u8d25!");
            }
        }
        catch (Exception e) {
            Log.e((String)tag, (String)e.toString());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inBr != null) {
                    inBr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "not find sdcard path";
    }

    public static String getPath2() {
        String sdcard_path = null;
        String sd_default = Environment.getExternalStorageDirectory().getAbsolutePath();
        Log.d((String)"text", (String)sd_default);
        if (sd_default.endsWith("/")) {
            sd_default = sd_default.substring(0, sd_default.length() - 1);
        }
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec("mount");
            InputStream is = proc.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                String[] columns;
                if (line.contains("secure") || line.contains("asec")) continue;
                if (line.contains("fat") && line.contains("/mnt/")) {
                    columns = line.split(" ");
                    if (columns == null || columns.length <= 1 || sd_default.trim().equals(columns[1].trim())) continue;
                    sdcard_path = columns[1];
                    continue;
                }
                if (!line.contains("fuse") || !line.contains("/mnt/") || (columns = line.split(" ")) == null || columns.length <= 1 || sd_default.trim().equals(columns[1].trim())) continue;
                sdcard_path = columns[1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sdcard_path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSuspicionSDCardPath(Context context) {
        ArrayList<String> suspicionPaths = new ArrayList<String>();
        context.getExternalFilesDir(null);
        String cmd = "cat /proc/mounts";
        Runtime run = Runtime.getRuntime();
        BufferedInputStream in = null;
        BufferedReader inBr = null;
        try {
            String lineStr;
            Process p = run.exec(cmd);
            in = new BufferedInputStream(p.getInputStream());
            inBr = new BufferedReader(new InputStreamReader(in));
            while ((lineStr = inBr.readLine()) != null) {
                String path;
                String[] strArray;
                if (!TextUtils.isEmpty((CharSequence)lineStr) && (strArray = lineStr.split(" ")) != null && strArray.length >= 5 && TFCardUtils.isBackupPathByQuery(context, path = strArray[1])) {
                    Log.i((String)tag, (String)path);
                    suspicionPaths.add(path);
                }
                if (p.waitFor() == 0 || p.exitValue() != 1) continue;
                Log.e((String)tag, (String)"\u547d\u4ee4\u6267\u884c\u5931\u8d25!");
            }
        }
        catch (Exception e) {
            Log.e((String)tag, (String)e.toString());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inBr != null) {
                    inBr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return suspicionPaths;
    }

    private static boolean isBackupPathByQuery(Context context, String sdPath) {
        if (TextUtils.isEmpty((CharSequence)sdPath)) {
            return false;
        }
        String targetDirectorFilePath = sdPath + "/Android/data/" + context.getPackageName();
        File targetDirectorFile = new File(targetDirectorFilePath);
        targetDirectorFile.mkdirs();
        return targetDirectorFile.exists();
    }

    private static boolean isBackupPathByCreateFile(Context context, String sdPath) {
        if (TextUtils.isEmpty((CharSequence)sdPath)) {
            return false;
        }
        String targetDirectorFilePath = sdPath + "/Android/data/" + context.getPackageName() + "/test.log";
        File targetDirectorFile = new File(targetDirectorFilePath);
        boolean res = false;
        try {
            targetDirectorFile.createNewFile();
            res = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }
}

