package com.xdja.multichip.process.coveredcard;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;

import com.xdja.multichip.param.ParamKeywords;

import java.util.ArrayList;

/**
 * Created by xwy on 2017/9/14.
 */

public class CCProcessProvider extends ContentProvider {
    @Override
    public boolean onCreate() {
        Intent intent = new Intent();
        intent.setClass(getContext(), CCProcessService.class);
        getContext().startService(intent);
        return false;
    }


    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        Bundle bundle = new Bundle();
        if ("GetJniApiBinder".equals(method)) {
            increaseFlag();
            synchronized (CCProcessProvider.class) {
                ArrayList<Bundle> list = CCJniApiHandle.getInstance().getCurrentCoveredCardInfo(
                        getContext());
                bundle.putInt(ParamKeywords.KEY_int_ret, 0);
                bundle.putParcelableArrayList(ParamKeywords.KEY_Parcelable_JniApiParam, list);
            }
            decreaseFlag();
            return bundle;
        }
        return super.call(method, arg, extras);
    }


    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }


    @Override
    public String getType(Uri uri) {
        return null;
    }


    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    /**
     * add by zhangxiaolong 2018-10-16 10:53:22
     * 主要用于解决主进程provider调用贴膜卡进程provider时，
     * 贴膜卡进程直接exit会影响到主进程。
     */
    private static int callingFlag = 0;

    private static void increaseFlag() {
        synchronized (CCProcessProvider.class) {
            ++callingFlag;
        }
    }

    private static void decreaseFlag() {
        synchronized (CCProcessProvider.class) {
            --callingFlag;
        }
    }

    public static int getCallingFlag() {
        return callingFlag;
    }
}
