package com.xdja.multichip.process.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperChipForCall;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/12/27 <br/>
 */
@AutoChipForCall
public class BluetoothKeyChipForCall extends SuperChipForCall {

    public static final String NAME_PROCESS_BLUETOOTH = "bluekey";

    @Override
    protected Class getProviderClass() {
        return BluetoothKeyProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_BLUETOOTH;
    }

    @Override
    public boolean isCanUse() {

        regeditBluetoothListener();
        //start : update by xwy on 2017-9-12 14:21:56
        //解决中兴有一个手机上 java.lang.SecurityException: Need BLUETOOTH permission:的问题
        //如果出现异常直接返回一个空的结果。
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            int state = adapter.getState();
            if (state == BluetoothAdapter.STATE_OFF || state == BluetoothAdapter.STATE_TURNING_OFF) {
                return false;
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return false;
    }

    @Override
    public int getChipType() {
        return JniApiParam.TYPE_BLUETOOTH;
    }

    @Override
    public void setContext(Context context) {
        super.context = context;
    }

    /**
     * 蓝牙状态监听标志位;
     * 0：表示还没有开启监听；
     * 其他：已开启
     */
    private static int bluetoothFlag = 0;

    private synchronized void regeditBluetoothListener() {
        if (bluetoothFlag != 0) {
            return;
        }
        bluetoothFlag = 1;
        IntentFilter filter = new IntentFilter();
        filter.addAction(BluetoothAdapter.ACTION_STATE_CHANGED);
        context.registerReceiver(bluetoothReceiver, filter);
    }

    /**
     * 蓝牙监听广播
     */
    private static BroadcastReceiver bluetoothReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            int blueState = intent.getIntExtra(BluetoothAdapter.EXTRA_STATE, 0);
            if (BluetoothAdapter.STATE_OFF == blueState) {
                Intent stopIntent = new Intent();
                stopIntent.setClassName(context.getPackageName(), BluetoothKeyProcessService.class.getName());
                context.stopService(stopIntent);
            }
        }
    };
}
