package com.xdja.multichip.process.board;

import android.content.Context;
import android.os.Build;

import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperChipForCall;

import java.util.ArrayList;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/12/27 <br/>
 */
@AutoChipForCall
public class OnboardChipForCall extends SuperChipForCall {

    public static final String TAG = "BoardChipForCallTag";

    public static final String NAME_PROCESS_ONBOARD = "onboardchip";
    private Context context;


    @Override
    protected Class getProviderClass() {
        return OnboardProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_ONBOARD;
    }

    @Override
    public boolean isCanUse() {
        boolean flag = checkCurDevIsKownHasChip();
        return flag;
    }

    @Override
    public int getChipType() {
        return JniApiParam.TYPE_ONBOARD;
    }

    @Override
    public void setContext(Context context) {
        super.context = context;
    }

    /**
     * 判断当前设备是否含有芯片
     *
     * @return 返回false表示手机肯定不含芯片
     */
    private boolean checkCurDevIsKownHasChip() {
        boolean flag = true;
        String model = Build.MODEL;
        if (noHasBroadChipList.contains(model)) {
            flag = false;
        }
        return flag;
    }

    /**
     * 不含芯片手机的list
     */
    private static ArrayList<String> noHasBroadChipList = new ArrayList<>();

    static {

    }

}
