package com.xdja.multichip.process.coveredcard;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.tmc.TMCAPI;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/10/18 <br/>
 */

public class CCHandleInit {
    private static final String TAG = "CCHandleIntTag";

    private Context context;
    XDJA_DEVINFO mDevInfo = new XDJA_DEVINFO();

    private CCHandleInit(Context context) {
        this.context = context;
    }

    private static CCHandleInit instance;

    public static CCHandleInit getInstance(Context context) {
        if (context == null) {
            throw new NullPointerException("Context is null!");
        }
        if (instance == null) {
            synchronized (CCHandleInit.class) {
                if (instance == null) {
                    instance = new CCHandleInit(context);
                }
            }
        }
        return instance;
    }

    private CCJniApi ccJniApi;

    /**
     * 打开贴膜卡。
     * <p>
     * <br/>
     * 修改为通过Service中调用贴膜卡接口，使用贴膜卡接口回调方法判断是否初始化成功
     *
     * @param jniApi
     * @return 0:成功；其他：失败
     */
    public synchronized int openCard(CCJniApi jniApi) {
        Log.e(TAG, "=================== openCard ");
        //判断sim是否为ready状态（状态码5），如果不是，则初始化返回失败
        if (judgeSimIsReady() != 0) {
            return -1;
        }

        if (jniApi == null) {
            Log.e(TAG, "=================== jniApi null ");
            return -2;
        }

        ccJniApi = jniApi;
        final boolean[] isSupportedFlag = new boolean[1];
        isSupportedFlag[0] = false;

        final CountDownLatch latch = new CountDownLatch(1);

        Messenger messenger = new Messenger(new Handler(Looper.getMainLooper()) {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                isSupportedFlag[0] = (boolean) msg.obj;
                latch.countDown();
                Log.w(TAG, "cc init handleMessage " + isSupportedFlag[0]);
            }
        });

        Intent intent = new Intent();
        intent.putExtra(KEY_PARAM, VALUE_OPENCC);
        intent.setClass(context, CCProcessService.class);
        Bundle bundle = new Bundle();
        bundle.putBinder(KEY_MESSENGER, messenger.getBinder());
        intent.putExtra(KEY_BUNDLE, bundle);
        intent.putExtra("startTime", System.currentTimeMillis());
        context.startService(intent);

        try {
            latch.await(3500, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        /*XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        int ret = jniApi.getTMCAPI().GetDevInfo(devinfo);
        Log.e(TAG,"ret = " + ret + " cardid = " + new String(devinfo.cardid));*/
        if (isSupportedFlag[0]) {
            return 0;
        } else {
            return -1;
        }
    }


    public static final String KEY_PARAM = "param";
    public static final String KEY_BUNDLE = "Bundle";
    public static final String KEY_MESSENGER = "Messenger";
    public static final String VALUE_OPENCC = "openCC";

    /**
     * 打开贴膜卡
     */
    public void openCC(final Context context, final Intent intent) {
        try {
            final Messenger messenger = new Messenger(intent.getBundleExtra(KEY_BUNDLE).getBinder(KEY_MESSENGER));

            if (ccJniApi != null) {
                //add by zhangxiaolong 2019-5-21 start
                //原因：尝试解决贴膜卡在某些手机上每次打开卡都是超过4秒的情况
                try {
                    int len = 8;
                    byte[] random = new byte[len];
                    byte[] tmp = new byte[len];
                    Arrays.fill(tmp,(byte)0);
                    int ret = ccJniApi.getTMCAPI().GenRandom(len, random);
                    if (ret == 0 && !Arrays.equals(tmp,random)){
                        Message msg = Message.obtain();
                        try {
                            msg.obj = true;
                            messenger.send(msg);
                        } catch (RemoteException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                //add by zhangxiaolong 2019-5-21 end
                ccJniApi.getTMCAPI().CloseSEService();
            }

            Log.w(TAG, "OpenSEService OpenSEService before");

            //modify 2018年2月22日14:57:59 weizg v1.7版本的贴膜卡需要read_phone_state权限，否则会崩溃
            //所有把下面open方法放入到try块中

            //如果当前ccJniApi实例为null
            if (this.ccJniApi == null) {
                Message msg = Message.obtain();
                try {
                    msg.obj = false;
                    messenger.send(msg);
                } catch (RemoteException e) {
                    e.printStackTrace();
                }
                return;
            }

            this.ccJniApi.getTMCAPI().OpenSEService(context, new TMCAPI.TMCAPICallBack() {
                @Override
                public void isSupported(boolean b) {
                    Message msg = Message.obtain();
                    try {
                        msg.obj = b;
                        messenger.send(msg);
                    } catch (RemoteException e) {
                        e.printStackTrace();
                    }
                    if (b) {
                        String otiType = CCHandleInit.this.ccJniApi.getTMCAPI().GetOtiType();
                        Log.w(TAG, "OpenSEService is supported " + b + " otiType: " + otiType);
                        long startTime = intent.getLongExtra("startTime", -1);
                        long nowTime = System.currentTimeMillis();
                        Log.e("testCC","startTime = " + startTime + "  nowTime = " + nowTime);
                        if (startTime != -1 && (nowTime - startTime > 3500)) {
                            XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
                            int ret = CCHandleInit.this.ccJniApi.getTMCAPI().GetDevInfo(devInfo);
                            Log.e("testCC","ret = " + ret );
                            if (ret == 0) {
                                String cardId = new String(devInfo.cardid).trim();
                                Log.e("testCC","cardId = " + cardId );
                                JarMultiChipStatusManager.getInstance().sendCardStatus(context, cardId, JniApiParam.TYPE_COVERED, 1);
                            }
                        }
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 判断SIM卡，是否已经ready。
     *
     * @return 0:已经ready；其他：没有
     */
    private int judgeSimIsReady() {
        TelephonyManager tm = (TelephonyManager) context.getSystemService(Service.TELEPHONY_SERVICE);
        int state = tm.getSimState();
        Log.e(TAG, "=================== simState = " + state);
        if (state == TelephonyManager.SIM_STATE_READY) {
            return 0;
        } else {
            return -1;
        }
    }
}
