package com.xdja.multichip.process.tfcard;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperJniApiBinder;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/14 <br/>
 */

public class TFJniApiBinder extends SuperJniApiBinder {

    private final String tf_oper_path_part1 = "/Android/data/";
    private final String tf_oper_path_part2 = "/files/";

    private Context context;
    //tf卡路径
    private String tfcardOperFullPath;
    //add 2017年7月18日13:35:10 weizg 新增tf根目录变量
    //原因是，在HTC m8上，tf卡手机，已经root，可以通过打开根目录的cmd.bin打开tf卡；
    //另外，据介绍，如果TF卡可以通过根目录，私有目录两种方式都打开设备，但一种方式打开后，另外
    //一种方式就无法打开。
    private String tfcardPath;

    private JNIAPI jniapi = new JNIAPI();

    public TFJniApiBinder(Context context, String tfcardPath) {
        super(context);
        this.context = context;
        this.tfcardOperFullPath = getTFOperFullPath(tfcardPath);
        this.tfcardPath = tfcardPath;
    }

    private String getTFOperFullPath(String tfcardPath) {
        //例如：/storage/sdcard1/Android/data/com.xdja.safekeyservice/files
        return tfcardPath + tf_oper_path_part1 + context.getPackageName() + tf_oper_path_part2;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) throws RemoteException {
        int ret = getApi().OpenDevByName(devName, hHandle);
        if (ret == 0) {
            mHandle = hHandle[0];
        }
        return ret;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) throws RemoteException {
        int ret = getApi().OpenDevByNameEx(packagePath, hHandle);
        if (ret == 0) {
            mHandle = hHandle[0];
        }
        return ret;
    }

    @Override
    protected JNIAPI getApi() {
        return jniapi;
    }

    /**
     * 用于打开设备
     */
    @Override
    protected int selfOpenDev() throws RemoteException {
        int ret;
        long[] devHandle = new long[1];

        devInfo = null;
        mHandle = 0;
        mContext.getExternalFilesDir(null);
        //因为存在TF卡可以通过根目录/cmd.bin和私有目录/cmd.bin都能打开的情况，同时统一一种方式打开后，
        //另外一种方式就无法打开卡，但同一种方式可以两个进程同时打开，所以此处尝试两种方式打开卡
        ret = jniapi.OpenDevByNameEx(context.getPackageName().getBytes(), devHandle);
        if (ret != 0) {
            //如果打开不成功，则尝试另外一种方式
            String tfPathTmp = tfcardPath;
            if (!tfPathTmp.endsWith("/")) {
                tfPathTmp = tfcardPath + "/";
            }
            ret = jniapi.OpenDevByName(tfPathTmp.getBytes(), devHandle);
        }
        if (ret == JNIAPI.XKR_OK) {
            mHandle = devHandle[0];
        }
        return ret;
    }

    /**
     * 得到芯片类型，参看：{@link JniApiParam#TYPE_ONBOARD}, {@link JniApiParam#TYPE_TF}, {@link JniApiParam#TYPE_BLUETOOTH}
     *
     * @return
     */
    @Override
    protected int getChipType() {
        return JniApiParam.TYPE_TF;
    }


    @Override
    public JniApiParam getJniApiParam() {
        return super.getJniApiParam();
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        return super.callMethod(bundle);
    }
}
