package com.xdja.multichip.utils;

/**
 * 转换工具类，提供 byte short int long Sring之间的相互转换
 * author: zhangxiaolong@xdja.com
 * date:   2016/1/20
 */
public class ConvertUtil {

    public final static int LEN_SHORT = 2;
    public final static int LEN_CHAR = 2;
    public final static int LEN_INT = 4;
    public final static int LEN_LONG = 8;

    /**
     * short 转成 byte[]
     *
     * @param number
     * @return 两位的字节数组
     */
    public static byte[] shortToBytes(short number) {
        int temp = number;
        byte[] b = new byte[2];
        for (int i = 0; i < b.length; i++) {
            b[i] = new Integer(temp & 0xff).byteValue();// 将最低位保存在最低位
            temp = temp >> 8; // 向右移8位
        }
        return b;
    }

    /**
     * byte[] 转成 short<br>
     * byte[]为两个byte
     *
     * @param b
     * @return
     */
    public static short bytesToShort(byte[] b) {
        short s = 0;
        short s0 = (short) (b[0] & 0xff);// 最低位
        short s1 = (short) (b[1] & 0xff);
        s1 <<= 8;
        s = (short) (s0 | s1);
        return s;
    }

    /**
     * char 转换成 byte[]
     *
     * @param c
     * @return
     */
    public static byte[] charToBytes(char c) {
        byte[] b = new byte[2];
        b[0] = (byte) ((c & 0xFF00) >> 8);
        b[1] = (byte) (c & 0xFF);
        return b;
    }

    /**
     * byte[] 转换成 char<br>
     * byte[]为两个byte
     *
     * @param b
     * @return
     */
    public static char bytesToChar(byte[] b) {
        char c = (char) (((b[0] & 0xFF) << 8) | (b[1] & 0xFF));
        return c;
    }

    /**
     * int 转成 byte[]
     *
     * @param i
     * @return 四个byte 的 数组
     */
    public static byte[] intToBytes(int i) {
        byte[] bt = new byte[4];
        bt[0] = (byte) (0xff & i);
        bt[1] = (byte) ((0xff00 & i) >> 8);
        bt[2] = (byte) ((0xff0000 & i) >> 16);
        bt[3] = (byte) ((0xff000000 & i) >> 24);
        return bt;
    }

    /**
     * byte[] 转成 int<br>
     * byte[]为4个byte
     *
     * @param bytes
     * @return 整型
     */
    public static int bytesToInt(byte[] bytes) {
        int num = bytes[0] & 0xFF;
        num |= ((bytes[1] << 8) & 0xFF00);
        num |= ((bytes[2] << 16) & 0xFF0000);
        num |= ((bytes[3] << 24) & 0xFF000000);
        return num;
    }

    /**
     * long 转成 byte[]
     *
     * @param number
     * @return 8个byte的数组
     */
    public static byte[] longToBytes(long number) {
        long temp = number;
        byte[] b = new byte[8];
        for (int i = 0; i < b.length; i++) {
            b[i] = new Long(temp & 0xff).byteValue();
            // 将最低位保存在最低位
            temp = temp >> 8;
            // 向右移8位
        }
        return b;
    }

    /**
     * byte[] 转成 long<br>
     * byte[]为8个byte
     *
     * @param b
     * @return 长整型
     */
    public static long bytesToLong(byte[] b) {
        long s = 0;
        long s0 = b[0] & 0xff;// 最低位
        long s1 = b[1] & 0xff;
        long s2 = b[2] & 0xff;
        long s3 = b[3] & 0xff;
        long s4 = b[4] & 0xff;// 最低位
        long s5 = b[5] & 0xff;
        long s6 = b[6] & 0xff;
        long s7 = b[7] & 0xff; // s0不变
        s1 <<= 8;
        s2 <<= 16;
        s3 <<= 24;
        s4 <<= 8 * 4;
        s5 <<= 8 * 5;
        s6 <<= 8 * 6;
        s7 <<= 8 * 7;
        s = s0 | s1 | s2 | s3 | s4 | s5 | s6 | s7;
        return s;
    }

    /**
     * 得到 数组 src 中的部分数据
     *
     * @param src
     * @param begin
     * @param len
     * @return
     */
    public static byte[] subBytes(byte[] src, int begin, int len) {
        byte[] bs = new byte[len];
        for (int i = begin; i < begin + len; i++) {
            bs[i - begin] = src[i];
        }
        return bs;
    }

    /**
     * 将字符数组转成16进制字符串0xff
     * <br><b>注意，该方法转换后16进制字符串，必须用<code>getBytesFromString_EvenNumHexStr<code/>才能反向转换<b/><br/>
     *
     * @param data 数据
     * @return 16进制字符串
     */
    public static String getStringFromBytes(byte data[]) {
        if (data == null) {
            return "";
        }

        StringBuffer sb = new StringBuffer();
        for (byte aData : data) {
            sb.append(String.format("%02x", aData));
        }
        return sb.toString();
    }

    /**
     * Convert hex string to byte[]
     * <b><br>hexstring字符串个数必须为偶数<br/></b>
     *
     * @param hexString the hex string
     * @return byte[]
     */
    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; i++) {
            int pos = i * 2;
            d[i] = (byte) (charToByte(hexChars[pos]) << 4 | charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    /**
     * Convert char to byte
     *
     * @param c char
     * @return byte
     */
    private static byte charToByte(char c) {
        return (byte) "0123456789ABCDEF".indexOf(c);
    }

}
