package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;

import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.bluetooth.JniApiBluetoothKey;

import java.util.ArrayList;

/**
 * Created by xwy on 2017/9/14.
 */

public class CCJniApiHandle {

    private static final String tag = "XdjaCCBinder";


    private static CCJniApiHandle instance;


    public static CCJniApiHandle getInstance() {
        if (instance == null) {
            synchronized (CCJniApiHandle.class) {
                if (instance == null) {
                    instance = new CCJniApiHandle();
                }
            }
        }
        return instance;
    }

    protected ArrayList<Bundle> getCurrentCoveredCardInfo(Context context) {

        ArrayList<Bundle> list = new ArrayList<>();

        if (context == null){
            return list;
        }

        CCJniApiBinder binder = CCJniApiBinder.getInstance(context);
        if (binder == null) {
            return list;
        }

        //add 首先通过接口获取设备信息，如果能获取到就不再进行设备打开
        JniApiParam param = null;

        CCJniApi ccJniApi = (CCJniApi) binder.getApi();

        if(ccJniApi != null){
            XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
            int ret = ccJniApi.GetDevInfoPri(-1, devinfo);
            if (ret == 0) {
                param = new JniApiParam();
                param.chipType = binder.getChipType();
                param.cardId = new String(devinfo.cardid).trim();
            }else {
                param = binder.getJniApiParam();
            }
        }else {
            param = binder.getJniApiParam();
        }



//        JniApiParam param = binder.getJniApiParam();
        if (param != null) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(context,param.cardId,param.chipType,1);
            Bundle bundle = new Bundle();
            bundle.putBinder(ParamKeywords.KEY_Binder_Binder, binder);
            bundle.putParcelable(ParamKeywords.KEY_Parcelable_JniApiParam, param);
            list.add(bundle);
        }
        return list;
    }
}
