/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.anno.AutoWriteList;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.IChipForCall;
import com.xdja.multichip.process.bluetooth.BluetoothKeyChipForCall;
import com.xdja.multichip.process.board.OnboardChipForCall;
import com.xdja.multichip.process.coveredcard.CCChipForCall;
import com.xdja.multichip.process.tfcard.TFChipForCall;
import com.xdja.multichip.process.vhsm.VhsmChipForCall;
import com.xdja.multichip.process.vhsm.net.NetVhsmChipForCall;
import com.xdja.multichip.utils.SharedPreferencesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class GetMultiJniApiBinder
extends IGetMultiJniApi.Stub {
    private static final String TAG = "GetMultiJniApiBinder";
    private static final int WAIT_TIMEOUT = 10;
    private static GetMultiJniApiBinder instance;
    private Context context;
    private ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    private long lastCall = 0L;
    @AutoWriteList
    private ArrayList<IChipForCall> chipForCallList = new ArrayList();
    List<Bundle> lastRusult = new ArrayList<Bundle>();
    private ActivityInfo[] activities;
    private ProviderInfo[] providers;
    private ActivityInfo[] receivers;
    private ServiceInfo[] services;
    private HashMap<String, List<String>> processClassMap = new HashMap(5);

    private GetMultiJniApiBinder(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        this.init(this.context);
    }

    private void init(Context context) {
        this.chipForCallList.clear();
        this.chipForCallList.add(new OnboardChipForCall());
        this.chipForCallList.add(new TFChipForCall());
        this.chipForCallList.add(new BluetoothKeyChipForCall());
        this.chipForCallList.add(new CCChipForCall());
        this.chipForCallList.add(new NetVhsmChipForCall());
        for (IChipForCall chipForCall : this.chipForCallList) {
            chipForCall.setContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GetMultiJniApiBinder getInstance(Context context) {
        if (instance != null) return instance;
        Class<GetMultiJniApiBinder> clazz = GetMultiJniApiBinder.class;
        synchronized (GetMultiJniApiBinder.class) {
            if (instance != null) return instance;
            instance = new GetMultiJniApiBinder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        String pkgName = this.context.getPackageName();
        ArrayList<String> list = new ArrayList<String>();
        list.add("com.xdja.safekeyservice");
        list.add("com.xdja.safeclient");
        list.add("com.xdja.uaac");
        list.add("com.ssl");
        if (!list.contains(pkgName)) {
            return false;
        }
        return super.onTransact(code, data, reply, flags);
    }

    public synchronized List<Bundle> getMultiJniApi() throws RemoteException {
        Log.w((String)TAG, (String)"getMultiJniApi start: ");
        long curCall = SystemClock.elapsedRealtime();
        if (curCall - this.lastCall < 1000L) {
            return this.lastRusult;
        }
        this.lastRusult.clear();
        ArrayList<IChipForCall> list = new ArrayList<IChipForCall>();
        for (IChipForCall chipForCall : this.chipForCallList) {
            if (chipForCall.getChipName().equals("vhsm")) continue;
            list.add(chipForCall);
        }
        this.lastRusult.addAll(this.getJniApiBinder(list));
        this.lastCall = SystemClock.elapsedRealtime();
        Log.w((String)TAG, (String)" getMultiJniApi end: ");
        this.saveJniApiParam(this.lastRusult);
        return this.lastRusult;
    }

    private ArrayList<Bundle> getJniApiBinder(ArrayList<IChipForCall> chipForCallList) {
        final ArrayList<Bundle> rusultList = new ArrayList<Bundle>();
        final CountDownLatch latch = new CountDownLatch(chipForCallList.size());
        for (final IChipForCall chipForCall : chipForCallList) {
            this.cachedThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (!GetMultiJniApiBinder.this.judgeChipCanUse(chipForCall)) {
                            Log.e((String)GetMultiJniApiBinder.TAG, (String)("chipForCall: " + chipForCall.getChipName() + " false"));
                            return;
                        }
                        Log.e((String)GetMultiJniApiBinder.TAG, (String)("chipForCall: " + chipForCall.getChipName() + " true"));
                        List<Bundle> bundles = chipForCall.getJniApiBinder();
                        if (bundles == null) {
                            Log.e((String)GetMultiJniApiBinder.TAG, (String)("chipForCall: " + chipForCall.getChipName() + " bundles = null"));
                            return;
                        }
                        Log.e((String)GetMultiJniApiBinder.TAG, (String)("chipForCall: " + chipForCall.getChipName() + " bundles size:" + bundles.size()));
                        for (Bundle singleBundle : bundles) {
                            singleBundle.setClassLoader(JniApiParam.class.getClassLoader());
                            if (singleBundle.getParcelable("JniApiParam") == null) continue;
                            rusultList.add(singleBundle);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return rusultList;
    }

    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey("method")) {
            String method = bundle.getString("method");
            if ("makeByType".equals(method)) {
                return this.makeByType(bundle);
            }
            if ("setProvideCard".equals(method)) {
                return this.setSingleChipCanUse(bundle);
            }
            if ("getProvideCardFlag".equals(method)) {
                return this.getSingleChipCanUseFlag(bundle);
            }
            if ("CreateDefaultVhsm".equals(method)) {
                VhsmChipForCall forCall = new VhsmChipForCall();
                forCall.setContext(this.context);
                Bundle vhsm = forCall.createDefaultVhsm();
                vhsm.setClassLoader(JniApiParam.class.getClassLoader());
                if (vhsm != null) {
                    ArrayList<Bundle> list = new ArrayList<Bundle>();
                    list.add(vhsm);
                    this.saveJniApiParam(list);
                }
                return vhsm;
            }
        }
        Bundle result = new Bundle();
        result.putInt("ret", -10027);
        return result;
    }

    private Bundle makeByType(Bundle callBundle) {
        Bundle result = new Bundle();
        int cardType = callBundle.getInt("cardType");
        IChipForCall chipForCall = this.findChipForCallByCardType(cardType);
        ArrayList<Bundle> resultList = new ArrayList();
        if (chipForCall != null) {
            ArrayList<IChipForCall> list = new ArrayList<IChipForCall>();
            list.add(chipForCall);
            resultList = this.getJniApiBinder(list);
            this.saveJniApiParam(resultList);
        }
        result.putInt("ret", 0);
        result.putParcelableArrayList("BundleList", resultList);
        return result;
    }

    private IChipForCall findChipForCallByCardType(int cardType) {
        if (this.chipForCallList == null) {
            return null;
        }
        for (IChipForCall chipForCall : this.chipForCallList) {
            if (chipForCall.getChipType() != cardType) continue;
            return chipForCall;
        }
        return null;
    }

    private synchronized Bundle setSingleChipCanUse(Bundle bundle) {
        Bundle result = new Bundle();
        int uid = GetMultiJniApiBinder.getCallingUid();
        if (uid != Process.myUid()) {
            result.putInt("ret", -10028);
            return result;
        }
        String chipName = bundle.getString("chipName", "");
        String value = bundle.getString("value", "");
        if (TextUtils.isEmpty((CharSequence)chipName) || TextUtils.isEmpty((CharSequence)value)) {
            result.putInt("ret", -10000);
            return result;
        }
        MultiJniApiConfig.CanUseFlag flag = MultiJniApiConfig.CanUseFlag.enable.name().equals(value) ? MultiJniApiConfig.CanUseFlag.enable : (MultiJniApiConfig.CanUseFlag.unable.name().equals(value) ? MultiJniApiConfig.CanUseFlag.unable : MultiJniApiConfig.CanUseFlag.defaulted);
        MultiJniApiConfig.getInstance(this.context).setChipCanUseFlag(chipName, flag);
        this.setChipStatus(chipName, flag);
        result.putInt("ret", 0);
        return result;
    }

    private Bundle getSingleChipCanUseFlag(Bundle bundle) {
        Bundle result = new Bundle();
        int uid = GetMultiJniApiBinder.getCallingUid();
        if (uid != Process.myUid()) {
            result.putInt("ret", -10028);
            return result;
        }
        String chipName = bundle.getString("chipName", "");
        boolean flag = MultiJniApiConfig.getInstance(this.context).judgeChipCanUse(chipName);
        result.putInt("ret", 0);
        result.putBoolean("flag", flag);
        result.putString("chipName", chipName);
        return result;
    }

    private void saveJniApiParam(List<Bundle> list) {
        final ArrayList<Bundle> saveList = new ArrayList<Bundle>();
        saveList.addAll(list);
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (Bundle bundle : saveList) {
                    JniApiParam param = (JniApiParam)bundle.getParcelable("JniApiParam");
                    if (param == null) continue;
                    SharedPreferencesUtil.saveCardIdAndType(GetMultiJniApiBinder.this.context, param.cardId, param.chipType);
                }
            }
        });
    }

    private List<String> getClassInProcessList(String processName) {
        List<String> processClassList = this.processClassMap.get(processName);
        if (processClassList != null) {
            return processClassList;
        }
        List<String> classInProcessListBySearch = this.getClassInProcessListBySearch(processName);
        this.processClassMap.put(processName, classInProcessListBySearch);
        return classInProcessListBySearch;
    }

    private List<String> getClassInProcessListBySearch(String processName) {
        PackageManager pm = this.context.getPackageManager();
        ArrayList<String> result = new ArrayList<String>();
        try {
            PackageInfo pi;
            if (this.activities == null) {
                pi = pm.getPackageInfo(this.context.getPackageName(), 513);
                this.activities = pi.activities;
            }
            if (this.providers == null) {
                pi = pm.getPackageInfo(this.context.getPackageName(), 520);
                this.providers = pi.providers;
            }
            if (this.receivers == null) {
                pi = pm.getPackageInfo(this.context.getPackageName(), 514);
                this.receivers = pi.receivers;
            }
            if (this.services == null) {
                pi = pm.getPackageInfo(this.context.getPackageName(), 516);
                this.services = pi.services;
            }
            String pkgName = this.context.getPackageName();
            processName = pkgName + ":" + processName;
            if (this.providers != null) {
                for (ProviderInfo providerInfo : this.providers) {
                    if (!providerInfo.processName.equals(processName)) continue;
                    result.add(providerInfo.name);
                }
            }
            if (this.receivers != null) {
                for (ProviderInfo providerInfo : this.receivers) {
                    if (!providerInfo.processName.equals(processName)) continue;
                    result.add(providerInfo.name);
                }
            }
            if (this.activities != null) {
                for (ProviderInfo providerInfo : this.activities) {
                    if (!providerInfo.processName.equals(processName)) continue;
                    result.add(providerInfo.name);
                }
            }
            if (this.services != null) {
                for (ProviderInfo providerInfo : this.services) {
                    if (!providerInfo.processName.equals(processName)) continue;
                    result.add(providerInfo.name);
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void setChipStatus(String chipName, MultiJniApiConfig.CanUseFlag flag) {
        List<String> classInProcessList = this.getClassInProcessList(chipName);
        PackageManager pm = this.context.getPackageManager();
        int setFlag = 1;
        if (flag == MultiJniApiConfig.CanUseFlag.enable) {
            setFlag = 1;
        } else if (flag == MultiJniApiConfig.CanUseFlag.unable) {
            setFlag = 2;
        } else if (flag == MultiJniApiConfig.CanUseFlag.defaulted) {
            boolean b = MultiJniApiConfig.getInstance(this.context).judgeChipCanUseFromProperties(chipName);
            setFlag = b ? 1 : 2;
        }
        for (String process : classInProcessList) {
            ComponentName cn = new ComponentName(this.context, process);
            pm.setComponentEnabledSetting(cn, setFlag, 1);
        }
    }

    private boolean judgeChipCanUse(IChipForCall chipForCall) {
        boolean flag = MultiJniApiConfig.getInstance(this.context).judgeChipCanUse(chipForCall.getChipName());
        return flag;
    }

    private ArrayList<IChipForCall> getChipForCallList() {
        return this.chipForCallList;
    }
}

