/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.tfcard;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperThreadRun;
import com.xdja.multichip.process.tfcard.TFCardUtils;
import com.xdja.multichip.process.tfcard.TFJniApiBinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class TFJniApiHandle
extends SuperThreadRun<ArrayList<Bundle>> {
    public static final String action_tf_mounted = "com_xdja_safekeyservice_tf_mounted";
    public static final String action_tf_removed = "com_xdja_safekeyservice_tf_removed";
    public static final String tag_currrent_tf = "tag_current_safe_tf";
    private TFJniApiBinder chipBinder = null;
    private final String tag = "XdjaTFProcessService";
    ArrayList<Bundle> tfInfoBundleList = new ArrayList();
    private HashMap<String, TFJniApiBinder> pathBinderMap = new HashMap();
    private static TFJniApiHandle instance;
    private Context context;

    private TFJniApiHandle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TFJniApiHandle getInstance() {
        if (instance != null) return instance;
        Class<TFJniApiHandle> clazz = TFJniApiHandle.class;
        synchronized (TFJniApiHandle.class) {
            if (instance != null) return instance;
            instance = new TFJniApiHandle();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ArrayList<Bundle> getCurrentTFCardInfo(Context context) {
        this.context = context;
        return (ArrayList)this.getResult();
    }

    private boolean isChipGetted(ArrayList<Bundle> bundleList, JniApiParam chipParam) {
        boolean isInList = false;
        for (Bundle bundle : bundleList) {
            JniApiParam chipParamInList = (JniApiParam)bundle.getParcelable("JniApiParam");
            if (chipParamInList == null || !chipParam.cardId.equalsIgnoreCase(chipParamInList.cardId)) continue;
            isInList = true;
            break;
        }
        return isInList;
    }

    private TFJniApiBinder handleJniApiBinder(Context context, String tfcardPath) {
        this.chipBinder = this.pathBinderMap.get(tfcardPath);
        if (this.chipBinder == null) {
            this.chipBinder = this.createJniApiBinder(context, tfcardPath);
        }
        return this.chipBinder;
    }

    private synchronized TFJniApiBinder createJniApiBinder(Context context, String tfcardPath) {
        if (this.pathBinderMap.containsKey(tfcardPath)) {
            return this.pathBinderMap.get(tfcardPath);
        }
        TFJniApiBinder binder = new TFJniApiBinder(context, tfcardPath);
        this.pathBinderMap.put(tfcardPath, binder);
        return binder;
    }

    void handleMediaRemoved(Context context) {
        JarMultiChipStatusManager.getInstance().sendCardStatus(context, "", 2, -1);
        if (this.tfInfoBundleList.size() > 0) {
            ArrayList<Bundle> currentTFCardInfo = this.getCurrentTFCardInfo(context);
            this.updateTFInfoInCache(currentTFCardInfo);
            this.sendTFInfoChangeBroadcast(context, action_tf_removed, this.tfInfoBundleList);
            Log.w((String)"XdjaTFProcessService", (String)"exitProcess: ");
            this.exitProcess();
        }
    }

    private void exitProcess() {
        Process.killProcess((int)Process.myPid());
        System.exit(0);
    }

    void handleMediaMounted(Context context) {
        ArrayList<Bundle> currentTFCardInfo = this.getCurrentTFCardInfo(context);
        if (!currentTFCardInfo.isEmpty()) {
            if (this.tfInfoBundleList.isEmpty()) {
                this.tfInfoBundleList.addAll(currentTFCardInfo);
                this.sendTFInfoChangeBroadcast(context, action_tf_mounted, this.tfInfoBundleList);
            } else {
                this.updateTFInfoInCache(currentTFCardInfo);
                this.sendTFInfoChangeBroadcast(context, action_tf_mounted, this.tfInfoBundleList);
            }
        } else {
            this.tfInfoBundleList.clear();
            this.sendTFInfoChangeBroadcast(context, action_tf_mounted, new ArrayList<Bundle>(0));
        }
    }

    private void sendTFInfoChangeBroadcast(Context context, String action, ArrayList<Bundle> bundles) {
        Intent tfAddBroadcastIntent = new Intent();
        tfAddBroadcastIntent.setAction(action);
        tfAddBroadcastIntent.putParcelableArrayListExtra(tag_currrent_tf, bundles);
        context.sendBroadcast(tfAddBroadcastIntent);
    }

    private void updateTFInfoInCache(List<Bundle> currentTFCardInfo) {
        JniApiParam chipParam;
        HashMap<String, Bundle> currentInfoMap = new HashMap<String, Bundle>();
        for (Bundle bundle : currentTFCardInfo) {
            JniApiParam chipParam2 = (JniApiParam)bundle.getParcelable("JniApiParam");
            if (chipParam2 == null) continue;
            currentInfoMap.put(chipParam2.cardId, bundle);
        }
        int cacheListSize = this.tfInfoBundleList.size();
        for (int i = cacheListSize - 1; i >= 0; --i) {
            Bundle bundle = this.tfInfoBundleList.get(i);
            if (bundle == null) {
                this.tfInfoBundleList.remove(i);
                continue;
            }
            JniApiParam chipParam3 = (JniApiParam)bundle.getParcelable("JniApiParam");
            if (chipParam3 == null) {
                this.tfInfoBundleList.remove(i);
                continue;
            }
            if (currentInfoMap.get(chipParam3.cardId) != null) continue;
            this.tfInfoBundleList.remove(i);
        }
        HashMap<String, Bundle> tfInfoInCacheMap = new HashMap<String, Bundle>();
        for (Bundle bundle : this.tfInfoBundleList) {
            chipParam = (JniApiParam)bundle.getParcelable("JniApiParam");
            if (chipParam == null) continue;
            tfInfoInCacheMap.put(chipParam.cardId, bundle);
        }
        for (Bundle bundle : currentTFCardInfo) {
            chipParam = (JniApiParam)bundle.getParcelable("JniApiParam");
            if (chipParam == null || tfInfoInCacheMap.get(chipParam.cardId) != null) continue;
            this.tfInfoBundleList.add(bundle);
        }
    }

    @Override
    protected ArrayList<Bundle> getRunResult() {
        ArrayList<Bundle> bundleList = new ArrayList<Bundle>();
        List<String> allExternalSdCardPath = TFCardUtils.getSuspicionSDCardPath(this.context);
        boolean findTfFlag = false;
        if (allExternalSdCardPath.size() > 0) {
            for (String sdcardPath : allExternalSdCardPath) {
                Log.i((String)"XdjaTFProcessService", (String)("sdcardPath: " + sdcardPath));
                TFJniApiBinder tfJniApiBinder = this.handleJniApiBinder(this.context, sdcardPath);
                JniApiParam chipParam = tfJniApiBinder.getJniApiParam();
                if (chipParam == null || this.isChipGetted(bundleList, chipParam)) continue;
                findTfFlag = true;
                JarMultiChipStatusManager.getInstance().sendCardStatus(this.context, chipParam.cardId, chipParam.chipType, 1);
                Bundle bundle = new Bundle();
                bundle.putBinder("Binder", tfJniApiBinder.asBinder());
                bundle.putParcelable("JniApiParam", (Parcelable)chipParam);
                Log.w((String)"XdjaTFProcessService", (String)"bundleList.add");
                bundleList.add(bundle);
                break;
            }
        }
        if (!findTfFlag) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(this.context, "", 2, -1);
        }
        this.tfInfoBundleList.clear();
        this.tfInfoBundleList.addAll(bundleList);
        return bundleList;
    }
}

