/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperJniApiBinder;
import com.xdja.multichip.process.vhsm.net.NetVhsmFileListener;
import com.xdja.multichip.process.vhsm.net.NetVhsmJniApi;
import com.xdja.multichip.utils.FuncUtils;

public class NetVhsmJniapiBinder
extends SuperJniApiBinder {
    private static NetVhsmJniApi jniApi;
    private static final String TAG = "netVhsmTag";
    private static NetVhsmJniapiBinder instance;
    int unableFlag = 0;
    private static final int FLAG_UNABLE = -1;
    private static final String VHSM_ACTION = "com.xdja.vhsm.action";

    private NetVhsmJniapiBinder(Context context) {
        super(context);
        if (jniApi == null) {
            jniApi = new NetVhsmJniApi(context);
        }
        this.registerReceiver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetVhsmJniapiBinder getInstance(Context context) {
        if (instance != null) return instance;
        Class<NetVhsmJniapiBinder> clazz = NetVhsmJniapiBinder.class;
        synchronized (NetVhsmJniapiBinder.class) {
            if (instance != null) return instance;
            instance = new NetVhsmJniapiBinder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected JNIAPI getApi() {
        return this.getNetVHSMJniApi();
    }

    protected NetVhsmJniApi getNetVHSMJniApi() {
        return jniApi;
    }

    @Override
    protected int selfOpenDev() {
        this.mHandle = 0L;
        int[] devNum = new int[1];
        int ret = this.getApi().EnumDev(0, devNum);
        if (ret != 0) {
            return ret;
        }
        if (devNum[0] <= 0) {
            return -97;
        }
        long[] handle = new long[1];
        ret = this.getApi().OpenDev(0, handle);
        if (ret == 0) {
            this.mHandle = handle[0];
            NetVhsmFileListener.getInstance().startObserver();
        }
        return ret;
    }

    @Override
    public JniApiParam getJniApiParam() {
        boolean flag;
        JniApiParam jniApiParam = super.getJniApiParam();
        if (jniApiParam != null && !(flag = FuncUtils.isLetterDigit(jniApiParam.cardId))) {
            jniApiParam = null;
            this.closeDev();
        }
        return jniApiParam;
    }

    @Override
    protected int getChipType() {
        return 32;
    }

    public void closeDev() {
        this.getApi().CloseDev(this.mHandle);
        this.mHandle = 0L;
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey("method")) {
            String method = bundle.getString("method");
            if ("UnlockPinUseUsn".equals(method)) {
                return super.callMethod(bundle);
            }
            if ("SM4".equals(method)) {
                return this.SM4(bundle);
            }
            if ("SetCardChangeListener".equals(method)) {
                return null;
            }
            if ("clearContainer".equals(method)) {
                return super.callMethod(bundle);
            }
        }
        return super.callMethod(bundle);
    }

    private Bundle SM4(Bundle bundle) {
        Bundle result = new Bundle();
        byte[] dataIn = bundle.getByteArray("dataIn");
        int dataLen = bundle.getInt("dataLen");
        int flag = bundle.getInt("flag");
        byte kID = bundle.getByte("kID");
        byte[] IV = bundle.getByteArray("IV");
        byte[] dataOut = new byte[dataLen];
        int[] outLen = new int[2];
        int ret = -10001;
        try {
            ret = this.getNetVHSMJniApi().SM4(this.mHandle, dataIn, dataLen, flag, dataOut, kID, IV);
            if (this.isDevOnline(ret)) {
                ret = this.getNetVHSMJniApi().SM4(this.mHandle, dataIn, dataLen, flag, dataOut, kID, IV);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = -10001;
        }
        result.putInt("ret", ret);
        result.putByteArray("dataOut", dataOut);
        result.putByteArray("IV", IV);
        return result;
    }

    @Override
    protected boolean isDevOnline(int errCode) throws RemoteException {
        if (errCode == -1 || errCode == -101 || errCode == -9) {
            this.selfOpenDev();
            return this.mHandle != 0L;
        }
        return false;
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (this.unableFlag == -1) {
            reply.writeNoException();
            reply.writeInt(-10002);
            this.notifyClientProxyDeath();
            return true;
        }
        return super.onTransact(code, data, reply, flags);
    }

    private void registerReceiver() {
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                int result = intent.getIntExtra("Result", -1);
                long time = intent.getLongExtra("Time", -1L);
                Log.e((String)NetVhsmJniapiBinder.TAG, (String)(action + " " + result + " " + time));
                NetVhsmJniapiBinder.this.closeDev();
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(VHSM_ACTION);
        this.mContext.registerReceiver(receiver, intentFilter);
    }
}

