/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.xdja.multichip.utils.GetValueFromProperties;
import java.util.ArrayList;

public class AccessControlJni {
    public static final int OK = 0;
    public static final int CAN_NOT_USE = -101;
    private Context context;
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";
    private static ArrayList<String> METHOD_LIST = new ArrayList();

    public AccessControlJni(Context context) {
        this.context = context;
    }

    public int checkByPkgName(String pkgName, String method) {
        try {
            int ret = this.judgeMethodIsNeedCheck(method);
            if (ret == 0) {
                return ret;
            }
            ret = this.judgeVerifyFlag(this.context);
            if (ret == 0) {
                return ret;
            }
            ret = this.judgeIsSystemApp(this.context, pkgName);
            if (ret == 0) {
                return ret;
            }
            ret = this.judgeSignatures(this.context, pkgName);
            if (ret == 0) {
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -101;
    }

    private int judgeVerifyFlag(Context context) {
        String verifyPkgFlag = GetValueFromProperties.getValue(context, "config.properties", "verifyPkgFlag");
        if (TextUtils.isEmpty((CharSequence)verifyPkgFlag) || STR_FALSE.equals(verifyPkgFlag)) {
            return 0;
        }
        return -101;
    }

    private int judgeMethodIsNeedCheck(String method) {
        if (!METHOD_LIST.contains(method)) {
            return 0;
        }
        return -101;
    }

    private int judgeIsSystemApp(Context context, String pkgName) {
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo info = pm.getApplicationInfo(pkgName, 0);
            if ((info.flags & 1) != 0) {
                return 0;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return -101;
    }

    private int judgeSignatures(Context context, String pkgName) {
        String selfPkgName = context.getPackageName();
        if (selfPkgName.equals(pkgName)) {
            return 0;
        }
        PackageManager pm = context.getPackageManager();
        if (pm.checkSignatures(pkgName, selfPkgName) == 0) {
            return 0;
        }
        return -101;
    }

    static {
        METHOD_LIST.add("ChangePIN");
        METHOD_LIST.add("ReloadPIN");
    }
}

