/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.jar.forcallprovider.ForCallProvider;
import com.xdja.multichip.process.IChipForCall;
import java.util.ArrayList;
import java.util.List;

public abstract class SuperChipForCall
implements IChipForCall {
    public static final String TAG = "SuperChipForCall";
    protected Context context;

    @Override
    public List<Bundle> getJniApiBinder() {
        boolean canUse = this.isCanUse();
        if (!canUse) {
            Log.e((String)TAG, (String)(this.getChipName() + " canUse = false"));
            return null;
        }
        String authority = this.getProviderAuthority(this.context, this.getProviderClass().getName());
        if (TextUtils.isEmpty((CharSequence)authority)) {
            Log.e((String)TAG, (String)(this.getProviderClass().getName() + " authority is null."));
            return null;
        }
        Uri uri = Uri.parse((String)("content://" + authority));
        ContentResolver resolver = this.context.getContentResolver();
        Bundle bundle = resolver.call(uri, "GetJniApiBinder", "", null);
        if (bundle == null) {
            Log.e((String)TAG, (String)(this.getChipName() + " ChipForCall GetJniApiBinder bundle = null"));
            return null;
        }
        int ret = bundle.getInt("ret");
        if (ret != 0) {
            Log.e((String)TAG, (String)(this.getChipName() + " bundle ret = " + ret));
            return null;
        }
        ArrayList result = bundle.getParcelableArrayList("JniApiParam");
        if (result == null) {
            Log.e((String)TAG, (String)(this.getChipName() + " result is null"));
        } else {
            Log.e((String)TAG, (String)(this.getChipName() + " result size = " + result.size()));
        }
        return result;
    }

    protected abstract Class getProviderClass();

    public String getProviderAuthority(Context context, String providerClassName) {
        if (TextUtils.isEmpty((CharSequence)providerClassName) || context == null) {
            return "";
        }
        String pkgName = ForCallProvider.getCallPkg((Context)context);
        if (TextUtils.isEmpty((CharSequence)pkgName)) {
            return "";
        }
        PackageManager pm = context.getPackageManager();
        ComponentName cn = new ComponentName(pkgName, providerClassName);
        String authority = "";
        try {
            ProviderInfo pi = pm.getProviderInfo(cn, 128);
            authority = pi.authority;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return authority;
    }
}

