/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process;

import android.util.Log;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class SuperThreadRun<T> {
    private static final String TAG = "ThreadRunTag";
    public static ExecutorService service = Executors.newCachedThreadPool();
    boolean runFunFlag = false;
    private LinkedList<CallBack> callBackList = new LinkedList();

    protected abstract T getRunResult();

    public T getResult() {
        final CountDownLatch latch = new CountDownLatch(1);
        final Object[] result = new Object[1];
        CallBack callBack = new CallBack(){

            public void callBack(Object msg) {
                result[0] = msg;
                latch.countDown();
            }
        };
        this.callBackList.add(callBack);
        this.runFun();
        Log.e((String)TAG, (String)"runFun start.");
        try {
            latch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.e((String)TAG, (String)"runFun end.");
        return (T)result[0];
    }

    private void runFun() {
        if (this.runFunFlag) {
            Log.e((String)TAG, (String)"runFun true return");
            return;
        }
        this.runFunFlag = true;
        Future submit = service.submit(new Callable<T>(){

            @Override
            public T call() {
                Object result = SuperThreadRun.this.getRunResult();
                SuperThreadRun.this.runFunFlag = false;
                Log.e((String)SuperThreadRun.TAG, (String)"runFun getResult ");
                return result;
            }
        });
        try {
            CallBack callBack;
            final Object result = submit.get();
            while ((callBack = this.callBackList.poll()) != null) {
                service.submit(new Runnable(){

                    @Override
                    public void run() {
                        callBack.callBack(result);
                    }
                });
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    static interface CallBack<T> {
        public void callBack(T var1);
    }
}

