/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.bluetooth;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Pair;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.blesafekey.BleCallback;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperJniApiBinder;
import com.xdja.multichip.process.bluetooth.JniApiBluetoothKey;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class JniApiBluetoothKeyBinder
extends SuperJniApiBinder {
    public static final int RET_EXCEPTION = -1;
    private String connBleDevAddr;
    private String connBleDevName;
    private ArrayList<Messenger> setCallBackList = new ArrayList();
    JniApiBluetoothKey api = new JniApiBluetoothKey();

    private JniApiBluetoothKeyBinder(Context context, String connBleDevAddr, String connBleDevName) {
        super(context);
        this.connBleDevAddr = connBleDevAddr;
        this.connBleDevName = connBleDevName;
    }

    public static Pair<Integer, JniApiBluetoothKeyBinder> make(Context context, String connBleDevAddr, String connBleDevName) {
        JniApiBluetoothKeyBinder instance = new JniApiBluetoothKeyBinder(context, connBleDevAddr, connBleDevName);
        try {
            int state = instance.selfOpenDev(30000);
            if (state == 258) {
                return Pair.create((Object)0, (Object)((Object)instance));
            }
            return Pair.create((Object)state, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Pair.create((Object)-1, null);
        }
    }

    @Override
    protected JNIAPI getApi() {
        return this.api;
    }

    @Override
    public int selfOpenDev() throws RemoteException {
        return this.selfOpenDev(500);
    }

    private int selfOpenDev(int waitTime) {
        this.devInfo = null;
        final CountDownLatch latch = new CountDownLatch(1);
        this.api.getBlueApi().ConnectService(this.mContext, this.connBleDevAddr, this.connBleDevName);
        this.api.getBlueApi().SetCallBack(new BleCallback(){

            public void OnBleStateChange(int newStatus) {
                if (newStatus == 258) {
                    latch.countDown();
                }
                JniApiBluetoothKeyBinder.this.notifyCallBack(newStatus);
            }
        });
        try {
            latch.await(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.api.getBlueApi().GetBleState();
    }

    @Override
    protected int getChipType() {
        return 4;
    }

    @Override
    public JniApiParam getJniApiParam() {
        JniApiParam param = super.getJniApiParam();
        if (param != null) {
            param.other = JniApiBluetoothKeyBinder.convertToKey(this.connBleDevAddr, this.connBleDevName);
        }
        return param;
    }

    @Override
    protected boolean isDevOnline(int errcode) throws RemoteException {
        if (errcode == -97 || errcode == -1) {
            this.selfOpenDev();
            if (this.api.getBlueApi().GetBleState() == 4) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        String method = bundle.getString("method");
        if ("GetBleState".equals(method)) {
            return this.methodGetBleState();
        }
        if ("SetCallBack".equals(method)) {
            return this.methodSetCallBack(bundle);
        }
        if ("UnlockPinUseUsn".equals(method)) {
            return super.callMethod(bundle);
        }
        if ("GetBleBattery".equals(method)) {
            return this.methodGetBattery();
        }
        return super.callMethod(bundle);
    }

    private Bundle methodSetCallBack(Bundle bundle) {
        Bundle result = new Bundle();
        result.putInt("ret", 0);
        if (!bundle.containsKey("Messenger")) {
            result.putInt("ret", -1);
        } else {
            IBinder binder = bundle.getBinder("Messenger");
            if (binder == null) {
                result.putInt("ret", -1);
            } else {
                final Messenger messenger = new Messenger(binder);
                this.setCallBackList.add(messenger);
                try {
                    binder.linkToDeath(new IBinder.DeathRecipient(){

                        public void binderDied() {
                            JniApiBluetoothKeyBinder.this.setCallBackList.remove(messenger);
                        }
                    }, 0);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private Bundle methodUnlockPinUseUsn() {
        Bundle result = new Bundle();
        result.putInt("ret", -1001);
        return result;
    }

    private Bundle methodGetBleState() {
        Bundle result = new Bundle();
        int ret = this.api.getBlueApi().GetBleState();
        result.putInt("ret", ret);
        return result;
    }

    private Bundle methodGetBattery() {
        Bundle result = new Bundle();
        int ret = this.api.getBlueApi().GetBattery();
        result.putInt("ret", ret);
        return result;
    }

    public static String convertToKey(String devAddress, String devName) {
        return devAddress + "#" + devName;
    }

    public void handleDisconnect() {
        this.api.getBlueApi().DisConnectService();
    }

    private void notifyCallBack(int newStatus) {
        for (Messenger messenger : this.setCallBackList) {
            Message msg = new Message();
            msg.what = 1;
            msg.arg1 = newStatus;
            try {
                messenger.send(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

