/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.cardstatus;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.multichip.ICardStatusBinder;
import com.xdja.multichip.process.SuperThreadRun;
import java.util.ArrayList;
import java.util.HashMap;

public class CardStatusBinderService
extends ICardStatusBinder.Stub {
    private final String TAG = CardStatusBinderService.class.getSimpleName() + "Log";
    private static CardStatusBinderService instance;
    private Context context;
    private ArrayList<Messenger> messengerList = new ArrayList();
    HashMap<Integer, CardTypeInfo> cardTypeInfoMap = new HashMap();
    private ArrayList<IBinder> linkToDeathBinderList = new ArrayList();

    private CardStatusBinderService(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        this.initData();
        this.sendBroadcast(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CardStatusBinderService getInstance(Context context) {
        if (instance != null) return instance;
        Class<CardStatusBinderService> clazz = CardStatusBinderService.class;
        synchronized (CardStatusBinderService.class) {
            if (instance != null) return instance;
            instance = new CardStatusBinderService(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void initData() {
        CardTypeInfo onboard = new CardTypeInfo(1);
        CardTypeInfo tf = new CardTypeInfo(2);
        CardTypeInfo bluetooth = new CardTypeInfo(4);
        CardTypeInfo covered = new CardTypeInfo(8);
        CardTypeInfo vhsm = new CardTypeInfo(16);
        CardTypeInfo vhsm_net = new CardTypeInfo(32);
        this.cardTypeInfoMap.put(onboard.cardType, onboard);
        this.cardTypeInfoMap.put(tf.cardType, tf);
        this.cardTypeInfoMap.put(bluetooth.cardType, bluetooth);
        this.cardTypeInfoMap.put(covered.cardType, covered);
        this.cardTypeInfoMap.put(vhsm.cardType, vhsm);
        this.cardTypeInfoMap.put(vhsm_net.cardType, vhsm_net);
    }

    private void sendBroadcast(Context context) {
        Log.e((String)this.TAG, (String)"sendBroadcast..........");
        Intent intent = new Intent();
        intent.setAction("com_xdja_multichip_CardStatusServiceStart");
        context.sendBroadcast(intent);
    }

    public Bundle callMethod(Bundle bundle) throws RemoteException {
        Bundle result = new Bundle();
        if (bundle == null) {
            result.putInt("ret", -10000);
            return result;
        }
        if (!bundle.containsKey("method")) {
            result.putInt("ret", -10027);
            return result;
        }
        String method = bundle.getString("method");
        if ("registerListener".equals(method)) {
            return this.registerListener(bundle);
        }
        if ("sendCardStatus".equals(method)) {
            return this.sendSafeCardStatus(bundle);
        }
        if ("cardProcessRegister".equals(method)) {
            return this.cardProcessRegister(bundle);
        }
        result.putInt("ret", -10027);
        return result;
    }

    private Bundle cardProcessRegister(Bundle bundle) {
        Bundle result = new Bundle();
        if (CardStatusBinderService.getCallingUid() != Process.myUid()) {
            result.putInt("ret", -10028);
            return result;
        }
        IBinder binder = bundle.getBinder("Binder");
        int cardType = bundle.getInt("cardType");
        Log.e((String)this.TAG, (String)("CardProcessRegister cardType = " + cardType));
        this.linkToDeath(binder, cardType);
        result.putInt("ret", 0);
        return result;
    }

    private void linkToDeath(final IBinder binder, final int cardType) {
        if (binder == null) {
            return;
        }
        try {
            this.linkToDeathBinderList.add(binder);
            binder.linkToDeath(new IBinder.DeathRecipient(){

                public void binderDied() {
                    Log.e((String)CardStatusBinderService.this.TAG, (String)("binder linkToDeath cardType = " + cardType));
                    CardStatusBinderService.this.handleMsg("", cardType, -1);
                    CardStatusBinderService.this.linkToDeathBinderList.remove(binder);
                }
            }, 0);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private Bundle registerListener(Bundle bundle) {
        Log.e((String)this.TAG, (String)"registerListener............");
        Bundle result = new Bundle();
        IBinder binder = bundle.getBinder("messenger");
        final Messenger messenger = new Messenger(binder);
        for (Messenger m : this.messengerList) {
            if (!m.equals((Object)messenger)) continue;
            result.putInt("ret", 0);
            return result;
        }
        this.messengerList.add(messenger);
        try {
            binder.linkToDeath(new IBinder.DeathRecipient(){

                public void binderDied() {
                    CardStatusBinderService.this.messengerList.remove(messenger);
                }
            }, 0);
            result.putInt("ret", 0);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            result.putInt("ret", -10001);
        }
        return result;
    }

    private Bundle sendSafeCardStatus(Bundle bundle) {
        Bundle result = new Bundle();
        int callingUid = CardStatusBinderService.getCallingUid();
        if (callingUid != Process.myUid()) {
            result.putInt("ret", -10028);
            return result;
        }
        String cardId = bundle.getString("cardId");
        int cardType = bundle.getInt("cardType");
        int status = bundle.getInt("status");
        result.putInt("ret", 0);
        Log.e((String)this.TAG, (String)("cardId = " + cardId + "  cardType = " + cardType + "  status = " + status));
        this.handleMsg(cardId, cardType, status);
        return result;
    }

    private synchronized void handleMsg(final String cardId, final int cardType, final int status) {
        SuperThreadRun.service.submit(new Runnable(){

            @Override
            public void run() {
                String card = "";
                if (!TextUtils.isEmpty((CharSequence)cardId)) {
                    card = cardId;
                }
                CardTypeInfo info = CardStatusBinderService.this.cardTypeInfoMap.get(cardType);
                Log.e((String)CardStatusBinderService.this.TAG, (String)info.toString());
                if (info.status != status || !info.cardId.equals(card)) {
                    info.status = status;
                    info.cardId = card;
                    CardStatusBinderService.this.notifyMessenger(info);
                }
            }
        });
    }

    private synchronized void notifyMessenger(CardTypeInfo info) {
        Log.e((String)this.TAG, (String)("notify cardType = " + info.cardType + " status = " + info.status));
        for (Messenger messenger : this.messengerList) {
            Message msg = Message.obtain();
            msg.what = 1;
            Bundle bundle = new Bundle();
            bundle.putInt("cardType", info.cardType);
            bundle.putInt("status", info.status);
            bundle.putString("cardId", info.cardId);
            msg.obj = bundle;
            try {
                messenger.send(msg);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    class CardTypeInfo {
        int cardType;
        String cardId = "";
        int status = -1;

        public CardTypeInfo(int cardType) {
            this.cardType = cardType;
        }

        public String toString() {
            return "CardTypeInfo{cardType=" + this.cardType + ", cardId='" + this.cardId + '\'' + ", status=" + this.status + '}';
        }
    }
}

