/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Pair;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_DIR;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_KEY_ATTR;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.crypto.XDJACrypto;
import com.xdja.multichip.jniapi.Arithmetic;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.process.coveredcard.CCCacheManager;
import com.xdja.tmc.TMCAPI;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CCJniApi
extends JNIAPI {
    private static final String TAG = "CCJniApi";
    public static final int RET_NOT_SUPPORT_METHOD = -1001;
    private static CCJniApi ccJniApi;
    private TMCAPI mApi;
    private HandlerThread handlerThread = new HandlerThread("cc_jniapi");
    private Handler ccJniApiHandler;
    private Context context;

    public CCJniApi(Context context) {
        this.context = context;
        this.handlerThread.start();
        this.ccJniApiHandler = new Handler(this.handlerThread.getLooper());
        final CountDownLatch latch = new CountDownLatch(1);
        this.ccJniApiHandler.post(new Runnable(){

            @Override
            public void run() {
                CCJniApi.this.mApi = new TMCAPI();
                latch.countDown();
            }
        });
        try {
            latch.await(3500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CCJniApi getInstance(Context context) {
        if (ccJniApi != null) return ccJniApi;
        Class<CCJniApi> clazz = CCJniApi.class;
        synchronized (CCJniApi.class) {
            if (ccJniApi != null) return ccJniApi;
            ccJniApi = new CCJniApi(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ccJniApi;
        }
    }

    TMCAPI getTMCAPI() {
        return this.mApi;
    }

    public synchronized int syncOpenCoveredCard() {
        final CountDownLatch latch = new CountDownLatch(1);
        final boolean[] isSupportedFlag = new boolean[]{false};
        this.openCoveredCard(new TMCAPI.TMCAPICallBack(){

            public void isSupported(boolean b) {
                isSupportedFlag[0] = b;
                latch.countDown();
            }
        });
        try {
            latch.await(3500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (isSupportedFlag[0]) {
            return 0;
        }
        return -1;
    }

    private synchronized void openCoveredCard(final TMCAPI.TMCAPICallBack tmcapiCallBack) {
        this.ccJniApiHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Log.e((String)CCJniApi.TAG, (String)"=================== openCard ");
                    if (CCJniApi.this.judgeSimIsReady(CCJniApi.this.context) != 0) {
                        if (tmcapiCallBack != null) {
                            tmcapiCallBack.isSupported(false);
                        }
                        return;
                    }
                    final long startTime = System.currentTimeMillis();
                    try {
                        int len = 8;
                        byte[] random = new byte[len];
                        byte[] tmp = new byte[len];
                        Arrays.fill(tmp, (byte)0);
                        int ret = ccJniApi.getTMCAPI().GenRandom(len, random);
                        if (ret == 0 && !Arrays.equals(tmp, random)) {
                            if (tmcapiCallBack != null) {
                                tmcapiCallBack.isSupported(true);
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ccJniApi.getTMCAPI().CloseSEService();
                    Log.w((String)CCJniApi.TAG, (String)"OpenSEService OpenSEService before");
                    ccJniApi.getTMCAPI().OpenSEService(CCJniApi.this.context, new TMCAPI.TMCAPICallBack(){

                        public void isSupported(boolean b) {
                            if (tmcapiCallBack != null) {
                                tmcapiCallBack.isSupported(b);
                            }
                            if (b) {
                                String otiType = ccJniApi.getTMCAPI().GetOtiType();
                                Log.w((String)CCJniApi.TAG, (String)("OpenSEService is supported " + b + " otiType: " + otiType));
                                long nowTime = System.currentTimeMillis();
                                Log.e((String)CCJniApi.TAG, (String)("startTime = " + startTime + "  nowTime = " + nowTime));
                                if (startTime != -1L && nowTime - startTime > 3500L) {
                                    XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
                                    int ret = ccJniApi.getTMCAPI().GetDevInfo(devInfo);
                                    Log.e((String)CCJniApi.TAG, (String)("ret = " + ret));
                                    if (ret == 0) {
                                        String cardId = new String(devInfo.cardid).trim();
                                        Log.e((String)CCJniApi.TAG, (String)("cardId = " + cardId));
                                        JarMultiChipStatusManager.getInstance().sendCardStatus(CCJniApi.this.context, cardId, 8, 1);
                                    }
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private int judgeSimIsReady(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        int state = tm.getSimState();
        Log.e((String)TAG, (String)("=================== simState = " + state));
        if (state == 5) {
            return 0;
        }
        return -1;
    }

    public int GetVersion(byte[] verion, int[] ver_len) {
        return -1001;
    }

    public int EnumDev(int devType, int[] devNum) {
        return -1001;
    }

    public int OpenDev(int index, long[] hHandle) {
        return -1001;
    }

    public int OpenDevByName(byte[] devName, long[] hHandle) {
        return -1001;
    }

    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) {
        return -1001;
    }

    public int CloseDev(long handle) {
        return -1001;
    }

    public int LockDev(long handle) {
        return -1001;
    }

    public int UnlockDev(long handle) {
        return -1001;
    }

    public int Transmit(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) {
        return -1001;
    }

    public int GetDevInfo(long handle, XDJA_DEVINFO devInfo) {
        XDJA_DEVINFO cacheDevInfo = CCCacheManager.getInstance().getDevInfo();
        if (cacheDevInfo != null) {
            System.arraycopy(cacheDevInfo.cardid, 0, devInfo.cardid, 0, cacheDevInfo.cardid.length);
            devInfo.cardtype = cacheDevInfo.cardtype;
            devInfo.reserve = cacheDevInfo.reserve;
            System.arraycopy(cacheDevInfo.cosver, 0, devInfo.cosver, 0, cacheDevInfo.cosver.length);
            return 0;
        }
        int ret = this.mApi.GetDevInfo(devInfo);
        if (ret == 0) {
            CCCacheManager.getInstance().setDevInfo(devInfo);
        }
        return ret;
    }

    public int GetDevInfoPri(long handle, XDJA_DEVINFO devInfo) {
        int ret = this.mApi.GetDevInfo(devInfo);
        if (ret == 0) {
            CCCacheManager.getInstance().setDevInfo(devInfo);
        }
        return ret;
    }

    public int SetLogPath(byte[] logPath) {
        return -1001;
    }

    public int ActivateCard(long handle, byte[] param, int paramLen) {
        return 0;
    }

    public int GetActivateState(long handle) {
        return 0;
    }

    public int ChangePIN(long handle, int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) {
        if (newLen < 6 || newLen > 16) {
            return -9;
        }
        return this.mApi.ChangePIN(pinRole, oldPin, oldLen, newPin, newLen);
    }

    public int GetPinTryCount(long handle, int pinRole) {
        return this.mApi.GetPINTryCount(pinRole);
    }

    public int VerifyPIN(long handle, int pinRole, byte[] pin, int pinLen) {
        return this.mApi.VerifyPIN(pinRole, pin, pinLen);
    }

    public int UnlockPIN(long handle, int id, byte[] key, int keyLen, byte[] newPin, int newLen) {
        return -1001;
    }

    public int ReloadPIN(long handle, int pinRole, byte[] key, int keyLen, byte[] newPin, int newLen) {
        return this.mApi.ReloadPIN(pinRole, key, keyLen, newPin, newLen);
    }

    public int CardReset(long handle) {
        return -1001;
    }

    public int ExternAuth(long handle, byte exterAuthID, byte[] encRandom) {
        return -1001;
    }

    public int InterAuth(long handle, byte[] dataIn, int inLen, int flag, byte kID, byte[] tmpKey, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int CreateDir(long handle, XDJA_DIR dir) {
        return -1001;
    }

    public int SelectFile(long handle, byte[] fid) {
        return this.mApi.SelectFile(fid);
    }

    public int DeleteFile(long handle, byte[] fid) {
        return this.mApi.DeleteFile(fid);
    }

    public int GetDirSize(long handle, int[] size) {
        return -1001;
    }

    public int CreateFile(long handle, XDJA_FILE file) {
        return this.mApi.CreateFile(file);
    }

    public int GetFileInfo(long handle, byte[] fid, XDJA_FILE file) {
        return this.mApi.GetFileInfo(fid, file);
    }

    public int ReadFile(long handle, byte[] fid, int readPos, int readLen, byte[] dataOut) {
        return this.mApi.ReadFile(fid, readPos, readLen, dataOut);
    }

    public int WriteFile(long handle, byte[] fid, int writePos, int writeLen, byte[] dataIn) {
        return this.mApi.WriteFile(fid, writePos, writeLen, dataIn);
    }

    public int ReadRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        return this.mApi.ReadRsaPubKey(pubfid, pubKey);
    }

    public int WriteRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        return this.mApi.WriteRsaPubKey(pubfid, pubKey);
    }

    public int WriteRsaPriKey(long handle, byte[] prifid, XDJA_RSA_PRIKEY priKey) {
        return this.mApi.WriteRsaPriKey(prifid, priKey);
    }

    public int ReadSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        return this.mApi.ReadSm2PubKey(pubfid, pubKey);
    }

    public int WriteSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        return this.mApi.WriteSm2PubKey(pubfid, pubKey);
    }

    public int WriteSm2PriKey(long handle, byte[] prifid, XDJA_SM2_PRIKEY priKey) {
        return this.mApi.WriteSm2PriKey(prifid, priKey);
    }

    public int ReadCert(long handle, byte[] fid, byte[] certBuf, int[] certLen) {
        Pair<byte[], Integer> certPair = CCCacheManager.getInstance().getCert(fid);
        if (certPair != null) {
            System.arraycopy(certPair.first, 0, certBuf, 0, (Integer)certPair.second);
            certLen[0] = (Integer)certPair.second;
            this.checkCertIsCorrect(fid, certBuf, certLen[0]);
            return 0;
        }
        int ret = this.mApi.ReadCert(fid, certBuf, certLen);
        if (ret == 0) {
            byte[] tmp = new byte[certLen[0]];
            System.arraycopy(certBuf, 0, tmp, 0, certLen[0]);
            CCCacheManager.getInstance().setCert(fid, tmp, certLen[0]);
            this.checkCertIsCorrect(fid, tmp, certLen[0]);
        }
        return ret;
    }

    public int WriteCert(long handle, byte[] fid, byte[] certBuf, int certLen) {
        int ret = this.mApi.WriteCert(fid, certBuf, certLen);
        if (ret == 0) {
            byte[] tmp = new byte[certLen];
            System.arraycopy(certBuf, 0, tmp, 0, certLen);
            CCCacheManager.getInstance().setCert(fid, tmp, certLen);
        }
        return ret;
    }

    public int GenRandom(long handle, int len, byte[] random) {
        return this.mApi.GenRandom(len, random);
    }

    public int DESKEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int DES3KEY(long handle, byte[] tmpKey, int tmpkeyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int AESKEY(long handle, byte[] tmpKey, int keyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int CreateKey(long handle, XDJA_KEY_ATTR keyAttr) {
        return -1001;
    }

    public int ImportKey(long handle, int type, byte[] dataIn, byte kID) {
        return -1001;
    }

    public int SM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        return this.mApi.SM1(dataIn, inLen, flag, dataOut, kID, IV);
    }

    public int ImportTmpKey(long handle, byte[] tmpKey) {
        return -1001;
    }

    public int TmpSM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int ImportCipherKey(long handle, byte[] tmpKey, int alg) {
        return -1001;
    }

    public int TmpCipher(long handle, byte[] dataIn, int inLen, int alg, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int SM1KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return this.mApi.SM1KEY(tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    public int SSF33(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int SM4KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return this.mApi.SM4KEY(tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    public int SM4KEYEx(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int SM6KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return -1001;
    }

    public int GenRSAKeyPair(long handle, int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pubkey, XDJA_RSA_PRIKEY prikey) {
        if (pubfid[0] == 0 && pubfid[1] == 0) {
            return -1001;
        }
        if (prifid[0] == 0 && prifid[1] == 0) {
            return -1001;
        }
        return this.mApi.GenRSAKeyPair(bits, pubfid, prifid);
    }

    public int RSAPubKeyCalc(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (pubfid[0] == 0 && pubfid[1] == 0) {
                return this.mApi.RSAPubKeyCalc(pubkey, dataIn, inLen, dataOut, outLen);
            }
            return this.mApi.RSAPubKeyCalc(pubfid, inLen * 8, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1001;
        }
    }

    public int RSAPriKeyCalc(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return this.mApi.RSAPriKeyCalc(prifid, inLen * 8, dataIn, inLen, dataOut, outLen);
    }

    public int RSAPriKeyCalcEx(long handle, byte[] pin, int pinLen, int pinRole, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return -1001;
    }

    public int RSASign(long handle, int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return this.mApi.RSASign(prifid, bits, dataType, dataIn, inLen, dataOut, outLen);
    }

    public int RSASignVerify(long handle, int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        if (pubfid[0] == 0 && pubfid[1] == 0) {
            return -1001;
        }
        return this.mApi.RSASignVerify(pubfid, bits, dataType, dataIn, inLen, signatureData, signatureData.length);
    }

    public int PackEnvelope(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int alg, byte[] dataOut, int[] outLen) {
        return -1001;
    }

    public int UnpackEnvelope(long handle, byte[] prifid, int alg, byte[] dataIn, int inLen) {
        return -1001;
    }

    public int KeyDisperse(long handle, int keyId, byte[] keyParam, int keyParamLen) {
        return -1001;
    }

    public int SetSM2Id(long handle, byte[] sm2Id, int inLen) {
        return this.mApi.SetSM2Id(sm2Id, inLen);
    }

    public int GetSM2Id(long handle, byte[] sm2Id, int[] outLen) {
        return this.mApi.GetSM2Id(sm2Id, outLen);
    }

    public int SetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return this.mApi.SetSM2Param(param);
    }

    public int GetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return this.mApi.GetSM2Param(param);
    }

    public int GenSM2KeyPair(long handle, byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) {
        if (pubfid[0] == 0 && pubfid[1] == 0) {
            return -1001;
        }
        if (prifid[0] == 0 && prifid[1] == 0) {
            return -1001;
        }
        return this.mApi.GenSM2KeyPair(pubfid, prifid);
    }

    public int SM2Encrypt(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (pubfid[0] == 0 && pubfid[1] == 0) {
                return this.mApi.SM2Encrypt(pubkey, dataIn, inLen, dataOut, outLen);
            }
            return this.mApi.SM2Encrypt(pubfid, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -100;
        }
    }

    public int SM2EncryptGM(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (pubfid[0] == 0 && pubfid[1] == 0) {
                return this.mApi.SM2Encrypt(pubkey, dataIn, inLen, dataOut, outLen);
            }
            return this.mApi.SM2EncryptGM(pubfid, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -100;
        }
    }

    public int SM2Decrypt(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return this.mApi.SM2Decrypt(prifid, dataIn, inLen, dataOut, outLen);
    }

    public int SM2DecryptGM(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return this.mApi.SM2DecryptGM(prifid, dataIn, inLen, dataOut, outLen);
    }

    public int SM2Sign(long handle, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return this.mApi.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
    }

    public int SM2SignVerify(long handle, byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        try {
            if (pubfid[0] == 0 && pubfid[1] == 0) {
                if (pubkey == null) {
                    return -18;
                }
                return this.mApi.SM2SignVerify(pubkey, dataType, dataIn, inLen, signatureData, signatureData.length);
            }
            return this.mApi.SM2SignVerify(pubfid, dataType, dataIn, inLen, signatureData, signatureData.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -100;
        }
    }

    public int SM2SignEx(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] signatureData, int[] signatureDataLen) {
        return -1001;
    }

    public int SM2SignVerifyEx(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        return -1001;
    }

    public int SHA1(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return -1001;
    }

    public int SHA1Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return -1001;
    }

    public int SM3(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        XDJACrypto crypto = new XDJACrypto("");
        int ret = crypto.SM3Init();
        if (ret != 0) {
            return ret;
        }
        ret = crypto.SM3Update(dataIn, inLen);
        if (ret != 0) {
            return ret;
        }
        ret = crypto.SM3Final(dataOut);
        return ret;
    }

    public int SM3Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return -1001;
    }

    public int SM2KeyGenInit(long handle, byte[] pubfid, byte[] dataOut, int[] outLen) {
        return -1001;
    }

    public int SM2KeyGenCompute(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, byte dictFlag, byte keyFlag) {
        return -1001;
    }

    public int SM2KeyGenVerify(long handle, byte[] dataIn, int inLen) {
        return -1001;
    }

    public int GetUsbMountPath(long handle, int type, byte[] path) {
        return -1001;
    }

    public int SetUsbRWMode(long handle, int mode) {
        return -1001;
    }

    public int ReadUsbNormalSecs(long handle, int addr, short secs, byte[] data) {
        return -1001;
    }

    public int WriteUsbNormalSecs(long handle, int addr, short secs, byte[] data) {
        return -1001;
    }

    public int OpenUsbSecuZone(long handle, byte[] pass, int passLen) {
        return -1001;
    }

    public int CloseUsbSecuZone(long handle) {
        return -1001;
    }

    public int ChgUsbSecuZonePin(long handle, byte[] oldPass, int oldLen, byte[] newPass, int newLen, int type) {
        return -1001;
    }

    public int UnlockUsbSecuZone(long handle, byte[] key, int keyLen, byte[] pin, int pinLen) {
        return -1001;
    }

    public int InitUsbHiddZone(long handle) {
        return -1001;
    }

    public int GetUsbHiddZoneSize(long handle, int[] size) {
        return -1001;
    }

    public int ReadUsbHiddZone(long handle, int addr, byte[] dataOut, int readLen) {
        return -1001;
    }

    public int WriteUsbHiddZone(long handle, int addr, byte[] dataIn, int writeLen) {
        return -1001;
    }

    public int ExecUsbScsiCmd(long handle, byte[] CDBbuff, int cdbLength, byte[] sendDataBuf, int sendDataLen, byte[] recvDataBuf, int[] recvDataLen) {
        return -1001;
    }

    public int If2gKey(long handle) {
        return -1001;
    }

    public int gKeySign(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, int dataType) {
        return -1001;
    }

    public int GetRemainPower(long handle, int[] power) {
        return -1001;
    }

    public int GetTFMountPath(long handle, byte[] mountPath, int[] pathLen) {
        return -1001;
    }

    public int GetTFZoneSize(long handle, int[] size) {
        return -1001;
    }

    public int ReadTFZone(long handle, int sectorStart, byte[] dataBuf, int buffSize) {
        return -1001;
    }

    public int WriteTFZone(long handle, int sectorStart, byte[] dataBuf, int buffSize) {
        return -1001;
    }

    public int SM4(byte[] dataIn, int dataLen, int flag, byte[] dataOut, int[] outLen, byte kID, byte[] IV) {
        return this.mApi.SM4(dataIn, dataLen, flag, dataOut, outLen, kID, IV);
    }

    private void checkCertIsCorrect(final byte[] fid, final byte[] certBuf, final int certLen) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    X509Certificate x509Certificate = Arithmetic.getX509Certificate((byte[])certBuf, (int)certLen);
                    if (x509Certificate != null) {
                        Log.d((String)"CC_cert", (String)"cache cert not null");
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Log.d((String)"CC_cert", (String)"cache cert >> null or err <<<");
                CCCacheManager.getInstance().removeCert(fid);
            }
        }).start();
    }
}

