/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperJniApiBinder;
import com.xdja.multichip.process.coveredcard.CCCacheManager;
import com.xdja.multichip.process.coveredcard.CCJniApi;
import com.xdja.multichip.process.coveredcard.CCProcessProvider;
import com.xdja.multichip.process.coveredcard.CCProcessService;
import java.util.ArrayList;
import java.util.Arrays;

public class CCJniApiBinder
extends SuperJniApiBinder {
    public static final String TAG = "CCJniApiBinderTag";
    private Context context;
    private CCJniApi ccJniApi = null;
    private static CCJniApiBinder instance;
    XDJA_DEVINFO lastDevInfo = new XDJA_DEVINFO();
    XDJA_DEVINFO mDevInfo = new XDJA_DEVINFO();
    ArrayList<Messenger> messengerList = new ArrayList();
    Boolean flag = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CCJniApiBinder getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (instance != null) return instance;
        Class<CCJniApiBinder> clazz = CCJniApiBinder.class;
        synchronized (CCJniApiBinder.class) {
            if (instance != null) return instance;
            instance = new CCJniApiBinder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private CCJniApiBinder(Context context) {
        super(context);
        this.context = context;
    }

    @Override
    protected JNIAPI getApi() {
        this.ccJniApi = CCJniApi.getInstance(this.context);
        return this.ccJniApi;
    }

    @Override
    public JniApiParam getJniApiParam() {
        int ret = CCJniApi.getInstance(this.context).syncOpenCoveredCard();
        if (ret != 0) {
            return null;
        }
        return super.getJniApiParam();
    }

    @Override
    protected int selfOpenDev() throws RemoteException {
        int ret;
        this.devInfo = null;
        if (this.canUse() && (ret = CCJniApi.getInstance(this.context).syncOpenCoveredCard()) == 0) {
            XDJA_DEVINFO ccDevInfo = new XDJA_DEVINFO();
            CCJniApi.getInstance(this.context).GetDevInfo(-1L, ccDevInfo);
            if (!Arrays.equals(this.lastDevInfo.cardid, ccDevInfo.cardid)) {
                this.lastDevInfo.cardid = Arrays.copyOf(ccDevInfo.cardid, ccDevInfo.cardid.length);
                this.lastDevInfo.cardtype = ccDevInfo.cardtype;
                this.lastDevInfo.cosver = Arrays.copyOf(ccDevInfo.cosver, ccDevInfo.cosver.length);
                this.lastDevInfo.reserve = ccDevInfo.reserve;
                this.devInfo = this.lastDevInfo;
                this.notifyListenerChange();
            }
        }
        return 0;
    }

    @Override
    protected boolean isDevOnline(int errcode) throws RemoteException {
        if (errcode == -100 || errcode == -2) {
            this.selfOpenDev();
            CCJniApi ccJniApi = (CCJniApi)this.getApi();
            if (ccJniApi != null) {
                try {
                    int tmp = ccJniApi.GetDevInfoPri(0L, new XDJA_DEVINFO());
                    if (tmp == 0) {
                        return true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                CCCacheManager.getInstance().clear();
            }
        } else if (errcode == -12) {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                if (!stackTraceElement.getMethodName().contains("VerifyPIN")) continue;
                this.selfOpenDev();
                CCJniApi ccJniApi = (CCJniApi)this.getApi();
                if (ccJniApi != null && ccJniApi.GetDevInfoPri(0L, new XDJA_DEVINFO()) == 0) {
                    return true;
                }
                CCCacheManager.getInstance().clear();
                break;
            }
        }
        return false;
    }

    @Override
    protected int getChipType() {
        return 8;
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey("method")) {
            String method = bundle.getString("method");
            if ("UnlockPinUseUsn".equals(method)) {
                return super.callMethod(bundle);
            }
            if ("SM4".equals(method)) {
                return this.SM4(bundle);
            }
            if ("SetCardChangeListener".equals(method)) {
                return this.setCardChangeListener(bundle);
            }
            if ("clearContainer".equals(method)) {
                Bundle result = super.callMethod(bundle);
                if (result.getInt("ret") == 0) {
                    CCCacheManager.getInstance().clear();
                }
                return result;
            }
        }
        return super.callMethod(bundle);
    }

    private Bundle SM4(Bundle bundle) {
        Bundle result = new Bundle();
        byte[] dataIn = bundle.getByteArray("dataIn");
        int dataLen = bundle.getInt("dataLen");
        int flag = bundle.getInt("flag");
        byte kID = bundle.getByte("kID");
        byte[] IV = bundle.getByteArray("IV");
        byte[] dataOut = new byte[dataLen];
        int[] outLen = new int[2];
        int ret = -10001;
        try {
            ret = CCJniApi.getInstance(this.context).SM4(dataIn, dataLen, flag, dataOut, outLen, kID, IV);
            if (this.isDevOnline(ret)) {
                ret = CCJniApi.getInstance(this.context).SM4(dataIn, dataLen, flag, dataOut, outLen, kID, IV);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = -10001;
        }
        result.putInt("ret", ret);
        result.putByteArray("dataOut", dataOut);
        result.putByteArray("IV", IV);
        return result;
    }

    private Bundle setCardChangeListener(Bundle bundle) {
        Bundle result = new Bundle();
        IBinder binder = bundle.getBinder("Binder");
        if (binder != null) {
            Messenger messenger = new Messenger(binder);
            this.messengerList.add(messenger);
        }
        return result;
    }

    boolean canUse() {
        if (this.flag.booleanValue()) {
            this.flag = false;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SystemClock.sleep((long)2000L);
                    CCJniApiBinder.this.flag = true;
                }
            }).start();
            return true;
        }
        return false;
    }

    private void notifyListenerChange() {
        for (Messenger messenger : this.messengerList) {
            if (messenger.getBinder().isBinderAlive()) {
                Message msg = new Message();
                msg.what = 1;
                msg.obj = this.lastDevInfo;
                try {
                    messenger.send(msg);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.messengerList.remove(messenger);
        }
    }

    void handleSimAbsent() {
        try {
            this.devInfo = null;
            CCJniApi.getInstance(this.context).getTMCAPI().CloseSEService();
            JarMultiChipStatusManager.getInstance().sendCardStatus(this.context, "", 8, -1);
            Log.w((String)TAG, (String)"Sim state change to absent!Process exit!!!!");
            this.exitProcess();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exitProcess() {
        Intent intent = new Intent(this.context, CCProcessService.class);
        this.context.stopService(intent);
        new Thread(new Runnable(){

            @Override
            public void run() {
                int count = 0;
                while (true) {
                    if (CCProcessProvider.getCallingFlag() == 0 || count++ > 60) {
                        Process.killProcess((int)Process.myPid());
                        System.exit(0);
                        continue;
                    }
                    SystemClock.sleep((long)50L);
                }
            }
        }).start();
    }
}

