/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.util.Log;
import com.xdja.multichip.compat.ServiceCompatXdja;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.process.ProcessExitsReceiver;
import com.xdja.multichip.process.SuperThreadRun;
import com.xdja.multichip.process.coveredcard.CCJniApiHandle;
import com.xdja.multichip.process.coveredcard.CCProcessService;
import java.util.ArrayList;

public class CCProcessProvider
extends ContentProvider {
    private static final String TAG = "CCProcessProviderTag";
    private Messenger messenger = new Messenger(new Handler());
    private static int callingFlag = 0;

    public boolean onCreate() {
        Log.e((String)TAG, (String)("onCreate pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + this.getCallingPackage()));
        SuperThreadRun.service.submit(new Runnable(){

            @Override
            public void run() {
                JarMultiChipStatusManager.getInstance().cardProcessRegister(CCProcessProvider.this.getContext(), CCProcessProvider.this.messenger.getBinder(), 8);
            }
        });
        Intent intent = new Intent();
        intent.setClass(this.getContext(), CCProcessService.class);
        ServiceCompatXdja.startService(this.getContext(), intent);
        ProcessExitsReceiver.register(this.getContext());
        return false;
    }

    public Bundle call(String method, String arg, Bundle extras) {
        Log.e((String)TAG, (String)("call method: " + method));
        Log.e((String)TAG, (String)("calling pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + this.getCallingPackage()));
        Bundle bundle = new Bundle();
        if ("GetJniApiBinder".equals(method)) {
            CCProcessProvider.increaseFlag();
            ArrayList<Bundle> list = CCJniApiHandle.getInstance().getCurrentCoveredCardInfo(this.getContext());
            bundle.putInt("ret", 0);
            bundle.putParcelableArrayList("JniApiParam", list);
            Log.e((String)TAG, (String)("result list size = " + (list == null ? 0 : list.size())));
            CCProcessProvider.decreaseFlag();
            return bundle;
        }
        return super.call(method, arg, extras);
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    private static void increaseFlag() {
        ++callingFlag;
    }

    private static void decreaseFlag() {
        --callingFlag;
    }

    public static int getCallingFlag() {
        return callingFlag;
    }
}

