/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Pair;
import com.xdja.multichip.process.vhsm.VhsmBean;
import com.xdja.multichip.process.vhsm.VhsmUtils;
import com.xdja.multichip.utils.PermissionUtil;
import java.io.File;

public class DefaultVhsmBean
extends VhsmBean {
    private static DefaultVhsmBean instance;
    private Context context;
    private String defaultId;
    private String defaultCardId;
    private File defaultVhsmFile;
    private static final String CACHE_FILE_NAME = "default_vhsm";
    private static final String KEY_String_defaultCardId = "defaultCardId";
    private static final String KEY_String_defaultId = "defaultId";

    private DefaultVhsmBean(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultVhsmBean make(Context context) {
        if (instance != null) return instance;
        Class<DefaultVhsmBean> clazz = DefaultVhsmBean.class;
        synchronized (DefaultVhsmBean.class) {
            if (instance != null) return instance;
            instance = new DefaultVhsmBean(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getId() throws VhsmBean.VhsmBeanException {
        if (TextUtils.isEmpty((CharSequence)this.defaultId)) {
            this.getDefaultIdAndCardIdInCache();
        }
        if (!TextUtils.isEmpty((CharSequence)this.defaultId)) {
            return this.defaultId;
        }
        String id = VhsmUtils.getAndroidId(this.context);
        if (TextUtils.isEmpty((CharSequence)id) && TextUtils.isEmpty((CharSequence)(id = VhsmUtils.getImei(this.context)))) {
            id = VhsmUtils.getMacAddress(this.context);
        }
        if (!TextUtils.isEmpty((CharSequence)id)) {
            this.defaultId = id;
        }
        return this.defaultId;
    }

    @Override
    public String getCardId() throws VhsmBean.VhsmBeanException {
        if (!TextUtils.isEmpty((CharSequence)this.defaultCardId)) {
            return this.defaultCardId;
        }
        String id = this.getId();
        if (TextUtils.isEmpty((CharSequence)id)) {
            return "";
        }
        this.defaultCardId = VhsmUtils.calcVhsmCardId(id);
        this.saveDefaultIdAndCardIdInCache(id, this.defaultCardId);
        return this.defaultCardId;
    }

    @Override
    public File getVhsmDatFile() throws VhsmBean.VhsmBeanException {
        boolean granted = PermissionUtil.isGranted(this.context, "android.permission.WRITE_EXTERNAL_STORAGE");
        if (!granted) {
            throw new VhsmBean.VhsmBeanException("NoPermission");
        }
        String filePath = Environment.getExternalStorageDirectory().getPath() + "/xdja/vhsm";
        File vhsmDatafileDir = new File(filePath);
        if (!vhsmDatafileDir.exists() && !vhsmDatafileDir.mkdirs()) {
            throw new VhsmBean.VhsmBeanException("NoPermission");
        }
        String fileName = "vhsm_v1.dat";
        this.defaultVhsmFile = new File(vhsmDatafileDir, fileName);
        return this.defaultVhsmFile;
    }

    @Override
    public String getVhsmPwd() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            sb.append("1");
        }
        return sb.toString();
    }

    @Override
    public int handleVhsmBeanException(VhsmBean.VhsmBeanException e) {
        if (e.getMessage().equals("NoPermission")) {
            return -10029;
        }
        return -10001;
    }

    private synchronized void saveDefaultIdAndCardIdInCache(String id, String cardId) {
        if (TextUtils.isEmpty((CharSequence)cardId) || TextUtils.isEmpty((CharSequence)id)) {
            return;
        }
        SharedPreferences preferences = this.context.getSharedPreferences(CACHE_FILE_NAME, 0);
        SharedPreferences.Editor edit = preferences.edit();
        edit.putString(KEY_String_defaultCardId, cardId);
        edit.putString(KEY_String_defaultId, id);
        edit.apply();
        this.defaultCardId = cardId;
        this.defaultId = id;
    }

    private Pair<String, String> getDefaultIdAndCardIdInCache() {
        SharedPreferences preferences = this.context.getSharedPreferences(CACHE_FILE_NAME, 0);
        String cardId = preferences.getString(KEY_String_defaultCardId, "");
        String id = preferences.getString(KEY_String_defaultId, "");
        if (TextUtils.isEmpty((CharSequence)id) || TextUtils.isEmpty((CharSequence)cardId)) {
            return Pair.create((Object)"", (Object)"");
        }
        this.defaultId = id;
        this.defaultCardId = cardId;
        return Pair.create((Object)id, (Object)cardId);
    }
}

