/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class FuncUtils {
    public static final String PKG_SAFE_KEYSERVICE = "com.xdja.safekeyservice";
    private static final String PKG_SAFE_CLIENT = "com.xdja.safeclient";

    public static boolean isApkExist(Context context, String pkgName) {
        if (TextUtils.isEmpty((CharSequence)pkgName) || context == null) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(pkgName, 128);
            return packageInfo != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getCertFingerStr(Context context, String pkgName) {
        try {
            X509Certificate cert = FuncUtils.getSignCer(context, pkgName);
            return FuncUtils.format(FuncUtils.parseCerFingerprint(cert));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static X509Certificate getSignCer(Context context, String packName) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packName, 64);
            Signature[] signs = packageInfo.signatures;
            Signature signature = signs[0];
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String parseCerFingerprint(X509Certificate cert) {
        try {
            byte[] arrayOfByte = FuncUtils.convert1(cert.getEncoded());
            if (arrayOfByte == null) {
                return null;
            }
            return FuncUtils.convert2(arrayOfByte);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] convert1(byte[] data) {
        try {
            MessageDigest localMessageDigest = MessageDigest.getInstance("SHA1");
            return localMessageDigest.digest(data);
        }
        catch (NoSuchAlgorithmException localNoSuchAlgorithmException) {
            localNoSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    private static String convert2(byte[] data) {
        char[] arr = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(arr[(data[i] & 0xF0) >> 4]);
            sb.append(arr[data[i] & 0xF]);
        }
        return sb.toString();
    }

    private static String format(String str) {
        StringBuffer localStringBuffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            localStringBuffer.append(str.charAt(i));
            if (i <= 0 || i % 2 != 1 || i >= str.length() - 1) continue;
            localStringBuffer.append(":");
        }
        return localStringBuffer.toString();
    }

    public static boolean isLetterDigit(String str) {
        String regex = "^[a-z0-9A-Z]+$";
        return str.matches(regex);
    }
}

