package com.xdja.multichip;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;

import com.xdja.multichip.utils.GetCallUri;

/**
 * Created by guoyaxin on 2017/6/13.
 */

public class AccessControlManager {

    private Context context;

    private AccessControlManager(Context context) {
        this.context = context.getApplicationContext();
    }

    private static AccessControlManager acessControlManager;

    public static AccessControlManager getInstance(Context context) {

        if (acessControlManager == null) {
            synchronized (AccessControlManager.class) {
                if (acessControlManager == null) {
                    acessControlManager = new AccessControlManager(context);
                }
            }
        }

        return acessControlManager;
    }

    private IAccessControl iAccessControl;

    private IAccessControl getAccessControlBinder() {
        if (iAccessControl == null) {
            Uri uri = GetCallUri.getUri(this.context);
            if (uri == null){
                return null;
            }
            ContentResolver resolver = context.getContentResolver();
            Bundle bundle = resolver.call(uri, "GetBinder", "AccessControlBinder", null);
            if (bundle != null) {
                int ret = bundle.getInt("ret");
                if (ret == 0) {
                    IBinder binder = bundle.getBinder("Binder");
                    if (binder != null) {
                        iAccessControl = IAccessControl.Stub.asInterface(binder);

                        //add 2017年8月3日16:52:39 weizg 新增binder的死亡通知回调
                        try {
                            binder.linkToDeath(new IBinder.DeathRecipient() {
                                @Override
                                public void binderDied() {
                                    iAccessControl = null;
                                }
                            }, 0);
                        } catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        return iAccessControl;
    }

    /**
     * 根据包名判断
     *
     * @param pkgName 包名
     * @param method  要判断的方法
     * @return 0:可用；其他：不可用
     */
    public int checkByPkgName(String pkgName, String method) {
        int ret = -1;
        IAccessControl accessControl = getAccessControlBinder();
        if (accessControl == null) {
            return -1;
        }
        try {
            ret = accessControl.checkByPkgName(pkgName, method);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }


    /**
     * 根据Uid和Pid判断
     *
     * @param uid
     * @param pid
     * @param method 要判断的方法
     * @return 0:可用；其他：不可用
     */
    public int checkByUidPid(int uid, int pid, String method) {
        int ret = -1;
        IAccessControl accessControl = getAccessControlBinder();
        if (accessControl == null) {
            return -1;
        }
        try {
            ret = accessControl.checkByUidPid(uid, pid, method);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

}
