package com.xdja.multichip.process;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.jar.forcallprovider.ForCallProvider;
import com.xdja.multichip.param.ParamKeywords;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/12/27 <br/>
 */
public abstract class SuperChipForCall implements IChipForCall {

    public static final String TAG = "SuperChipForCall";

    protected Context context;

    @Override
    public List<Bundle> getJniApiBinder() {
        boolean canUse = isCanUse();
        if (!canUse) {
            Log.e(TAG, getChipName() + " canUse = false");
            return null;
        }
        String authority = getProviderAuthority(context, getProviderClass().getName());
        if (TextUtils.isEmpty(authority)) {
            Log.e(TAG, getProviderClass().getName() + " authority is null.");
            return null;
        }
        Uri uri = Uri.parse("content://" + authority);
        ContentResolver resolver = context.getContentResolver();
        Bundle bundle = resolver.call(uri, ParamKeywords.KEY_METHOD_GetJniApiBinder, "", null);
        if (bundle == null) {
            Log.e(TAG, getChipName() + " ChipForCall GetJniApiBinder bundle = null");
            return null;
        }

        int ret;
        ret = bundle.getInt(ParamKeywords.KEY_int_ret);
        if (ret != 0) {
            Log.e(TAG, getChipName() + " bundle ret = " + ret);
            return null;
        }

        ArrayList<Bundle> result = bundle.getParcelableArrayList(ParamKeywords.KEY_Parcelable_JniApiParam);
        if (result == null) {
            Log.e(TAG, getChipName() + " result is null");
        } else {
            Log.e(TAG, getChipName() + " result size = " + result.size());
        }
        return result;
    }

    protected abstract Class getProviderClass();


    /**
     * 获取要调用的Provider的Authority
     *
     * @param context
     * @param providerClassName
     * @return
     */
    public String getProviderAuthority(Context context, String providerClassName) {
        if (TextUtils.isEmpty(providerClassName) || context == null) {
            return "";
        }
        String pkgName = ForCallProvider.getCallPkg(context);
        if (TextUtils.isEmpty(pkgName)) {
            return "";
        }

        PackageManager pm = context.getPackageManager();
        ComponentName cn = new ComponentName(pkgName, providerClassName);
        String authority = "";
        try {
            ProviderInfo pi = pm.getProviderInfo(cn, PackageManager.GET_META_DATA);
            authority = pi.authority;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return authority;
    }


}
