package com.xdja.multichip.process;

import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Pair;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.JNIPinManager;
import com.xdja.multichip.jniapi.Arithmetic;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;
import com.xdja.multichip.param.ParamKeywords;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/4/28 <br/>
 */
public class SuperHandleMethod {
    private static SuperHandleMethod instance;

    private SuperHandleMethod() {

    }

    public static SuperHandleMethod getInstance() {
        if (instance == null) {
            synchronized (SuperHandleMethod.class) {
                if (instance == null) {
                    instance = new SuperHandleMethod();
                }
            }
        }
        return instance;
    }

    public Bundle callMethod(SuperJniApiBinder binder, Bundle bundle) {
        Bundle result = new Bundle();
        try {
            if (bundle == null) {
                return null;
            }
            if (bundle.containsKey(ParamKeywords.KEY_String_method)) {
                String method = bundle.getString(ParamKeywords.KEY_String_method);
                if (ParamKeywords.KEY_METHOD_UnlockPinUseUsn.equals(method)) {
                    return UnlockPinUseUsn(binder, bundle);
                } else if (ParamKeywords.KEY_METHOD_importCert.equals(method)) {
                    return new SupertImportCert().importCert(binder, bundle);
                } else if (ParamKeywords.KEY_METHOD_createContainer.equals(method)) {
                    return createContainer(binder, bundle);
                } else if (ParamKeywords.KEY_METHOD_genSM2KeyPair.equals(method)) {
                    return genSignSM2KeyPair(binder, bundle);
                } else if (ParamKeywords.KEY_METHOD_genExchangeSM2KeyPair.equals(method)) {
                    return genExchangeSM2KeyPair(binder, bundle);
                } else if (ParamKeywords.KEY_METHOD_genRSAKeyPair.equals(method)) {
                    return genSignRSAKeyPair(binder, bundle);
                } else if (ParamKeywords.KEY_METHOD_genExchangeRSAKeyPair.equals(method)) {
                    return genExchangeRSAKeyPair(binder, bundle);
                } else if (ParamKeywords.KEY_METHOD_clearContainer.equals(method)) {
                    return clearContainer(binder, bundle);
                } else if (ParamKeywords.KEY_METHOD_SendClientProxy.equals(method)) {
                    return addClientProxy(binder, bundle);
                }
            }
            result.putInt(ParamKeywords.KEY_int_ret, JarMultiJniApiErrorCode.NO_SUCH_METHOD);
        } catch (Exception e) {
            e.printStackTrace();
            result.putInt(ParamKeywords.KEY_int_ret, JarMultiJniApiErrorCode.RET_EXCEPTION);
        }

        return result;
    }

    /**
     * PIN码解锁
     *
     * @param binder
     * @param bundle
     * @return
     */
    public Bundle UnlockPinUseUsn(SuperJniApiBinder binder, Bundle bundle) {

        int role = bundle.getInt(ParamKeywords.KEY_int_role);
        byte[] usn = bundle.getByteArray(ParamKeywords.KEY_byteArray_usn);
        byte[] usnlockCode = bundle.getByteArray(ParamKeywords.KEY_byteArray_usnlockCode);
        byte[] newPin = bundle.getByteArray(ParamKeywords.KEY_String_newPin);

        int ret = JNIPinManager.getInstance().XdjaUnlockPinUseUsn(binder.getApi(), binder.mHandle, role, usn, usnlockCode, newPin);
        Bundle result = new Bundle();
        result.putInt(ParamKeywords.KEY_int_ret, ret);
        return result;
    }

    /**
     * 创建容器
     *
     * @param bundle 需要包含containerId  和 containerName
     * @return
     */
    public Bundle createContainer(SuperJniApiBinder binder, Bundle bundle) {
        int ret;
        Bundle result = new Bundle();
        try {
            int role = bundle.getInt(ParamKeywords.KEY_int_role);
            String pin = bundle.getString(ParamKeywords.KEY_String_pin);
            int containerId = bundle.getInt(ParamKeywords.KEY_int_containerId);

            // 如果是创建容器4 和 6的，那么角色要为 ROLE_D 和 ROLE_Q，否则不允许；
            // 其他容器的目前（2018-4-28）没有此要求
            if (containerId == 4 || containerId == 6) {
                if (role != JNIAPI.ROLE_D && role != JNIAPI.ROLE_Q) {
                    result.putInt(ParamKeywords.KEY_int_ret, JNIAPI.XKR_NO_POWER);
                    return result;
                }
            }
            ret = binder.VerifyPIN(binder.mHandle, role, pin.getBytes(), pin.length());
            if (ret != 0) {
                result.putInt(ParamKeywords.KEY_int_ret, ret);
                return result;
            }
            String containerName = bundle.getString(ParamKeywords.KEY_containerName);
            ret = new SuperHandleContainer().createContainer(binder, containerId, containerName);
        } catch (RemoteException e) {
            e.printStackTrace();
            ret = JarMultiJniApiErrorCode.RET_EXCEPTION;
        }
        result.putInt(ParamKeywords.KEY_int_ret, ret);
        return result;
    }

    /**
     * 在容器中产生SM2签名公私钥对
     *
     * @param binder
     * @param bundle
     * @return
     */
    public Bundle genSignSM2KeyPair(SuperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt(ParamKeywords.KEY_int_containerId);
        byte[] pubFid = Arithmetic.getSignPubKeyFid(containerId);
        byte[] priFid = Arithmetic.getSignPriKeyFid(containerId);
        return genSM2KeyPair(binder, pubFid, priFid);
    }

    /**
     * 在容器中产生SM2签名公私钥对
     *
     * @param binder
     * @param bundle
     * @return
     */
    public Bundle genExchangeSM2KeyPair(SuperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt(ParamKeywords.KEY_int_containerId);
        byte[] pubFid = Arithmetic.getExchangePubKeyFid(containerId);
        byte[] priFid = Arithmetic.getExchangePriKeyFid(containerId);
        return genSM2KeyPair(binder, pubFid, priFid);
    }

    private Bundle genSM2KeyPair(SuperJniApiBinder binder, byte[] pubFid, byte[] priFid) {
        int ret;
        try {
            ret = binder.GenSM2KeyPair(binder.mHandle, pubFid, priFid, null, null);
        } catch (RemoteException e) {
            e.printStackTrace();
            ret = JarMultiJniApiErrorCode.RET_EXCEPTION;
        }
        Bundle result = new Bundle();
        result.putInt(ParamKeywords.KEY_int_ret, ret);
        return result;
    }


    /**
     * @param binder
     * @param bundle
     * @return
     */
    public Bundle genSignRSAKeyPair(SuperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt(ParamKeywords.KEY_int_containerId);
        int bits = bundle.getInt(ParamKeywords.KEY_int_bits);
        byte[] pubFid = Arithmetic.getSignPubKeyFid(containerId);
        byte[] priFid = Arithmetic.getSignPriKeyFid(containerId);
        return genRsaKeyPair(binder, bits, pubFid, priFid);
    }

    /**
     * @param binder
     * @param bundle
     * @return
     */
    public Bundle genExchangeRSAKeyPair(SuperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt(ParamKeywords.KEY_int_containerId);
        int bits = bundle.getInt(ParamKeywords.KEY_int_bits);
        byte[] pubFid = Arithmetic.getExchangePubKeyFid(containerId);
        byte[] priFid = Arithmetic.getExchangePriKeyFid(containerId);
        return genRsaKeyPair(binder, bits, pubFid, priFid);
    }

    private Bundle genRsaKeyPair(SuperJniApiBinder binder, int bits, byte[] pubFid, byte[] priFid) {
        int ret;
        try {
            ret = binder.GenRSAKeyPair(binder.mHandle, bits, pubFid, priFid, null, null);
        } catch (RemoteException e) {
            e.printStackTrace();
            ret = JarMultiJniApiErrorCode.RET_EXCEPTION;
        }
        Bundle result = new Bundle();

        result.putInt(ParamKeywords.KEY_int_ret, ret);
        return result;
    }

    public Bundle clearContainer(SuperJniApiBinder binder, Bundle bundle) {
        Bundle result = new Bundle();
        int containerId = bundle.getInt(ParamKeywords.KEY_int_containerId, -1);
        int role = bundle.getInt(ParamKeywords.KEY_int_role);
        String pin = bundle.getString(ParamKeywords.KEY_String_pin, "");
        //去除0号容器的限制 modify by zhangxiaolong 2019-8-27 16:17:07

        try {
            int ret;

            byte[] exchangeCertFid = Arithmetic.getExchangeCertFid(containerId);
            byte[] signCertFid = Arithmetic.getSignCertFid(containerId);
            byte[] exchangePubFid = Arithmetic.getExchangePubKeyFid(containerId);
            byte[] exchangePriFid = Arithmetic.getExchangePriKeyFid(containerId);
            byte[] signPubFid = Arithmetic.getSignPubKeyFid(containerId);
            byte[] signPriFid = Arithmetic.getSignPriKeyFid(containerId);
            ArrayList<Pair<byte[], Integer>> list = new ArrayList<>();
            list.add(Pair.create(exchangeCertFid, 1));
            list.add(Pair.create(exchangePubFid, 2));
            list.add(Pair.create(exchangePriFid, 2));
            list.add(Pair.create(signCertFid, 1));
            list.add(Pair.create(signPubFid, 2));
            list.add(Pair.create(signPriFid, 2));

            //改为200个字节，减少时间。by zhangxiaolong 2019-11-4
            byte[] certBytes = new byte[200];
            byte[] keyBytes = new byte[200];
            Arrays.fill(certBytes, (byte) 0xff);
            Arrays.fill(keyBytes, (byte) 0xff);

            //将VerifyPin的代码提到循环外面，减少时间。by zhangxiaolong 2019-11-4
            ret = binder.VerifyPIN(binder.mHandle, role, pin.getBytes(), pin.length());
            if (ret != 0) {
                result.putInt(ParamKeywords.KEY_int_ret, ret);
                return result;
            }

            for (Pair<byte[], Integer> pair : list) {
                byte[] writeBytes;
                if (pair.second == 1) {
                    writeBytes = certBytes;
                } else {
                    writeBytes = keyBytes;
                }

                ret = binder.WriteFile(binder.mHandle, pair.first, 0, writeBytes.length, writeBytes);
                if (ret != 0) {
                    result.putInt(ParamKeywords.KEY_int_ret, ret);
                    return result;
                }
            }

            byte[] containerInfo = new byte[5];
            Arrays.fill(containerInfo, (byte) 0x00);
            byte[] infoFid = {0x00, 0x03};
            int writePos = containerId * 5;
            ret = binder.WriteFile(binder.mHandle, infoFid, writePos, 5, containerInfo);
            result.putInt(ParamKeywords.KEY_int_ret, ret);
        } catch (RemoteException e) {
            e.printStackTrace();
            result.putInt(ParamKeywords.KEY_int_ret, JarMultiJniApiErrorCode.RET_EXCEPTION);
        }

        return result;
    }

    private Bundle addClientProxy(SuperJniApiBinder binder, Bundle bundle) {
        IBinder messenger = bundle.getBinder(ParamKeywords.KEY_Binder_messenger);
        binder.addClientProxy(messenger);
        Bundle result = new Bundle();
        result.putInt(ParamKeywords.KEY_int_ret, 0);
        return result;
    }

}
