package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;

import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.SuperThreadRun;

import java.util.ArrayList;

/**
 * Created by xwy on 2017/9/14.
 */

public class CCJniApiHandle extends SuperThreadRun<ArrayList<Bundle>> {

    private static final String TAG = "CCJniApiHandleTag";

    private static CCJniApiHandle instance;

    public static CCJniApiHandle getInstance() {
        if (instance == null) {
            synchronized (CCJniApiHandle.class) {
                if (instance == null) {
                    instance = new CCJniApiHandle();
                }
            }
        }
        return instance;
    }

    private Context context;

    protected ArrayList<Bundle> getCurrentCoveredCardInfo(Context context) {
        this.context = context;
        return getResult();
    }

    @Override
    protected ArrayList<Bundle> getRunResult() {
        ArrayList<Bundle> list = new ArrayList<>();

        if (context == null) {
            Log.e(TAG, "getRunResult context = null");
            return list;
        }

        CCJniApiBinder binder = CCJniApiBinder.getInstance(context);

        //add 首先通过接口获取设备信息，如果能获取到就不再进行设备打开
        JniApiParam param;
        CCJniApi ccJniApi = (CCJniApi) binder.getApi();

        if (ccJniApi != null) {
            XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
            int ret = ccJniApi.GetDevInfoPri(-1, devInfo);
            Log.e(TAG, "ccJniApi GetDevInfoPri ret = " + ret);
            if (ret == 0) {
                param = new JniApiParam();
                param.chipType = binder.getChipType();
                param.cardId = new String(devInfo.cardid).trim();
            } else {
                param = binder.getJniApiParam();
            }
        } else {
            param = binder.getJniApiParam();
        }


        if (param != null) {
            Log.e(TAG, "param has values!");
            JarMultiChipStatusManager.getInstance().sendCardStatus(context, param.cardId, param.chipType, 1);
            Bundle bundle = new Bundle();
            bundle.putBinder(ParamKeywords.KEY_Binder_Binder, binder);
            bundle.putParcelable(ParamKeywords.KEY_Parcelable_JniApiParam, param);
            list.add(bundle);
        } else {
            Log.e(TAG, "param is null");
        }
        return list;
    }
}
