package com.xdja.multichip.process.coveredcard;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.util.Log;

import com.xdja.multichip.compat.ServiceCompatXdja;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.ProcessExitsReceiver;
import com.xdja.multichip.process.SuperThreadRun;

import java.util.ArrayList;

/**
 * Created by xwy on 2017/9/14.
 */
public class CCProcessProvider extends ContentProvider {
    private static final String TAG = "CCProcessProviderTag";
    private Messenger messenger = new Messenger(new Handler());

    @Override
    public boolean onCreate() {
        Log.e(TAG, "onCreate pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + getCallingPackage());

        SuperThreadRun.service.submit(new Runnable() {
            @Override
            public void run() {
                JarMultiChipStatusManager.getInstance().cardProcessRegister(getContext(), messenger.getBinder(), JniApiParam.TYPE_COVERED);
            }
        });

        Intent intent = new Intent();
        intent.setClass(getContext(), CCProcessService.class);
        ServiceCompatXdja.startService(getContext(), intent);

        ProcessExitsReceiver.register(getContext());
        return false;
    }


    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        Log.e(TAG, "call method: " + method);
        Log.e(TAG, "calling pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + getCallingPackage());
        Bundle bundle = new Bundle();
        if (ParamKeywords.KEY_METHOD_GetJniApiBinder.equals(method)) {
            increaseFlag();
            ArrayList<Bundle> list = CCJniApiHandle.getInstance().getCurrentCoveredCardInfo(getContext());
            bundle.putInt(ParamKeywords.KEY_int_ret, 0);
            bundle.putParcelableArrayList(ParamKeywords.KEY_Parcelable_JniApiParam, list);
            Log.e(TAG, "result list size = " + (list == null ? 0 : list.size()));
            decreaseFlag();
            return bundle;
        }
        return super.call(method, arg, extras);
    }


    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }


    @Override
    public String getType(Uri uri) {
        return null;
    }


    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    /**
     * add by zhangxiaolong 2018-10-16 10:53:22
     * 主要用于解决主进程provider调用贴膜卡进程provider时，
     * 贴膜卡进程直接exit会影响到主进程。
     */
    private static int callingFlag = 0;

    private static void increaseFlag() {
        ++callingFlag;
    }

    private static void decreaseFlag() {
        --callingFlag;
    }

    public static int getCallingFlag() {
        return callingFlag;
    }
}
