package com.xdja.multichip.process.tfcard;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.util.Log;

import com.xdja.multichip.compat.ServiceCompatXdja;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.ProcessExitsReceiver;
import com.xdja.multichip.process.SuperThreadRun;

import java.util.ArrayList;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/17 <br/>
 */

public class TFProcessProvider extends ContentProvider {

    private static final String TAG = "TfProcessTag";
    private Messenger messenger = new Messenger(new Handler());


    @Override
    public boolean onCreate() {
        Log.e(TAG, "onCreate pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + getCallingPackage());

        SuperThreadRun.service.submit(new Runnable() {
            @Override
            public void run() {
                JarMultiChipStatusManager.getInstance().cardProcessRegister(getContext(), messenger.getBinder(), JniApiParam.TYPE_TF);
            }
        });

        Intent intent = new Intent();
        intent.setClass(getContext(), TFProcessService.class);
        ServiceCompatXdja.startService(getContext(), intent);

        ProcessExitsReceiver.register(getContext());
        return false;
    }


    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }


    @Override
    public String getType(Uri uri) {
        return null;
    }


    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }


    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        Log.e(TAG, "call method: " + method);
        Log.e(TAG, "calling pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + getCallingPackage());
        Bundle bundle = new Bundle();
        if (ParamKeywords.KEY_METHOD_GetJniApiBinder.equals(method)) {
            ArrayList<Bundle> list = TFJniApiHandle.getInstance().getCurrentTFCardInfo(getContext());
            bundle.putInt(ParamKeywords.KEY_int_ret, 0);
            bundle.putParcelableArrayList(ParamKeywords.KEY_Parcelable_JniApiParam, list);
            Log.e(TAG, "result list size = " + (list == null ? 0 : list.size()));
            return bundle;
        }
        return super.call(method, arg, extras);
    }
}
