/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.tfcard;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperJniApiBinder;
import com.xdja.multichip.utils.ConvertUtil;
import java.util.Arrays;

public class TFJniApiBinder
extends SuperJniApiBinder {
    private final String tf_oper_path_part1 = "/Android/data/";
    private final String tf_oper_path_part2 = "/files/";
    private Context context;
    private String tfcardPath;
    private JNIAPI jniapi = new JNIAPI();

    public TFJniApiBinder(Context context, String tfcardPath) {
        super(context);
        this.context = context;
        this.tfcardPath = tfcardPath;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) throws RemoteException {
        int ret = this.getApi().OpenDevByName(devName, hHandle);
        if (ret == 0) {
            this.mHandle = hHandle[0];
        }
        return ret;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) throws RemoteException {
        int ret = this.getApi().OpenDevByNameEx(packagePath, hHandle);
        if (ret == 0) {
            this.mHandle = hHandle[0];
        }
        return ret;
    }

    @Override
    protected JNIAPI getApi() {
        return this.jniapi;
    }

    @Override
    protected int selfOpenDev() throws RemoteException {
        long[] devHandle = new long[1];
        this.mHandle = 0L;
        this.mContext.getExternalFilesDir(null);
        int ret = this.jniapi.OpenDevByNameEx(this.context.getPackageName().getBytes(), devHandle);
        if (ret != 0) {
            String tfPathTmp = this.tfcardPath;
            if (!tfPathTmp.endsWith("/")) {
                tfPathTmp = this.tfcardPath + "/";
            }
            ret = this.jniapi.OpenDevByName(tfPathTmp.getBytes(), devHandle);
        }
        if (ret == 0) {
            this.mHandle = devHandle[0];
            ret = this.judgeIsNanrui(this.mHandle);
        }
        return ret;
    }

    @Override
    protected int getChipType() {
        return 2;
    }

    @Override
    public JniApiParam getJniApiParam() {
        return super.getJniApiParam();
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        return super.callMethod(bundle);
    }

    private int judgeIsNanrui(long handle) {
        String flag;
        byte[] fid = new byte[]{0, 8};
        int len = 128;
        byte[] dataOut = new byte[len];
        int ret = this.jniapi.ReadFile(handle, fid, 0, len, dataOut);
        if (ret != 0) {
            return 0;
        }
        int contentLen = ConvertUtil.bytesToIntLe(dataOut);
        byte[] contentBytes = Arrays.copyOfRange(dataOut, 4, contentLen + 4);
        String content = new String(contentBytes);
        if (content.contains(flag = "v2=NT")) {
            this.jniapi.CloseDev(handle);
            this.mHandle = 0L;
            return -97;
        }
        return 0;
    }
}

