/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Pair;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.InsideMultiChipUnitePinManager;
import com.xdja.multichip.process.SuperJniApiBinder;
import com.xdja.multichip.process.vhsm.VhsmBean;
import com.xdja.multichip.process.vhsm.VhsmJniApi;
import java.io.File;
import java.util.HashMap;
import java.util.Set;

public class VhsmJniapiBinder
extends SuperJniApiBinder {
    private static VhsmJniApi jniApi = new VhsmJniApi();
    private VhsmBean vhsmBean;
    private File vhsmFile;
    private static HashMap<VhsmBean, VhsmJniapiBinder> mapBinder = new HashMap();
    int unableFlag = 0;
    private static final int FLAG_UNABLE = -1;

    private VhsmJniapiBinder(Context context, VhsmBean vhsmBean) {
        super(context);
        if (vhsmBean == null) {
            throw new NullPointerException("VhsmBean is null!");
        }
        this.vhsmBean = vhsmBean;
    }

    public static VhsmJniapiBinder make(Context context, VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (context == null || vhsmBean == null) {
            return null;
        }
        VhsmJniapiBinder binder = VhsmJniapiBinder.getBinderInMap(vhsmBean);
        if (binder == null) {
            binder = new VhsmJniapiBinder(context, vhsmBean);
            VhsmJniapiBinder.putBinderToMap(vhsmBean, binder);
        }
        return binder;
    }

    public static Pair<Integer, VhsmJniapiBinder> create(Context context, VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (context == null || vhsmBean == null) {
            return Pair.create((Object)-10000, null);
        }
        VhsmJniapiBinder.removeBinderInMap(vhsmBean);
        VhsmJniapiBinder binder = new VhsmJniapiBinder(context, vhsmBean);
        int ret = binder.init();
        if (ret == 0) {
            binder.clearPin(context, vhsmBean);
            VhsmJniapiBinder.putBinderToMap(vhsmBean, binder);
            return Pair.create((Object)0, (Object)((Object)binder));
        }
        return Pair.create((Object)ret, null);
    }

    private void clearPin(Context context, VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        InsideMultiChipUnitePinManager.getInstance().handlePinResult(context, vhsmBean.getCardId(), 1, "".getBytes(), -32, "init", "JNIAPI");
        InsideMultiChipUnitePinManager.getInstance().handlePinResult(context, vhsmBean.getCardId(), 17, "".getBytes(), -32, "init", "JNIAPI");
    }

    private static void putBinderToMap(VhsmBean vhsmBean, VhsmJniapiBinder binder) throws VhsmBean.VhsmBeanException {
        if (vhsmBean == null || binder == null) {
            return;
        }
        String cardId = vhsmBean.getCardId();
        Set<VhsmBean> vhsmSet = mapBinder.keySet();
        for (VhsmBean bean : vhsmSet) {
            try {
                if (!bean.getCardId().equals(cardId)) continue;
                VhsmJniapiBinder.removeBinderInMap(vhsmBean);
                VhsmJniapiBinder.putBinderToMap(vhsmBean, binder);
            }
            catch (VhsmBean.VhsmBeanException e) {
                VhsmJniapiBinder.removeBinderInMap(bean);
            }
        }
    }

    private static VhsmJniapiBinder getBinderInMap(VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (vhsmBean == null) {
            return null;
        }
        String cardId = vhsmBean.getCardId();
        String id = vhsmBean.getId();
        String filePath = vhsmBean.getVhsmDatFile().getAbsolutePath();
        String pwd = vhsmBean.getVhsmPwd();
        Set<VhsmBean> vhsmSet = mapBinder.keySet();
        for (VhsmBean bean : vhsmSet) {
            try {
                if (!bean.getCardId().equals(cardId) || !bean.getId().equals(id) || !bean.getVhsmDatFile().getAbsolutePath().equals(filePath) || !bean.getVhsmPwd().equals(pwd)) continue;
                return mapBinder.get(bean);
            }
            catch (VhsmBean.VhsmBeanException e) {
                VhsmJniapiBinder.removeBinderInMap(bean);
            }
        }
        return null;
    }

    private static void removeBinderInMap(VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (vhsmBean == null) {
            return;
        }
        String cardId = vhsmBean.getCardId();
        Set<VhsmBean> vhsmSet = mapBinder.keySet();
        for (VhsmBean bean : vhsmSet) {
            if (!bean.getCardId().equals(cardId)) continue;
            VhsmJniapiBinder removeBinder = mapBinder.remove(bean);
            removeBinder.setUnable(-1);
            removeBinder.notifyClientProxyDeath();
        }
    }

    @Override
    protected JNIAPI getApi() {
        return jniApi;
    }

    @Override
    protected int selfOpenDev() throws RemoteException {
        this.mHandle = 0L;
        int[] devNum = new int[1];
        int ret = this.getApi().EnumDev(0, devNum);
        if (ret != 0) {
            return ret;
        }
        if (devNum[0] <= 0) {
            return -97;
        }
        long[] handle = new long[1];
        ret = this.getApi().OpenDev(0, handle);
        if (ret == 0) {
            this.mHandle = handle[0];
        }
        return ret;
    }

    @Override
    protected int getChipType() {
        return 16;
    }

    @Override
    protected boolean isDevOnline(int errCode) throws RemoteException {
        if (errCode == -1 || errCode == -101 || errCode == -9) {
            this.selfOpenDev();
            return this.mHandle != 0L;
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    private int init() {
        try {
            File vhsmFile = this.vhsmBean.getVhsmDatFile();
            String pwd = this.vhsmBean.getVhsmPwd();
            if (!vhsmFile.getParentFile().exists()) {
                vhsmFile.getParentFile().mkdirs();
            }
            int ret = ((VhsmJniApi)this.getApi()).CreateDevFile(0, "".getBytes(), pwd.getBytes(), "".getBytes());
            return ret;
        }
        catch (VhsmBean.VhsmBeanException e) {
            e.printStackTrace();
            int ret = this.vhsmBean.handleVhsmBeanException(e);
            return ret;
        }
    }

    private void setUnable(int flag) {
        this.unableFlag = flag;
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        File vhsmFile = this.getVhsmFile();
        if (this.unableFlag == -1 || vhsmFile == null || !vhsmFile.exists()) {
            reply.writeNoException();
            reply.writeInt(-10002);
            this.notifyClientProxyDeath();
            return true;
        }
        return super.onTransact(code, data, reply, flags);
    }

    public File getVhsmFile() {
        if (this.vhsmFile == null && this.vhsmBean != null) {
            try {
                this.vhsmFile = this.vhsmBean.getVhsmDatFile();
            }
            catch (VhsmBean.VhsmBeanException e) {
                e.printStackTrace();
            }
        }
        return this.vhsmFile;
    }
}

