/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;
import com.xdja.multichip.AccessControlJni;
import com.xdja.multichip.IAccessControl;

public class AccessControlBinder
extends IAccessControl.Stub {
    private Context context;
    private AccessControlJni jni;

    public AccessControlBinder(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        this.jni = new AccessControlJni(context);
    }

    @Override
    public int checkByPkgName(String pkgName, String method) {
        if (this.context.getPackageName().equals(pkgName)) {
            return 0;
        }
        return this.jni.checkByPkgName(pkgName, method);
    }

    @Override
    public int checkByUidPid(int uid, int pid, String method) {
        String[] pkgList;
        if (uid == Process.myUid()) {
            return 0;
        }
        PackageManager pm = this.context.getPackageManager();
        for (String pkgName : pkgList = pm.getPackagesForUid(uid)) {
            int ret = this.checkByPkgName(pkgName, method);
            if (ret != 0) continue;
            return 0;
        }
        return -1;
    }
}

