package com.xdja.multichip.process.board;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;

import com.xdja.multichip.CallBackInfo;
import com.xdja.multichip.ISkfChip;
import com.xdja.multichip.MultiChip;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.process.IChipParamChangeListener;
import com.xdja.multichip.process.SupperChipBinder;

import java.util.ArrayList;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/5/26 <br/>
 * 操作板载芯片的service
 */
public class OnboardHandle implements IChipParamChangeListener {

    private ArrayList<IBinder> chipParamChangeBinderList = new ArrayList<>();

    private static OnboardHandle instance;

    private OnboardHandle() {

    }

    public static OnboardHandle getInstance() {
        if (instance == null) {
            synchronized (OnboardHandle.class) {
                if (instance == null) {
                    instance = new OnboardHandle();
                }
            }
        }
        return instance;
    }

    public int handleOnStartCommand(Context context, Intent intent, int flags, int startId) {
        if (intent != null) {
            actionHandle(context, intent);
        }
        return 0;
    }

    /**
     * 处理带action的Intent
     *
     * @param intent
     */
    private void actionHandle(Context context, Intent intent) {
        String actionValue = intent.getAction();
        if (actionValue.equals("getChipInfo")) {
            actionGetChipInfoHandle(context, intent);
        }
    }

    /**
     * 处理action为getChipInfo的Intent
     *
     * @param intent
     */
    private void actionGetChipInfoHandle(Context context, Intent intent) {
        String latchTag = intent.getStringExtra("latchTag");
        Bundle bundle = intent.getBundleExtra("bundle");
        IBinder binder = bundle.getBinder("binder");
        try {
            CallBackInfo.Stub.asInterface(binder).callBack(latchTag,
                    OnboardHandle.class.getName(),
                    getAllChipParams(context));
        } catch (RemoteException e) {
            e.printStackTrace();
        }

    }


    private void handleChipBinder(Context context) {
        if (chipParamChangeBinderList.size() > 0) {
            return;
        }
        if (OnboardDoubleSystemChipBinder.judgeConnectSystemService(context)) {
            chipParamChangeBinderList.add(OnboardDoubleSystemChipBinder.getInstance(context));
        } else {
            chipParamChangeBinderList.addAll(XdjaBinderManager.getInstance(context).getAllXdjaChipBinder());
        }
        int size = chipParamChangeBinderList.size();
        if (size == 0) {
            return;
        }
        for (IBinder iBinder : chipParamChangeBinderList) {
            ((SupperChipBinder) iBinder).regist(this);
        }
    }


    public ArrayList<Bundle> getAllChipParams(Context context) throws RemoteException {
        handleChipBinder(context);
        ArrayList<Bundle> bundles = new ArrayList<>();
        if (chipParamChangeBinderList.size() > 0) {
            for (IBinder binder : chipParamChangeBinderList) {
                ISkfChip skfChip = (ISkfChip) binder;
                Bundle bundle = new Bundle();
                bundle.putBinder(MultiChip.KEY_BINDER_BINDER, binder);
                bundle.putParcelable(MultiChip.KEY_PARCELABLE_CHIPPARAM, skfChip.getChipParam());
                bundles.add(bundle);
            }
        }

        return bundles;
    }


    @Override
    public void change(ChipParam chipParam) {
        for (int i = 0; i < chipParamChangeBinderList.size(); ) {
            IBinder binder = chipParamChangeBinderList.get(i);
            if (binder != null) {
                try {
                    CallBackInfo.Stub.asInterface(binder).chipParamChange(OnboardHandle.class.getName(),
                            binder,
                            chipParam);
                } catch (RemoteException e) {
                    e.printStackTrace();
                }
                i++;
            } else {
                chipParamChangeBinderList.remove(binder);
            }
        }
    }
}

