package com.xdja.multichip.process.board;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.ArrayList;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/17 <br/>
 */

public class OnboardProcessProvider extends ContentProvider {
    public static final String KEY_INT_RET = "ret";
    public static final String KEY_PARCELABLEARRAYLIST_RESULT = "result";

    @Override
    public boolean onCreate() {
        Intent intent = new Intent();
        intent.setClass(getContext(), OnboardProcessService.class);
        getContext().startService(intent);
        return false;
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }


    @Nullable
    @Override
    public Bundle call(@NonNull String method, @Nullable String arg, @Nullable Bundle extras) {
        Bundle bundle = new Bundle();

        if ("GetChipBinder".equals(method)) {
            synchronized (OnboardProcessProvider.class) {

                ArrayList<Bundle> list = null;
                try {
                    list = OnboardHandle.getInstance().getAllChipParams(getContext());
                } catch (RemoteException e) {
                    e.printStackTrace();
                }
                bundle.putInt(KEY_INT_RET, 0);
                bundle.putParcelableArrayList(KEY_PARCELABLEARRAYLIST_RESULT, list);
                return bundle;
            }
        } else if ("GetJniApiBinder".equals(method)) {
            synchronized (OnboardProcessProvider.class) {
                ArrayList<Bundle> list = OnboardJniApiHandle.getInstance().getAllJniApiParams(getContext());
                bundle.putInt(KEY_INT_RET, 0);
                bundle.putParcelableArrayList(KEY_PARCELABLEARRAYLIST_RESULT, list);
                return bundle;
            }
        }
        return super.call(method, arg, extras);
    }
}
