package com.xdja.multichip.process.coveredcard;

import android.Manifest;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.xdja.multichip.utils.PermissionUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/5/16 <br/>
 */
public class CCEventReceiver extends BroadcastReceiver {
    private final static String TAG = CCEventReceiver.class.getSimpleName();
    private final static String ACTION_SIM_STATE_CHANGED = "android.intent.action.SIM_STATE_CHANGED";

    @Override
    public void onReceive(Context context, Intent intent) {
        if(intent == null){
            Log.v("CC","CCEventReceiver intent null");
            return;
        }

        if (ACTION_SIM_STATE_CHANGED.equals(intent.getAction())) {
            TelephonyManager tm = (TelephonyManager) context
                    .getSystemService(Service.TELEPHONY_SERVICE);
            int state = tm.getSimState();

            Log.w(TAG, "Sim state :" + state);

            switch (state) {
                case TelephonyManager.SIM_STATE_READY:
                case 6:
                    if (hasPermission(context.getApplicationContext())) {
                        scanCC(context.getApplicationContext());
                    }
                    break;
                case TelephonyManager.SIM_STATE_ABSENT:
                    CCJniApiBinder.getInstance(context.getApplicationContext()).handleSimAbsent();
                    break;
                case TelephonyManager.SIM_STATE_UNKNOWN:
                case TelephonyManager.SIM_STATE_PIN_REQUIRED:
                case TelephonyManager.SIM_STATE_PUK_REQUIRED:
                case TelephonyManager.SIM_STATE_NETWORK_LOCKED:
                default:
                    break;
            }
        }
    }

    static int readyFlag = 0;

    private void scanCC(final Context context) {
        if (readyFlag == 1) {
            return;
        }
        readyFlag = 1;
        new Thread(new Runnable() {
            @Override
            public void run() {
                SystemClock.sleep(7 * 1000);
                CCJniApiHandle.getInstance().getCurrentCoveredCardInfo(context);
                readyFlag = 0;
            }
        }).start();

    }

    private boolean hasPermission(Context context) {

        List<String> permissions = new ArrayList<>();
        permissions.add(Manifest.permission.READ_SMS);
        permissions.add(Manifest.permission.SEND_SMS);
        permissions.add(Manifest.permission.RECEIVE_SMS);

        permissions.add(Manifest.permission.READ_CONTACTS);
        permissions.add(Manifest.permission.WRITE_CONTACTS);

        List<String> deniedPermissions = PermissionUtil.getDeniedPermissions(context, permissions);
        if (deniedPermissions.size() == 0) {
            return true;
        }
        return false;
    }
}
