package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.os.Bundle;

import com.xdja.multichip.GetMultiJniApiBinder;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;

import java.util.ArrayList;

/**
 * Created by xwy on 2017/9/14.
 */

public class CCJniApiHandle {

    private static final String tag = "XdjaCCBinder";


    private static CCJniApiHandle instance;


    public static CCJniApiHandle getInstance() {
        if (instance == null) {
            synchronized (CCJniApiHandle.class) {
                if (instance == null) {
                    instance = new CCJniApiHandle();
                }
            }
        }
        return instance;
    }

    protected ArrayList<Bundle> getCurrentCoveredCardInfo(Context context) {

        ArrayList<Bundle> list = new ArrayList<>();

        if (context == null){
            return list;
        }

        CCJniApiBinder binder = CCJniApiBinder.getInstance(context);
        if (binder == null) {
            return list;
        }
        JniApiParam param = binder.getJniApiParam();
        if (param != null) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(context,param.cardId,param.chipType,1);
            Bundle bundle = new Bundle();
            bundle.putBinder(GetMultiJniApiBinder.KEY_BINDER_BINDER, binder);
            bundle.putParcelable(GetMultiJniApiBinder.KEY_PARCELABLE_CHIPPARAM, param);
            list.add(bundle);
        }
        return list;
    }
}
